/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.Structures.Config;

import com.wuest.prefab.ModRegistry;
import com.wuest.prefab.Structures.Base.EnumStairsMaterial;
import com.wuest.prefab.Structures.Base.EnumStructureMaterial;
import com.wuest.prefab.Structures.Config.StructureConfiguration;
import com.wuest.prefab.Structures.Predefined.StructurePart;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;

public class StructurePartConfiguration
extends StructureConfiguration {
    public EnumStructureMaterial partMaterial;
    public EnumStairsMaterial stairsMaterial;
    public int generalWidth;
    public int generalHeight;
    public int stairWidth;
    public int stairHeight;
    public EnumStyle style;

    @Override
    public void Initialize() {
        super.Initialize();
        this.partMaterial = EnumStructureMaterial.Cobblestone;
        this.stairsMaterial = EnumStairsMaterial.Cobblestone;
        this.style = EnumStyle.DoorWay;
        this.stairHeight = 3;
        this.stairWidth = 2;
        this.generalHeight = 3;
        this.generalWidth = 3;
    }

    @Override
    public StructurePartConfiguration ReadFromCompoundNBT(CompoundNBT messageTag) {
        StructurePartConfiguration config = new StructurePartConfiguration();
        return (StructurePartConfiguration)super.ReadFromCompoundNBT(messageTag, config);
    }

    @Override
    protected void ConfigurationSpecificBuildStructure(PlayerEntity player, ServerWorld world, BlockPos hitBlockPos) {
        StructurePart structure = StructurePart.CreateInstance();
        if (structure.BuildStructure(this, world, hitBlockPos, Direction.NORTH, player)) {
            this.DamageHeldItem(player, ModRegistry.StructurePart());
        }
    }

    @Override
    protected CompoundNBT CustomWriteToCompoundNBT(CompoundNBT tag) {
        tag.func_74778_a("material", this.partMaterial.name());
        tag.func_74778_a("style", this.style.name());
        tag.func_74768_a("stair_height", this.stairHeight);
        tag.func_74768_a("stair_width", this.stairWidth);
        tag.func_74768_a("general_height", this.generalHeight);
        tag.func_74768_a("general_width", this.generalWidth);
        tag.func_74778_a("stairs_material", this.stairsMaterial.name());
        return tag;
    }

    @Override
    protected void CustomReadFromNBTTag(CompoundNBT messageTag, StructureConfiguration config) {
        if (messageTag.func_74764_b("material")) {
            ((StructurePartConfiguration)config).partMaterial = EnumStructureMaterial.valueOf(messageTag.func_74779_i("material"));
        }
        if (messageTag.func_74764_b("stairs_material")) {
            ((StructurePartConfiguration)config).stairsMaterial = EnumStairsMaterial.valueOf(messageTag.func_74779_i("stairs_material"));
        }
        if (messageTag.func_74764_b("style")) {
            ((StructurePartConfiguration)config).style = EnumStyle.valueOf(messageTag.func_74779_i("style"));
        }
        if (messageTag.func_74764_b("stair_height")) {
            ((StructurePartConfiguration)config).stairHeight = messageTag.func_74762_e("stair_height");
        }
        if (messageTag.func_74764_b("stair_width")) {
            ((StructurePartConfiguration)config).stairWidth = messageTag.func_74762_e("stair_width");
        }
        if (messageTag.func_74764_b("general_height")) {
            ((StructurePartConfiguration)config).generalHeight = messageTag.func_74762_e("general_height");
        }
        if (messageTag.func_74764_b("general_width")) {
            ((StructurePartConfiguration)config).generalWidth = messageTag.func_74762_e("general_width");
        }
    }

    public static enum EnumStyle {
        DoorWay("prefab.gui.part_style.door_way", "textures/gui/doorway_topdown.png", 164, 141),
        Floor("prefab.gui.part_style.floor", "textures/gui/floor_topdown.png", 166, 121),
        Frame("prefab.gui.part_style.frame", "textures/gui/frame_topdown.png", 167, 145),
        Gate("prefab.gui.part_style.gate", "textures/gui/gate_topdown.png", 162, 141),
        Roof("prefab.gui.part_style.roof", "textures/gui/roof_topdown.png", 167, 113),
        Stairs("prefab.gui.part_style.stairs", "textures/gui/stairs_topdown.png", 142, 169),
        Wall("prefab.gui.part_style.wall", "textures/gui/wall_topdown.png", 166, 154);

        public final String translateKey;
        public final String resourceLocation;
        public final int imageWidth;
        public final int imageHeight;

        private EnumStyle(String translateKey, String resourceLocation, int imageWidth, int imageHeight) {
            this.translateKey = translateKey;
            this.resourceLocation = resourceLocation;
            this.imageHeight = imageHeight;
            this.imageWidth = imageWidth;
        }

        public static EnumStyle getByOrdinal(int ordinal) {
            for (EnumStyle dimension : EnumStyle.values()) {
                if (dimension.ordinal() != ordinal) continue;
                return dimension;
            }
            return DoorWay;
        }

        public ResourceLocation getPictureLocation() {
            if (this.resourceLocation != null) {
                return new ResourceLocation("prefab", this.resourceLocation);
            }
            return null;
        }
    }
}

