/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.Structures.Config;

import com.wuest.prefab.Gui.GuiLangKeys;
import com.wuest.prefab.ModRegistry;
import com.wuest.prefab.Structures.Config.StructureConfiguration;
import com.wuest.prefab.Structures.Predefined.StructureVillagerHouses;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;

public class VillagerHouseConfiguration
extends StructureConfiguration {
    public static String tagKey = "villagerHouseConfig";
    private static String houseStyleTag = "houseStyle";
    private static String bedColorTag = "bedColor";
    public HouseStyle houseStyle;
    public DyeColor bedColor;

    @Override
    public void Initialize() {
        super.Initialize();
        this.houseStyle = HouseStyle.FLAT_ROOF;
        this.bedColor = DyeColor.RED;
    }

    @Override
    protected CompoundNBT CustomWriteToCompoundNBT(CompoundNBT tag) {
        tag.func_74768_a(houseStyleTag, this.houseStyle.value);
        tag.func_74778_a(bedColorTag, this.bedColor.func_176610_l().toUpperCase());
        return tag;
    }

    @Override
    protected void CustomReadFromNBTTag(CompoundNBT messageTag, StructureConfiguration config) {
        VillagerHouseConfiguration houseConfiguration = (VillagerHouseConfiguration)config;
        if (messageTag.func_74764_b(houseStyleTag)) {
            ((VillagerHouseConfiguration)config).houseStyle = HouseStyle.ValueOf(messageTag.func_74762_e(houseStyleTag));
        }
        if (messageTag.func_74764_b(bedColorTag)) {
            houseConfiguration.bedColor = DyeColor.valueOf((String)messageTag.func_74779_i(bedColorTag));
        }
    }

    @Override
    public VillagerHouseConfiguration ReadFromCompoundNBT(CompoundNBT messageTag) {
        VillagerHouseConfiguration config = new VillagerHouseConfiguration();
        return (VillagerHouseConfiguration)super.ReadFromCompoundNBT(messageTag, config);
    }

    @Override
    protected void ConfigurationSpecificBuildStructure(PlayerEntity player, ServerWorld world, BlockPos hitBlockPos) {
        StructureVillagerHouses structure = (StructureVillagerHouses)StructureVillagerHouses.CreateInstance(this.houseStyle.getStructureLocation(), StructureVillagerHouses.class);
        if (structure.BuildStructure(this, world, hitBlockPos, Direction.NORTH, player)) {
            this.DamageHeldItem(player, ModRegistry.VillagerHouses());
        }
    }

    public static enum HouseStyle {
        FLAT_ROOF(0, "prefab.gui.villager.house.flat", new ResourceLocation("prefab", "textures/gui/village_house_flat.png"), 165, 128, "assets/prefab/structures/villager_house_flat.zip", 4, 5, 5, 2),
        ANGLED_ROOF(1, "prefab.gui.villager.house.angled", new ResourceLocation("prefab", "textures/gui/village_house_angled.png"), 161, 155, "assets/prefab/structures/villager_house_angled.zip", 4, 5, 6, 2),
        FENCED_ROOF(2, "prefab.gui.villager.house.fenced", new ResourceLocation("prefab", "textures/gui/village_house_fenced.png"), 159, 156, "assets/prefab/structures/villager_house_fenced.zip", 4, 5, 6, 2),
        BLACKSMITH(3, "prefab.gui.villager.blacksmith", new ResourceLocation("prefab", "textures/gui/village_house_blacksmith.png"), 157, 73, "assets/prefab/structures/villager_house_blacksmith.zip", 7, 5, 6, 5),
        LONG_HOUSE(4, "prefab.gui.villager.long_house", new ResourceLocation("prefab", "textures/gui/village_house_long.png"), 157, 114, "assets/prefab/structures/villager_house_long.zip", 8, 6, 7, 4);

        private final int value;
        private final String displayName;
        private final ResourceLocation housePicture;
        private final int imageWidth;
        private final int imageHeight;
        private final String structureLocation;
        private final int width;
        private final int length;
        private final int height;
        private final int eastOffSet;

        private HouseStyle(int newValue, String displayName, ResourceLocation housePicture, int imageWidth, int imageHeight, String structureLocation, int width, int length, int height, int eastOffSet) {
            this.value = newValue;
            this.displayName = displayName;
            this.housePicture = housePicture;
            this.imageWidth = imageWidth;
            this.imageHeight = imageHeight;
            this.structureLocation = structureLocation;
            this.width = width;
            this.length = length;
            this.height = height;
            this.eastOffSet = eastOffSet;
        }

        public static HouseStyle ValueOf(int value) {
            switch (value) {
                case 1: {
                    return ANGLED_ROOF;
                }
                case 2: {
                    return FENCED_ROOF;
                }
                case 3: {
                    return BLACKSMITH;
                }
                case 4: {
                    return LONG_HOUSE;
                }
            }
            return FLAT_ROOF;
        }

        public int getValue() {
            return this.value;
        }

        public String getDisplayName() {
            return GuiLangKeys.translateString(this.displayName);
        }

        public ResourceLocation getHousePicture() {
            return this.housePicture;
        }

        public int getImageWidth() {
            return this.imageWidth;
        }

        public int getImageHeight() {
            return this.imageHeight;
        }

        public int getWidth() {
            return this.width;
        }

        public int getLength() {
            return this.length;
        }

        public int getHeight() {
            return this.height;
        }

        public int getEastOffSet() {
            return this.eastOffSet;
        }

        public String getStructureLocation() {
            return this.structureLocation;
        }
    }
}

