/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.Structures.Events;

import com.wuest.prefab.Config.EntityPlayerConfiguration;
import com.wuest.prefab.ModRegistry;
import com.wuest.prefab.Prefab;
import com.wuest.prefab.Proxy.CommonProxy;
import com.wuest.prefab.Proxy.Messages.PlayerEntityTagMessage;
import com.wuest.prefab.Structures.Base.BuildBlock;
import com.wuest.prefab.Structures.Base.BuildEntity;
import com.wuest.prefab.Structures.Base.BuildTileEntity;
import com.wuest.prefab.Structures.Base.BuildingMethods;
import com.wuest.prefab.Structures.Base.Structure;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.block.AbstractBannerBlock;
import net.minecraft.block.AbstractButtonBlock;
import net.minecraft.block.AbstractPressurePlateBlock;
import net.minecraft.block.AbstractSignBlock;
import net.minecraft.block.BedBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CarpetBlock;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.FlowerPotBlock;
import net.minecraft.block.LadderBlock;
import net.minecraft.block.LanternBlock;
import net.minecraft.block.LeverBlock;
import net.minecraft.block.RedstoneDiodeBlock;
import net.minecraft.block.RedstoneWireBlock;
import net.minecraft.block.SugarCaneBlock;
import net.minecraft.block.TorchBlock;
import net.minecraft.block.VineBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.HangingEntity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.entity.item.PaintingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.DoubleNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.NetworkDirection;

@Mod.EventBusSubscriber(modid="prefab")
public final class StructureEventHandler {
    public static HashMap<PlayerEntity, ArrayList<Structure>> structuresToBuild = new HashMap();

    @SubscribeEvent
    public static void PlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.getPlayer().field_70170_p.field_72995_K && event.getPlayer() instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.getPlayer();
            EntityPlayerConfiguration playerConfig = EntityPlayerConfiguration.loadFromEntityData((PlayerEntity)player);
            String startingItem = CommonProxy.proxyConfiguration.serverConfiguration.startingItem;
            if (!playerConfig.givenHouseBuilder && startingItem != null) {
                ItemStack stack = ItemStack.field_190927_a;
                switch (startingItem.toLowerCase()) {
                    case "structure part": {
                        stack = new ItemStack((IItemProvider)ModRegistry.StructurePart());
                        break;
                    }
                    case "starting house": {
                        stack = new ItemStack((IItemProvider)ModRegistry.StartHouse());
                        break;
                    }
                    case "moderate house": {
                        stack = new ItemStack((IItemProvider)ModRegistry.ModerateHouse());
                    }
                }
                if (!stack.func_190926_b()) {
                    System.out.println(player.func_145748_c_().getString() + " joined the game for the first time. Giving them starting item.");
                    player.field_71071_by.func_70441_a(stack);
                    player.field_71070_bA.func_75142_b();
                    playerConfig.givenHouseBuilder = true;
                    playerConfig.saveToPlayer((PlayerEntity)player);
                }
            }
            Prefab.network.sendTo((Object)new PlayerEntityTagMessage(playerConfig.getModIsPlayerNewTag((PlayerEntity)player)), ((ServerPlayerEntity)event.getPlayer()).field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            ArrayList<PlayerEntity> playersToRemove = new ArrayList<PlayerEntity>();
            for (Map.Entry<PlayerEntity, ArrayList<Structure>> entry : structuresToBuild.entrySet()) {
                ArrayList<Structure> structuresToRemove = new ArrayList<Structure>();
                for (Structure structure : entry.getValue()) {
                    if (!structure.entitiesRemoved) {
                        for (BlockPos clearedPos : structure.clearedBlockPos) {
                            AxisAlignedBB axisPos = VoxelShapes.func_197868_b().func_197752_a().func_186670_a(clearedPos);
                            List list = structure.world.func_72839_b((Entity)null, axisPos);
                            if (list.isEmpty()) continue;
                            for (Entity entity : list) {
                                if (entity instanceof LivingEntity) continue;
                                if (entity instanceof HangingEntity) {
                                    structure.BeforeHangingEntityRemoved((HangingEntity)entity);
                                }
                                structure.world.removeEntity(entity, false);
                            }
                        }
                        structure.entitiesRemoved = true;
                    }
                    for (int i = 0; i < 100; ++i) {
                        i = StructureEventHandler.setBlock(i, structure, structuresToRemove);
                    }
                    StructureEventHandler.removeWaterLogging(structure);
                }
                StructureEventHandler.removeStructuresFromList(structuresToRemove, entry);
                if (entry.getValue().size() != 0) continue;
                playersToRemove.add(entry.getKey());
            }
            for (PlayerEntity player : playersToRemove) {
                structuresToBuild.remove(player);
            }
        }
    }

    @SubscribeEvent
    public static void onClone(PlayerEvent.Clone event) {
        if (event.getPlayer() instanceof ServerPlayerEntity) {
            CompoundNBT originalTag = event.getOriginal().getPersistentData();
            String startingItem = CommonProxy.proxyConfiguration.serverConfiguration.startingItem;
            if (startingItem != null && !startingItem.equalsIgnoreCase("Nothing") && originalTag.func_74764_b("IsPlayerNew")) {
                CompoundNBT newPlayerTag = event.getPlayer().getPersistentData();
                newPlayerTag.func_218657_a("IsPlayerNew", originalTag.func_74781_a("IsPlayerNew"));
                Prefab.network.sendTo((Object)new PlayerEntityTagMessage(originalTag.func_74775_l("IsPlayerNew")), ((ServerPlayerEntity)event.getPlayer()).field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
            }
        }
    }

    private static int setBlock(int i, Structure structure, ArrayList<Structure> structuresToRemove) {
        if (structure.clearedBlockPos.size() > 0) {
            BlockPos currentPos = structure.clearedBlockPos.get(0);
            structure.clearedBlockPos.remove(0);
            BlockState clearBlockState = structure.world.func_180495_p(currentPos);
            if (!clearBlockState.isAir((IBlockReader)structure.world, currentPos)) {
                structure.BeforeClearSpaceBlockReplaced(currentPos);
                block0: for (Direction adjacentBlock : Direction.values()) {
                    BlockPos tempPos = currentPos.func_177972_a(adjacentBlock);
                    BlockState foundState = structure.world.func_180495_p(tempPos);
                    Block foundBlock = foundState.func_177230_c();
                    if (!(foundBlock instanceof TorchBlock) && !(foundBlock instanceof AbstractSignBlock) && !(foundBlock instanceof LeverBlock) && !(foundBlock instanceof AbstractButtonBlock) && !(foundBlock instanceof BedBlock) && !(foundBlock instanceof CarpetBlock) && !(foundBlock instanceof FlowerPotBlock) && !(foundBlock instanceof SugarCaneBlock) && !(foundBlock instanceof AbstractPressurePlateBlock) && !(foundBlock instanceof DoorBlock) && !(foundBlock instanceof LadderBlock) && !(foundBlock instanceof VineBlock) && !(foundBlock instanceof RedstoneWireBlock) && !(foundBlock instanceof RedstoneDiodeBlock) && !(foundBlock instanceof AbstractBannerBlock) && !(foundBlock instanceof LanternBlock)) continue;
                    structure.BeforeClearSpaceBlockReplaced(currentPos);
                    if (!(foundBlock instanceof BedBlock)) {
                        structure.world.func_217377_a(tempPos, false);
                        continue;
                    }
                    if (foundBlock instanceof DoorBlock) {
                        DoubleBlockHalf currentHalf = (DoubleBlockHalf)foundState.func_177229_b((IProperty)BlockStateProperties.field_208163_P);
                        BlockPos otherHalfPos = currentHalf == DoubleBlockHalf.LOWER ? tempPos.func_177984_a() : tempPos.func_177977_b();
                        structure.world.func_180501_a(tempPos, Blocks.field_150350_a.func_176223_P(), 35);
                        structure.world.func_180501_a(otherHalfPos, Blocks.field_150350_a.func_176223_P(), 35);
                        continue;
                    }
                    Direction direction = Direction.NORTH;
                    while (true) {
                        BlockPos bedPos;
                        BlockState bedState;
                        if ((bedState = structure.world.func_180495_p(bedPos = tempPos.func_177972_a(direction))).func_177230_c() instanceof BedBlock) {
                            structure.world.func_180501_a(tempPos, Blocks.field_150350_a.func_176223_P(), 35);
                            structure.world.func_180501_a(bedPos, Blocks.field_150350_a.func_176223_P(), 35);
                            continue block0;
                        }
                        direction = direction.func_176746_e();
                    }
                }
                structure.world.func_217377_a(currentPos, false);
            } else {
                --i;
            }
            return i;
        }
        BuildBlock currentBlock = null;
        if (structure.priorityOneBlocks.size() > 0) {
            currentBlock = structure.priorityOneBlocks.get(0);
            structure.priorityOneBlocks.remove(0);
        } else if (structure.priorityTwoBlocks.size() > 0) {
            currentBlock = structure.priorityTwoBlocks.get(0);
            structure.priorityTwoBlocks.remove(0);
        } else if (structure.airBlocks.size() > 0) {
            currentBlock = structure.airBlocks.get(0);
            structure.airBlocks.remove(0);
            structure.hasAirBlocks = true;
        } else if (structure.priorityThreeBlocks.size() > 0) {
            currentBlock = structure.priorityThreeBlocks.get(0);
            structure.priorityThreeBlocks.remove(0);
        } else {
            structuresToRemove.add(structure);
            return 999;
        }
        BlockState state = currentBlock.getBlockState();
        BuildingMethods.ReplaceBlock((World)structure.world, currentBlock.getStartingPosition().getRelativePosition(structure.originalPos, structure.getClearSpace().getShape().getDirection(), structure.configuration.houseFacing), state);
        if (currentBlock.getSubBlock() != null) {
            BuildBlock subBlock = currentBlock.getSubBlock();
            BuildingMethods.ReplaceBlock((World)structure.world, subBlock.getStartingPosition().getRelativePosition(structure.originalPos, structure.getClearSpace().getShape().getDirection(), structure.configuration.houseFacing), subBlock.getBlockState());
        }
        return i;
    }

    private static void removeStructuresFromList(ArrayList<Structure> structuresToRemove, Map.Entry<PlayerEntity, ArrayList<Structure>> entry) {
        for (Structure structure : structuresToRemove) {
            for (BuildTileEntity buildTileEntity : structure.tileEntities) {
                BlockPos tileEntityPos = buildTileEntity.getStartingPosition().getRelativePosition(structure.originalPos, structure.getClearSpace().getShape().getDirection(), structure.configuration.houseFacing);
                TileEntity tileEntity = structure.world.func_175625_s(tileEntityPos);
                if (tileEntity == null) {
                    TileEntity.func_203403_c((CompoundNBT)buildTileEntity.getEntityDataTag());
                    continue;
                }
                structure.world.func_175713_t(tileEntityPos);
                tileEntity = TileEntity.func_203403_c((CompoundNBT)buildTileEntity.getEntityDataTag());
                structure.world.func_175690_a(tileEntityPos, tileEntity);
                structure.world.func_175726_f(tileEntityPos).func_76630_e();
                tileEntity.func_70296_d();
                SUpdateTileEntityPacket packet = tileEntity.func_189518_D_();
                if (packet == null) continue;
                structure.world.func_73046_m().func_184103_al().func_148540_a((IPacket)tileEntity.func_189518_D_());
            }
            StructureEventHandler.removeWaterLogging(structure);
            for (BuildEntity buildEntity : structure.entities) {
                Entity entity;
                Optional entityType = EntityType.func_220327_a((String)buildEntity.getEntityResourceString());
                if (!entityType.isPresent() || (entity = ((EntityType)entityType.get()).func_200721_a((World)structure.world)) == null) continue;
                CompoundNBT tagCompound = buildEntity.getEntityDataTag();
                BlockPos entityPos = buildEntity.getStartingPosition().getRelativePosition(structure.originalPos, structure.getClearSpace().getShape().getDirection(), structure.configuration.houseFacing);
                if (tagCompound != null) {
                    if (tagCompound.func_186855_b("UUID")) {
                        tagCompound.func_186854_a("UUID", UUID.randomUUID());
                    }
                    ListNBT nbttaglist = new ListNBT();
                    nbttaglist.add((Object)DoubleNBT.func_229684_a_((double)entityPos.func_177958_n()));
                    nbttaglist.add((Object)DoubleNBT.func_229684_a_((double)entityPos.func_177956_o()));
                    nbttaglist.add((Object)DoubleNBT.func_229684_a_((double)entityPos.func_177952_p()));
                    tagCompound.func_218657_a("Pos", (INBT)nbttaglist);
                    entity.func_70020_e(tagCompound);
                }
                entity.field_98038_p = true;
                entity = entity instanceof ItemFrameEntity ? StructureEventHandler.setItemFrameFacingAndRotation((ItemFrameEntity)entity, buildEntity, entityPos, structure) : (entity instanceof PaintingEntity ? StructureEventHandler.setPaintingFacingAndRotation((PaintingEntity)entity, buildEntity, entityPos, structure) : StructureEventHandler.setEntityFacingAndRotation(entity, buildEntity, entityPos, structure));
                structure.world.func_217376_c(entity);
            }
            structure.AfterBuilding(structure.configuration, structure.world, structure.originalPos, structure.assumedNorth, entry.getKey());
            entry.getValue().remove(structure);
        }
    }

    private static void removeWaterLogging(Structure structure) {
        if (structure.hasAirBlocks) {
            for (BlockPos currentPos : structure.allBlockPositions) {
                BlockState currentState = structure.world.func_180495_p(currentPos);
                if (currentState.func_196959_b((IProperty)BlockStateProperties.field_208198_y)) {
                    currentState = (BlockState)currentState.func_206870_a((IProperty)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(false));
                    structure.world.func_175656_a(currentPos, currentState);
                    continue;
                }
                if (currentState.func_185904_a() != Material.field_151586_h) continue;
                structure.world.func_175656_a(currentPos, Blocks.field_150350_a.func_176223_P());
            }
        }
    }

    private static Entity setPaintingFacingAndRotation(PaintingEntity entity, BuildEntity buildEntity, BlockPos entityPos, Structure structure) {
        float yaw = entity.field_70177_z;
        Rotation rotation = Rotation.NONE;
        double x_axis_offset = buildEntity.entityXAxisOffset;
        double z_axis_offset = buildEntity.entityZAxisOffset;
        Direction facing = entity.func_174811_aO();
        double y_axis_offset = buildEntity.entityYAxisOffset * -1.0;
        if (structure.configuration.houseFacing == structure.assumedNorth.func_176734_d()) {
            rotation = Rotation.CLOCKWISE_180;
            x_axis_offset *= -1.0;
            z_axis_offset *= -1.0;
            facing = facing.func_176734_d();
        } else if (structure.configuration.houseFacing == structure.assumedNorth.func_176746_e()) {
            rotation = Rotation.CLOCKWISE_90;
            x_axis_offset *= -1.0;
            z_axis_offset *= -1.0;
            if (structure.getClearSpace().getShape().getDirection() == Direction.NORTH) {
                facing = facing.func_176735_f();
            } else if (structure.getClearSpace().getShape().getDirection() == Direction.SOUTH) {
                facing = facing.func_176746_e();
            }
        } else if (structure.configuration.houseFacing == structure.assumedNorth.func_176735_f()) {
            rotation = Rotation.COUNTERCLOCKWISE_90;
            x_axis_offset *= -1.0;
            z_axis_offset *= -1.0;
            if (structure.getClearSpace().getShape().getDirection() == Direction.NORTH) {
                facing = facing.func_176746_e();
            } else if (structure.getClearSpace().getShape().getDirection() == Direction.SOUTH) {
                facing = facing.func_176735_f();
            }
        } else {
            x_axis_offset = 0.0;
            z_axis_offset = 0.0;
        }
        if (entity.field_70522_e.func_200832_c() > entity.field_70522_e.func_200834_b() || entity.field_70522_e.func_200832_c() > 16) {
            y_axis_offset -= 1.0;
        }
        yaw = entity.func_184229_a(rotation);
        PaintingEntity hangingEntity = entity;
        CompoundNBT compound = new CompoundNBT();
        hangingEntity.func_213281_b(compound);
        compound.func_74774_a("Facing", (byte)facing.func_176736_b());
        hangingEntity.func_70037_a(compound);
        StructureEventHandler.updateEntityHangingBoundingBox((HangingEntity)hangingEntity);
        entity.func_70012_b((double)entityPos.func_177958_n() + x_axis_offset, (double)entityPos.func_177956_o() + y_axis_offset, (double)entityPos.func_177952_p() + z_axis_offset, yaw, entity.field_70125_A);
        StructureEventHandler.updateEntityHangingBoundingBox((HangingEntity)entity);
        Chunk chunk = structure.world.func_175726_f(entityPos);
        chunk.func_76630_e();
        return entity;
    }

    private static Entity setItemFrameFacingAndRotation(ItemFrameEntity frame, BuildEntity buildEntity, BlockPos entityPos, Structure structure) {
        float yaw = frame.field_70177_z;
        Rotation rotation = Rotation.NONE;
        double x_axis_offset = buildEntity.entityXAxisOffset;
        double z_axis_offset = buildEntity.entityZAxisOffset;
        Direction facing = frame.func_174811_aO();
        double y_axis_offset = buildEntity.entityYAxisOffset;
        x_axis_offset *= -1.0;
        z_axis_offset *= -1.0;
        if (structure.configuration.houseFacing == structure.assumedNorth.func_176734_d()) {
            rotation = Rotation.CLOCKWISE_180;
            facing = facing.func_176734_d();
        } else if (structure.configuration.houseFacing == structure.assumedNorth.func_176746_e()) {
            if (structure.getClearSpace().getShape().getDirection() == Direction.NORTH) {
                rotation = Rotation.CLOCKWISE_90;
                facing = facing.func_176735_f();
            } else if (structure.getClearSpace().getShape().getDirection() == Direction.SOUTH) {
                facing = facing.func_176746_e();
                rotation = Rotation.COUNTERCLOCKWISE_90;
            }
        } else if (structure.configuration.houseFacing == structure.assumedNorth.func_176735_f()) {
            if (structure.getClearSpace().getShape().getDirection() == Direction.NORTH) {
                rotation = Rotation.COUNTERCLOCKWISE_90;
                facing = facing.func_176746_e();
            } else if (structure.getClearSpace().getShape().getDirection() == Direction.SOUTH) {
                facing = facing.func_176735_f();
                rotation = Rotation.CLOCKWISE_90;
            }
        } else {
            x_axis_offset = 0.0;
            z_axis_offset = 0.0;
        }
        yaw = frame.func_184229_a(rotation);
        ItemFrameEntity hangingEntity = frame;
        CompoundNBT compound = new CompoundNBT();
        hangingEntity.func_213281_b(compound);
        compound.func_74774_a("Facing", (byte)facing.func_176745_a());
        hangingEntity.func_70037_a(compound);
        StructureEventHandler.updateEntityHangingBoundingBox((HangingEntity)hangingEntity);
        frame.func_70012_b((double)entityPos.func_177958_n() + x_axis_offset, (double)entityPos.func_177956_o() + y_axis_offset, (double)entityPos.func_177952_p() + z_axis_offset, yaw, frame.field_70125_A);
        StructureEventHandler.updateEntityHangingBoundingBox((HangingEntity)frame);
        Chunk chunk = structure.world.func_175726_f(entityPos);
        chunk.func_76630_e();
        return frame;
    }

    private static Entity setEntityFacingAndRotation(Entity entity, BuildEntity buildEntity, BlockPos entityPos, Structure structure) {
        float yaw = entity.field_70177_z;
        Rotation rotation = Rotation.NONE;
        double x_axis_offset = buildEntity.entityXAxisOffset;
        double z_axis_offset = buildEntity.entityZAxisOffset;
        Direction facing = structure.assumedNorth;
        double y_axis_offset = buildEntity.entityYAxisOffset;
        if (structure.configuration.houseFacing == structure.assumedNorth.func_176734_d()) {
            rotation = Rotation.CLOCKWISE_180;
            x_axis_offset *= -1.0;
            z_axis_offset *= -1.0;
            facing = facing.func_176734_d();
        } else if (structure.configuration.houseFacing == structure.assumedNorth.func_176746_e()) {
            rotation = Rotation.CLOCKWISE_90;
            x_axis_offset *= -1.0;
            z_axis_offset *= -1.0;
            facing = facing.func_176746_e();
        } else if (structure.configuration.houseFacing == structure.assumedNorth.func_176735_f()) {
            rotation = Rotation.COUNTERCLOCKWISE_90;
            x_axis_offset *= -1.0;
            z_axis_offset *= -1.0;
            facing = facing.func_176735_f();
        } else {
            x_axis_offset = 0.0;
            z_axis_offset = 0.0;
        }
        yaw = entity.func_184229_a(rotation);
        entity.func_70080_a((double)entityPos.func_177958_n() + x_axis_offset, (double)entityPos.func_177956_o() + y_axis_offset, (double)entityPos.func_177952_p() + z_axis_offset, yaw, entity.field_70125_A);
        return entity;
    }

    private static void updateEntityHangingBoundingBox(HangingEntity entity) {
        double d0 = (double)entity.func_174857_n().func_177958_n() + 0.5;
        double d1 = (double)entity.func_174857_n().func_177956_o() + 0.5;
        double d2 = (double)entity.func_174857_n().func_177952_p() + 0.5;
        double d3 = 0.46875;
        double d4 = entity.func_82329_d() % 32 == 0 ? 0.5 : 0.0;
        double d5 = entity.func_82330_g() % 32 == 0 ? 0.5 : 0.0;
        Direction horizontal = entity.func_174811_aO();
        d0 -= (double)horizontal.func_82601_c() * 0.46875;
        d2 -= (double)horizontal.func_82599_e() * 0.46875;
        Direction direction = horizontal == Direction.DOWN || horizontal == Direction.UP ? horizontal.func_176734_d() : horizontal.func_176735_f();
        entity.func_226288_n_(d0 += d4 * (double)direction.func_82601_c(), d1 += d5, d2 += d4 * (double)direction.func_82599_e());
        double d6 = entity.func_82329_d();
        double d7 = entity.func_82330_g();
        double d8 = entity.func_82329_d();
        if (horizontal.func_176740_k() == Direction.Axis.Z) {
            d8 = 1.0;
        } else {
            d6 = 1.0;
        }
        entity.func_174826_a(new AxisAlignedBB(d0 - (d6 /= 32.0), d1 - (d7 /= 32.0), d2 - (d8 /= 32.0), d0 + d6, d1 + d7, d2 + d8));
    }
}

