/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.Structures.Gui;

import com.wuest.prefab.Events.ClientEventHandler;
import com.wuest.prefab.Gui.GuiLangKeys;
import com.wuest.prefab.Structures.Config.BasicStructureConfiguration;
import com.wuest.prefab.Structures.Gui.GuiStructure;
import com.wuest.prefab.Structures.Items.ItemBasicStructure;
import com.wuest.prefab.Structures.Messages.StructureTagMessage;
import com.wuest.prefab.Structures.Predefined.StructureBasic;
import com.wuest.prefab.Structures.Render.StructureRenderHandler;
import com.wuest.prefab.Tuple;
import java.io.IOException;
import net.minecraft.client.gui.widget.button.AbstractButton;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraftforge.fml.client.gui.widget.ExtendedButton;

public class GuiBasicStructure
extends GuiStructure {
    protected BasicStructureConfiguration configuration;
    private boolean includePicture = true;
    private int modifiedInitialXAxis = 213;
    private int modifiedInitialYAxis = 83;
    private ExtendedButton btnBedColor = null;

    public GuiBasicStructure() {
        super("Basic Structure");
        this.structureConfiguration = StructureTagMessage.EnumStructureConfiguration.Basic;
    }

    @Override
    protected Tuple<Integer, Integer> getAdjustedXYValue() {
        return new Tuple<Integer, Integer>(this.getCenteredXAxis() - this.modifiedInitialXAxis, this.getCenteredYAxis() - this.modifiedInitialYAxis);
    }

    @Override
    protected void preButtonRender(int x, int y) {
        super.preButtonRender(x, y);
        if (this.includePicture) {
            this.getMinecraft().func_110434_K().func_110577_a(this.configuration.basicStructureName.getTopDownPictureLocation());
            GuiBasicStructure.drawModalRectWithCustomSizedTexture(x + 250, y, 1, this.configuration.basicStructureName.getImageWidth(), this.configuration.basicStructureName.getImageHeight(), this.configuration.basicStructureName.getImageWidth(), this.configuration.basicStructureName.getImageHeight());
        }
    }

    @Override
    protected void postButtonRender(int x, int y) {
        if (this.configuration.basicStructureName == BasicStructureConfiguration.EnumBasicStructureName.MineshaftEntrance || this.configuration.basicStructureName == BasicStructureConfiguration.EnumBasicStructureName.WatchTower || this.configuration.basicStructureName == BasicStructureConfiguration.EnumBasicStructureName.WelcomeCenter) {
            this.minecraft.field_71466_p.func_211126_b(GuiLangKeys.translateString("prefab.gui.structure.bed_color"), (float)(x + 10), (float)(y + 10), this.textColor);
        }
        this.getMinecraft().field_71466_p.func_78279_b(GuiLangKeys.translateString("prefab.gui.structure.block.clicked"), x + 147, y + 10, 95, this.textColor);
    }

    @Override
    protected void Initialize() {
        ItemStack stack = ItemBasicStructure.getBasicStructureItemInHand(this.player);
        if (stack != null) {
            ItemBasicStructure item = (ItemBasicStructure)stack.func_77973_b();
            this.configuration = ClientEventHandler.playerConfig.getClientConfig(item.structureType.getName(), BasicStructureConfiguration.class);
            this.configuration.basicStructureName = item.structureType;
            this.includePicture = this.doesPictureExist();
        }
        this.configuration.pos = this.pos;
        if (!this.includePicture) {
            this.modifiedInitialXAxis = 125;
        }
        int grayBoxX = this.getCenteredXAxis() - this.modifiedInitialXAxis;
        int grayBoxY = this.getCenteredYAxis() - this.modifiedInitialYAxis;
        int x = grayBoxX + 10;
        int y = grayBoxY + 20;
        this.btnBedColor = this.createAndAddButton(x, y, 90, 20, GuiLangKeys.translateDye(this.configuration.bedColor));
        if (this.configuration.basicStructureName == BasicStructureConfiguration.EnumBasicStructureName.MineshaftEntrance || this.configuration.basicStructureName == BasicStructureConfiguration.EnumBasicStructureName.WatchTower || this.configuration.basicStructureName == BasicStructureConfiguration.EnumBasicStructureName.WelcomeCenter) {
            this.btnBedColor.visible = true;
            y += 40;
        } else {
            this.btnBedColor.visible = false;
        }
        this.btnVisualize = this.createAndAddButton(x, y, 90, 20, GuiLangKeys.translateString("prefab.gui.button.preview"));
        this.btnBuild = this.createAndAddButton(grayBoxX + 10, grayBoxY + 136, 90, 20, GuiLangKeys.translateString("prefab.gui.button.build"));
        this.btnCancel = this.createAndAddButton(grayBoxX + 147, grayBoxY + 136, 90, 20, GuiLangKeys.translateString("prefab.gui.button.cancel"));
    }

    private boolean doesPictureExist() {
        try {
            this.getMinecraft().func_195551_G().func_199002_a(this.configuration.basicStructureName.getTopDownPictureLocation());
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public void buttonClicked(AbstractButton button) {
        this.performCancelOrBuildOrHouseFacing(this.configuration, button);
        if (button == this.btnVisualize) {
            StructureBasic structure = (StructureBasic)StructureBasic.CreateInstance(this.configuration.basicStructureName.getAssetLocation(), StructureBasic.class);
            StructureRenderHandler.setStructure(structure, Direction.NORTH, this.configuration);
            this.getMinecraft().func_147108_a(null);
        } else if (button == this.btnBedColor) {
            this.configuration.bedColor = DyeColor.func_196056_a((int)(this.configuration.bedColor.func_196059_a() + 1));
            this.btnBedColor.setMessage(GuiLangKeys.translateDye(this.configuration.bedColor));
        }
    }
}

