/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.Structures.Gui;

import com.wuest.prefab.Events.ClientEventHandler;
import com.wuest.prefab.Gui.GuiLangKeys;
import com.wuest.prefab.Gui.GuiTabScreen;
import com.wuest.prefab.Structures.Config.HorseStableConfiguration;
import com.wuest.prefab.Structures.Gui.GuiStructure;
import com.wuest.prefab.Structures.Messages.StructureTagMessage;
import com.wuest.prefab.Structures.Predefined.StructureHorseStable;
import com.wuest.prefab.Structures.Render.StructureRenderHandler;
import com.wuest.prefab.Tuple;
import net.minecraft.client.gui.widget.button.AbstractButton;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;

public class GuiHorseStable
extends GuiStructure {
    private static final ResourceLocation structureTopDown = new ResourceLocation("prefab", "textures/gui/horse_stable_top_down.png");
    protected HorseStableConfiguration configuration;

    public GuiHorseStable() {
        super("Horse Stable");
        this.structureConfiguration = StructureTagMessage.EnumStructureConfiguration.HorseStable;
    }

    @Override
    protected Tuple<Integer, Integer> getAdjustedXYValue() {
        return new Tuple<Integer, Integer>(this.getCenteredXAxis() - 213, this.getCenteredYAxis() - 83);
    }

    @Override
    protected void preButtonRender(int x, int y) {
        super.preButtonRender(x, y);
        this.minecraft.func_110434_K().func_110577_a(structureTopDown);
        GuiTabScreen.drawModalRectWithCustomSizedTexture(x + 250, y, 1, 104, 166, 104.0f, 166.0f);
    }

    @Override
    protected void postButtonRender(int x, int y) {
        this.minecraft.field_71466_p.func_211126_b(GuiLangKeys.translateString("prefab.gui.structure.facing"), (float)(x + 10), (float)(y + 10), this.textColor);
        this.minecraft.field_71466_p.func_78279_b(GuiLangKeys.translateString("prefab.gui.structure.block.clicked"), x + 147, y + 10, 95, this.textColor);
    }

    @Override
    public void buttonClicked(AbstractButton button) {
        this.performCancelOrBuildOrHouseFacing(this.configuration, button);
        if (button == this.btnVisualize) {
            StructureHorseStable structure = (StructureHorseStable)StructureHorseStable.CreateInstance("assets/prefab/structures/horsestable.zip", StructureHorseStable.class);
            StructureRenderHandler.setStructure(structure, Direction.NORTH, this.configuration);
            assert (this.minecraft != null);
            this.minecraft.func_147108_a(null);
        }
    }

    @Override
    protected void Initialize() {
        this.configuration = ClientEventHandler.playerConfig.getClientConfig("Horse Stable", HorseStableConfiguration.class);
        this.configuration.pos = this.pos;
        int grayBoxX = this.width / 2 - 213;
        int grayBoxY = this.height / 2 - 83;
        this.btnVisualize = this.createAndAddButton(grayBoxX + 10, grayBoxY + 20, 90, 20, GuiLangKeys.translateString("prefab.gui.button.preview"));
        this.btnBuild = this.createAndAddButton(grayBoxX + 10, grayBoxY + 136, 90, 20, GuiLangKeys.translateString("prefab.gui.button.build"));
        this.btnCancel = this.createAndAddButton(grayBoxX + 147, grayBoxY + 136, 90, 20, GuiLangKeys.translateString("prefab.gui.button.cancel"));
    }
}

