/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.Structures.Gui;

import com.wuest.prefab.Events.ClientEventHandler;
import com.wuest.prefab.Gui.GuiLangKeys;
import com.wuest.prefab.Structures.Config.ProduceFarmConfiguration;
import com.wuest.prefab.Structures.Gui.GuiStructure;
import com.wuest.prefab.Structures.Messages.StructureTagMessage;
import com.wuest.prefab.Structures.Predefined.StructureProduceFarm;
import com.wuest.prefab.Structures.Render.StructureRenderHandler;
import com.wuest.prefab.Tuple;
import net.minecraft.client.gui.widget.button.AbstractButton;
import net.minecraft.item.DyeColor;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.gui.widget.ExtendedButton;

public class GuiProduceFarm
extends GuiStructure {
    private static final ResourceLocation houseTopDown = new ResourceLocation("prefab", "textures/gui/produce_farm_top_down.png");
    protected ProduceFarmConfiguration configuration;
    private ExtendedButton btnGlassColor;

    public GuiProduceFarm() {
        super("Produce Farm");
        this.structureConfiguration = StructureTagMessage.EnumStructureConfiguration.ProduceFarm;
    }

    @Override
    public void Initialize() {
        this.configuration = ClientEventHandler.playerConfig.getClientConfig("Produce Farm", ProduceFarmConfiguration.class);
        this.configuration.pos = this.pos;
        int grayBoxX = this.getCenteredXAxis() - 210;
        int grayBoxY = this.getCenteredYAxis() - 83;
        this.btnGlassColor = this.createAndAddButton(grayBoxX + 10, grayBoxY + 20, 90, 20, GuiLangKeys.translateDye(this.configuration.dyeColor));
        this.btnVisualize = this.createAndAddButton(grayBoxX + 10, grayBoxY + 90, 90, 20, GuiLangKeys.translateString("prefab.gui.button.preview"));
        this.btnBuild = this.createAndAddButton(grayBoxX + 10, grayBoxY + 136, 90, 20, GuiLangKeys.translateString("prefab.gui.button.build"));
        this.btnCancel = this.createAndAddButton(grayBoxX + 147, grayBoxY + 136, 90, 20, GuiLangKeys.translateString("prefab.gui.button.cancel"));
    }

    @Override
    protected Tuple<Integer, Integer> getAdjustedXYValue() {
        return new Tuple<Integer, Integer>(this.getCenteredXAxis() - 210, this.getCenteredYAxis() - 83);
    }

    @Override
    protected void preButtonRender(int x, int y) {
        super.preButtonRender(x, y);
        this.minecraft.func_110434_K().func_110577_a(houseTopDown);
        GuiProduceFarm.drawModalRectWithCustomSizedTexture(x + 250, y, 1, 170, 171, 170.0f, 171.0f);
    }

    @Override
    protected void postButtonRender(int x, int y) {
        this.minecraft.field_71466_p.func_211126_b(GuiLangKeys.translateString("prefab.gui.structure.glass"), (float)(x + 10), (float)(y + 10), this.textColor);
        this.minecraft.field_71466_p.func_78279_b(GuiLangKeys.translateString("prefab.gui.structure.block.clicked"), x + 147, y + 10, 100, this.textColor);
        this.minecraft.field_71466_p.func_78279_b(GuiLangKeys.translateString("prefab.gui.producefarm.structure.size"), x + 147, y + 50, 100, this.textColor);
    }

    @Override
    public void buttonClicked(AbstractButton button) {
        this.performCancelOrBuildOrHouseFacing(this.configuration, button);
        if (button == this.btnGlassColor) {
            this.configuration.dyeColor = DyeColor.func_196056_a((int)(this.configuration.dyeColor.func_196059_a() + 1));
            this.btnGlassColor.setMessage(GuiLangKeys.translateDye(this.configuration.dyeColor));
        } else if (button == this.btnVisualize) {
            StructureProduceFarm structure = (StructureProduceFarm)StructureProduceFarm.CreateInstance("assets/prefab/structures/producefarm.zip", StructureProduceFarm.class);
            StructureRenderHandler.setStructure(structure, Direction.NORTH, this.configuration);
            assert (this.minecraft != null);
            this.minecraft.func_147108_a(null);
        }
    }
}

