/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.Structures.Gui;

import com.wuest.prefab.Config.ServerModConfiguration;
import com.wuest.prefab.Events.ClientEventHandler;
import com.wuest.prefab.Gui.Controls.GuiCheckBox;
import com.wuest.prefab.Gui.Controls.GuiTab;
import com.wuest.prefab.Gui.GuiLangKeys;
import com.wuest.prefab.Gui.GuiTabScreen;
import com.wuest.prefab.Prefab;
import com.wuest.prefab.Proxy.CommonProxy;
import com.wuest.prefab.Structures.Config.HouseConfiguration;
import com.wuest.prefab.Structures.Messages.StructureTagMessage;
import com.wuest.prefab.Structures.Predefined.StructureAlternateStart;
import com.wuest.prefab.Structures.Render.StructureRenderHandler;
import com.wuest.prefab.Tuple;
import java.awt.Color;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.item.DyeColor;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.gui.widget.ExtendedButton;

public class GuiStartHouseChooser
extends GuiTabScreen {
    private static final ResourceLocation backgroundTextures = new ResourceLocation("prefab", "textures/gui/default_background.png");
    protected ExtendedButton btnCancel;
    protected ExtendedButton btnBuild;
    protected ExtendedButton btnVisualize;
    protected ServerModConfiguration serverConfiguration;
    private GuiTab tabGeneral;
    private GuiTab tabConfig;
    private GuiTab tabBlockTypes;
    private ExtendedButton btnHouseStyle;
    private ExtendedButton btnGlassColor;
    private ExtendedButton btnBedColor;
    private GuiCheckBox btnAddTorches;
    private GuiCheckBox btnAddBed;
    private GuiCheckBox btnAddCraftingTable;
    private GuiCheckBox btnAddFurnace;
    private GuiCheckBox btnAddChest;
    private GuiCheckBox btnAddChestContents;
    private GuiCheckBox btnAddMineShaft;
    private boolean allowItemsInChestAndFurnace = true;
    private HouseConfiguration houseConfiguration;

    public GuiStartHouseChooser() {
        this.Tabs.setWidth(256);
    }

    @Override
    public void init() {
        super.init();
        assert (this.minecraft != null);
        if (!this.minecraft.field_71439_g.func_184812_l_()) {
            this.allowItemsInChestAndFurnace = !ClientEventHandler.playerConfig.builtStarterHouse;
        }
        this.Initialize();
    }

    @Override
    protected Tuple<Integer, Integer> getAdjustedXYValue() {
        return new Tuple<Integer, Integer>(this.width / 2 - 198, this.height / 2 - 83);
    }

    @Override
    public void render(int x, int y, float f) {
        Tuple<Integer, Integer> adjustedValueCoords = this.getAdjustedXYValue();
        int grayBoxX = adjustedValueCoords.getFirst();
        int grayBoxY = adjustedValueCoords.getSecond();
        this.Tabs.x = adjustedValueCoords.getFirst();
        this.Tabs.y = adjustedValueCoords.getSecond() - 21;
        this.renderBackground();
        assert (this.minecraft != null);
        this.minecraft.func_110434_K().func_110577_a(backgroundTextures);
        this.blit(grayBoxX, grayBoxY, 0, 0, 256, 256);
        for (Widget button : this.buttons) {
            if (button == this.btnCancel || button == this.btnBuild) continue;
            button.visible = false;
        }
        this.btnAddTorches.visible = false;
        this.btnAddBed.visible = false;
        this.btnAddChest.visible = false;
        this.btnAddChestContents.visible = false;
        this.btnAddCraftingTable.visible = false;
        this.btnAddFurnace.visible = false;
        this.btnAddMineShaft.visible = false;
        this.btnBedColor.visible = false;
        if (this.getSelectedTab() == this.tabGeneral) {
            this.btnHouseStyle.visible = true;
            this.btnVisualize.visible = true;
        } else if (this.getSelectedTab() == this.tabConfig) {
            this.btnAddTorches.visible = this.serverConfiguration.addTorches;
            this.btnAddBed.visible = this.serverConfiguration.addBed;
            this.btnAddChest.visible = this.serverConfiguration.addChests;
            this.btnAddChestContents.visible = this.allowItemsInChestAndFurnace && this.serverConfiguration.addChestContents;
            this.btnAddCraftingTable.visible = this.serverConfiguration.addCraftingTable;
            this.btnAddFurnace.visible = this.serverConfiguration.addFurnace;
            this.btnAddMineShaft.visible = this.serverConfiguration.addMineshaft;
        } else if (this.getSelectedTab() == this.tabBlockTypes) {
            this.btnGlassColor.visible = this.houseConfiguration.houseStyle != HouseConfiguration.HouseStyle.SNOWY && this.houseConfiguration.houseStyle != HouseConfiguration.HouseStyle.DESERT;
            this.btnBedColor.visible = true;
        }
        super.render(x, y, f);
        int color = Color.DARK_GRAY.getRGB();
        if (this.getSelectedTab() == this.tabGeneral) {
            this.minecraft.field_71466_p.func_211126_b(GuiLangKeys.translateString("prefab.gui.starter.style.label"), (float)(grayBoxX + 10), (float)(grayBoxY + 10), color);
            this.minecraft.field_71466_p.func_78279_b(this.houseConfiguration.houseStyle.getHouseNotes(), grayBoxX + 147, grayBoxY + 10, 95, color);
            this.minecraft.func_110434_K().func_110577_a(this.houseConfiguration.houseStyle.getHousePicture());
            GuiTabScreen.drawModalRectWithCustomSizedTexture(grayBoxX + 250, grayBoxY, 1, this.houseConfiguration.houseStyle.getImageWidth(), this.houseConfiguration.houseStyle.getImageHeight(), this.houseConfiguration.houseStyle.getImageWidth(), this.houseConfiguration.houseStyle.getImageHeight());
        } else if (this.getSelectedTab() == this.tabBlockTypes) {
            if (this.houseConfiguration.houseStyle != HouseConfiguration.HouseStyle.SNOWY && this.houseConfiguration.houseStyle != HouseConfiguration.HouseStyle.DESERT) {
                this.minecraft.field_71466_p.func_211126_b(GuiLangKeys.translateString("prefab.gui.structure.glass"), (float)(grayBoxX + 10), (float)(grayBoxY + 10), color);
            }
            this.minecraft.field_71466_p.func_211126_b(GuiLangKeys.translateString("prefab.gui.structure.bed_color"), (float)(grayBoxX + 147), (float)(grayBoxY + 10), color);
        }
        if (!CommonProxy.proxyConfiguration.serverConfiguration.enableStructurePreview) {
            this.btnVisualize.visible = false;
        }
    }

    private void actionPerformed(Button button) {
        if (button == this.btnCancel || button == this.btnVisualize || button == this.btnBuild) {
            this.houseConfiguration.addBed = this.serverConfiguration.addBed && this.btnAddBed.func_212942_a();
            this.houseConfiguration.addChest = this.serverConfiguration.addChests && this.btnAddChest.func_212942_a();
            this.houseConfiguration.addChestContents = this.allowItemsInChestAndFurnace && this.serverConfiguration.addChestContents && this.btnAddChestContents.func_212942_a();
            this.houseConfiguration.addCraftingTable = this.serverConfiguration.addCraftingTable && this.btnAddCraftingTable.func_212942_a();
            this.houseConfiguration.addFurnace = this.serverConfiguration.addFurnace && this.btnAddFurnace.func_212942_a();
            this.houseConfiguration.addMineShaft = this.serverConfiguration.addMineshaft && this.btnAddMineShaft.func_212942_a();
            boolean bl = this.houseConfiguration.addTorches = this.serverConfiguration.addTorches && this.btnAddTorches.func_212942_a();
            assert (this.minecraft != null);
            this.houseConfiguration.houseFacing = this.minecraft.field_71439_g.func_174811_aO().func_176734_d();
        }
        if (button == this.btnCancel) {
            this.minecraft.func_147108_a(null);
        } else if (button == this.btnBuild) {
            Prefab.network.sendToServer((Object)new StructureTagMessage(this.houseConfiguration.WriteToCompoundNBT(), StructureTagMessage.EnumStructureConfiguration.StartHouse));
            this.minecraft.func_147108_a(null);
        } else if (button == this.btnHouseStyle) {
            int id = this.houseConfiguration.houseStyle.getValue() + 1;
            this.houseConfiguration.houseStyle = HouseConfiguration.HouseStyle.ValueOf(id);
            if (this.houseConfiguration.houseStyle == HouseConfiguration.HouseStyle.LOFT && !this.serverConfiguration.enableLoftHouse) {
                id = this.houseConfiguration.houseStyle.getValue() + 1;
                this.houseConfiguration.houseStyle = HouseConfiguration.HouseStyle.ValueOf(id);
            }
            this.btnHouseStyle.setMessage(this.houseConfiguration.houseStyle.getDisplayName());
            if (this.houseConfiguration.houseStyle == HouseConfiguration.HouseStyle.HOBBIT) {
                this.houseConfiguration.glassColor = DyeColor.GREEN;
                this.btnGlassColor.setMessage(GuiLangKeys.translateDye(DyeColor.GREEN));
            } else if (this.houseConfiguration.houseStyle == HouseConfiguration.HouseStyle.LOFT) {
                this.houseConfiguration.glassColor = DyeColor.BLACK;
                this.btnGlassColor.setMessage(GuiLangKeys.translateDye(DyeColor.BLACK));
            } else if (this.houseConfiguration.houseStyle == HouseConfiguration.HouseStyle.BASIC) {
                this.houseConfiguration.glassColor = DyeColor.LIGHT_GRAY;
                this.btnGlassColor.setMessage(GuiLangKeys.translateDye(DyeColor.LIGHT_GRAY));
            } else if (this.houseConfiguration.houseStyle == HouseConfiguration.HouseStyle.DESERT2) {
                this.houseConfiguration.glassColor = DyeColor.RED;
                this.btnGlassColor.setMessage(GuiLangKeys.translateDye(DyeColor.RED));
            } else {
                this.houseConfiguration.glassColor = DyeColor.CYAN;
                this.btnGlassColor.setMessage(GuiLangKeys.translateDye(DyeColor.CYAN));
            }
            this.tabBlockTypes.visible = true;
        } else if (button == this.btnGlassColor) {
            this.houseConfiguration.glassColor = DyeColor.func_196056_a((int)(this.houseConfiguration.glassColor.func_196059_a() + 1));
            this.btnGlassColor.setMessage(GuiLangKeys.translateDye(this.houseConfiguration.glassColor));
        } else if (button == this.btnBedColor) {
            this.houseConfiguration.bedColor = DyeColor.func_196056_a((int)(this.houseConfiguration.bedColor.func_196059_a() + 1));
            this.btnBedColor.setMessage(GuiLangKeys.translateDye(this.houseConfiguration.bedColor));
        } else if (button == this.btnVisualize) {
            StructureAlternateStart structure = (StructureAlternateStart)StructureAlternateStart.CreateInstance(this.houseConfiguration.houseStyle.getStructureLocation(), StructureAlternateStart.class);
            StructureRenderHandler.setStructure(structure, Direction.NORTH, this.houseConfiguration);
            this.minecraft.func_147108_a(null);
        }
    }

    @Override
    public boolean isPauseScreen() {
        return true;
    }

    @Override
    protected void Initialize() {
        int y;
        int grayBoxX = this.width / 2 - 198;
        int grayBoxY = this.height / 2 - 83;
        int color = Color.DARK_GRAY.getRGB();
        this.serverConfiguration = Prefab.proxy.getServerConfiguration();
        this.houseConfiguration = ClientEventHandler.playerConfig.getClientConfig("Starter House", HouseConfiguration.class);
        this.houseConfiguration.pos = this.pos;
        this.btnHouseStyle = new ExtendedButton(grayBoxX + 10, grayBoxY + 20, 90, 20, this.houseConfiguration.houseStyle.getDisplayName(), this::actionPerformed);
        this.addButton((Widget)this.btnHouseStyle);
        this.btnVisualize = new ExtendedButton(grayBoxX + 10, grayBoxY + 60, 90, 20, GuiLangKeys.translateString("prefab.gui.button.preview"), this::actionPerformed);
        this.addButton((Widget)this.btnVisualize);
        int x = grayBoxX + 10;
        int secondColumnY = y = grayBoxY + 10;
        int secondColumnX = x + 137;
        this.btnAddFurnace = new GuiCheckBox(secondColumnX, secondColumnY, GuiLangKeys.translateString("prefab.gui.starter.addfurnace"), this.houseConfiguration.addFurnace, null);
        this.btnAddFurnace.setFGColor(color);
        this.btnAddFurnace.setWithShadow(false);
        this.btnAddFurnace.visible = false;
        this.addButton((Widget)this.btnAddFurnace);
        if (this.serverConfiguration.addFurnace) {
            secondColumnY += 15;
        }
        this.btnAddBed = new GuiCheckBox(secondColumnX, secondColumnY, GuiLangKeys.translateString("prefab.gui.starter.addbed"), this.houseConfiguration.addBed, null);
        this.btnAddBed.setFGColor(color);
        this.btnAddBed.setWithShadow(false);
        this.btnAddBed.visible = false;
        this.addButton((Widget)this.btnAddBed);
        if (this.serverConfiguration.addBed) {
            secondColumnY += 15;
        }
        this.btnAddCraftingTable = new GuiCheckBox(x, y, GuiLangKeys.translateString("prefab.gui.starter.addcraftingtable"), this.houseConfiguration.addCraftingTable, null);
        this.btnAddCraftingTable.setFGColor(color);
        this.btnAddCraftingTable.setWithShadow(false);
        this.btnAddCraftingTable.visible = false;
        this.addButton((Widget)this.btnAddCraftingTable);
        if (this.serverConfiguration.addCraftingTable) {
            y += 15;
        }
        this.btnAddTorches = new GuiCheckBox(x, y, GuiLangKeys.translateString("prefab.gui.starter.addtorches"), this.houseConfiguration.addTorches, null);
        this.btnAddTorches.setFGColor(color);
        this.btnAddTorches.setWithShadow(false);
        this.btnAddTorches.visible = false;
        this.addButton((Widget)this.btnAddTorches);
        if (this.serverConfiguration.addTorches) {
            y += 15;
        }
        this.btnAddChest = new GuiCheckBox(x, y, GuiLangKeys.translateString("prefab.gui.starter.addchest"), this.houseConfiguration.addChest, null);
        this.btnAddChest.setFGColor(color);
        this.btnAddChest.setWithShadow(false);
        this.btnAddChest.visible = false;
        this.addButton((Widget)this.btnAddChest);
        if (this.serverConfiguration.addChests) {
            y += 15;
        }
        this.btnAddMineShaft = new GuiCheckBox(x, y, GuiLangKeys.translateString("prefab.gui.starter.buildmineshaft"), this.houseConfiguration.addMineShaft, null);
        this.btnAddMineShaft.setFGColor(color);
        this.btnAddMineShaft.setWithShadow(false);
        this.btnAddMineShaft.visible = false;
        this.addButton((Widget)this.btnAddMineShaft);
        if (this.serverConfiguration.addMineshaft) {
            y += 15;
        }
        this.btnAddChestContents = new GuiCheckBox(x, y, GuiLangKeys.translateString("prefab.gui.starter.addchestcontents"), this.houseConfiguration.addChestContents, null);
        this.btnAddChestContents.setFGColor(color);
        this.btnAddChestContents.setWithShadow(false);
        this.btnAddChestContents.visible = false;
        this.addButton((Widget)this.btnAddChestContents);
        if (this.allowItemsInChestAndFurnace) {
            y += 15;
        }
        x = grayBoxX + 10;
        y = grayBoxY + 20;
        this.btnGlassColor = new ExtendedButton(x, y, 90, 20, GuiLangKeys.translateDye(this.houseConfiguration.glassColor), this::actionPerformed);
        this.addButton((Widget)this.btnGlassColor);
        x = secondColumnX;
        this.btnBedColor = new ExtendedButton(x, y, 90, 20, GuiLangKeys.translateDye(this.houseConfiguration.bedColor), this::actionPerformed);
        this.addButton((Widget)this.btnBedColor);
        this.tabGeneral = new GuiTab(this.Tabs, GuiLangKeys.translateString("prefab.gui.starter.tab.general"), grayBoxX + 3, grayBoxY - 20);
        this.Tabs.AddTab(this.tabGeneral);
        this.tabConfig = new GuiTab(this.Tabs, GuiLangKeys.translateString("prefab.gui.starter.tab.config"), grayBoxX + 54, grayBoxY - 20);
        this.Tabs.AddTab(this.tabConfig);
        this.tabBlockTypes = new GuiTab(this.Tabs, GuiLangKeys.translateString("prefab.gui.starter.tab.block"), grayBoxX + 105, grayBoxY - 20);
        this.tabBlockTypes.setWidth(70);
        this.Tabs.AddTab(this.tabBlockTypes);
        this.btnBuild = new ExtendedButton(grayBoxX + 10, grayBoxY + 136, 90, 20, GuiLangKeys.translateString("prefab.gui.button.build"), this::actionPerformed);
        this.addButton((Widget)this.btnBuild);
        this.btnCancel = new ExtendedButton(grayBoxX + 147, grayBoxY + 136, 90, 20, GuiLangKeys.translateString("prefab.gui.button.cancel"), this::actionPerformed);
        this.addButton((Widget)this.btnCancel);
    }
}

