/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.Structures.Gui;

import com.wuest.prefab.Events.ClientEventHandler;
import com.wuest.prefab.Gui.GuiLangKeys;
import com.wuest.prefab.Structures.Base.EnumStairsMaterial;
import com.wuest.prefab.Structures.Base.EnumStructureMaterial;
import com.wuest.prefab.Structures.Config.StructurePartConfiguration;
import com.wuest.prefab.Structures.Gui.GuiStructure;
import com.wuest.prefab.Structures.Messages.StructureTagMessage;
import com.wuest.prefab.Structures.Predefined.StructurePart;
import com.wuest.prefab.Structures.Render.StructureRenderHandler;
import com.wuest.prefab.Tuple;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.AbstractButton;
import net.minecraft.util.Direction;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.gui.widget.ExtendedButton;
import net.minecraftforge.fml.client.gui.widget.Slider;

public class GuiStructurePart
extends GuiStructure {
    protected StructurePartConfiguration configuration;
    private Slider sldrStairWidth;
    private Slider sldrStairHeight;
    private Slider sldrGeneralWidth;
    private Slider sldrGeneralHeight;
    private ExtendedButton btnPartStyle;
    private ExtendedButton btnMaterialType;
    private ExtendedButton btnStairsMaterialType;
    private int modifiedInitialXAxis = 213;
    private int modifiedInitialYAxis = 83;

    public GuiStructurePart() {
        super("Structure Part");
        this.structureConfiguration = StructureTagMessage.EnumStructureConfiguration.Parts;
    }

    @Override
    protected void Initialize() {
        this.configuration = ClientEventHandler.playerConfig.getClientConfig("Parts", StructurePartConfiguration.class);
        this.configuration.pos = this.pos;
        int grayBoxX = this.getCenteredXAxis() - this.modifiedInitialXAxis;
        int grayBoxY = this.getCenteredYAxis() - this.modifiedInitialYAxis;
        this.btnBuild = this.createAndAddButton(grayBoxX + 10, grayBoxY + 136, 90, 20, GuiLangKeys.translateString("prefab.gui.button.build"));
        this.btnCancel = this.createAndAddButton(grayBoxX + 147, grayBoxY + 136, 90, 20, GuiLangKeys.translateString("prefab.gui.button.cancel"));
        this.btnVisualize = this.createAndAddButton(grayBoxX + 10, grayBoxY + 90, 90, 20, GuiLangKeys.translateString("prefab.gui.button.preview"));
        this.sldrStairHeight = new Slider(grayBoxX + 147, grayBoxY + 100, 90, 20, "", "", 1.0, 9.0, (double)this.configuration.stairHeight, false, true, this::buttonClicked);
        this.addButton((Widget)this.sldrStairHeight);
        this.sldrStairWidth = new Slider(grayBoxX + 147, grayBoxY + 60, 90, 20, "", "", 1.0, 9.0, (double)this.configuration.stairWidth, false, true, this::buttonClicked);
        this.addButton((Widget)this.sldrStairWidth);
        this.sldrGeneralHeight = new Slider(grayBoxX + 147, grayBoxY + 100, 90, 20, "", "", 3.0, 9.0, (double)this.configuration.generalHeight, false, true, this::buttonClicked);
        this.addButton((Widget)this.sldrGeneralHeight);
        this.sldrGeneralWidth = new Slider(grayBoxX + 147, grayBoxY + 60, 90, 20, "", "", 3.0, 9.0, (double)this.configuration.generalWidth, false, true, this::buttonClicked);
        this.addButton((Widget)this.sldrGeneralWidth);
        this.btnPartStyle = this.createAndAddButton(grayBoxX + 10, grayBoxY + 20, 90, 20, GuiLangKeys.translateString(this.configuration.style.translateKey));
        this.btnMaterialType = this.createAndAddButton(grayBoxX + 147, grayBoxY + 20, 90, 20, this.configuration.partMaterial.getTranslatedName());
        this.btnStairsMaterialType = this.createAndAddButton(grayBoxX + 147, grayBoxY + 20, 90, 20, this.configuration.stairsMaterial.getTranslatedName());
    }

    @Override
    protected Tuple<Integer, Integer> getAdjustedXYValue() {
        return new Tuple<Integer, Integer>(this.getCenteredXAxis() - this.modifiedInitialXAxis, this.getCenteredYAxis() - this.modifiedInitialYAxis);
    }

    @Override
    protected void preButtonRender(int x, int y) {
        super.preButtonRender(x, y);
        this.minecraft.func_110434_K().func_110577_a(this.configuration.style.getPictureLocation());
        GuiStructurePart.drawModalRectWithCustomSizedTexture(x + 250, y, 1, this.configuration.style.imageWidth, this.configuration.style.imageHeight, this.configuration.style.imageWidth, this.configuration.style.imageHeight);
    }

    @Override
    protected void postButtonRender(int x, int y) {
        this.minecraft.field_71466_p.func_211126_b(GuiLangKeys.translateString("prefab.gui.style"), (float)(x + 10), (float)(y + 10), this.textColor);
        this.minecraft.field_71466_p.func_211126_b(GuiLangKeys.translateString("prefab.gui.material"), (float)(x + 147), (float)(y + 10), this.textColor);
        if (this.configuration.style == StructurePartConfiguration.EnumStyle.Stairs || this.configuration.style == StructurePartConfiguration.EnumStyle.Roof) {
            this.sldrStairHeight.visible = this.configuration.style != StructurePartConfiguration.EnumStyle.Roof;
            this.sldrStairWidth.visible = true;
            this.sldrGeneralHeight.visible = false;
            this.sldrGeneralWidth.visible = false;
            this.btnStairsMaterialType.visible = true;
            this.btnMaterialType.visible = false;
        } else {
            this.btnStairsMaterialType.visible = false;
            this.btnMaterialType.visible = true;
            this.sldrStairHeight.visible = false;
            this.sldrStairWidth.visible = false;
            this.sldrGeneralHeight.visible = true;
            this.sldrGeneralWidth.visible = true;
        }
        if (this.configuration.style != StructurePartConfiguration.EnumStyle.Roof) {
            if (this.configuration.style == StructurePartConfiguration.EnumStyle.Floor) {
                this.minecraft.field_71466_p.func_211126_b(GuiLangKeys.translateString("prefab.gui.length"), (float)(x + 147), (float)(y + 90), this.textColor);
            } else {
                this.minecraft.field_71466_p.func_211126_b(GuiLangKeys.translateString("prefab.gui.height"), (float)(x + 147), (float)(y + 90), this.textColor);
            }
        }
        if (this.configuration.style == StructurePartConfiguration.EnumStyle.Roof) {
            this.minecraft.field_71466_p.func_211126_b(GuiLangKeys.translateString("prefab.gui.height"), (float)(x + 147), (float)(y + 50), this.textColor);
        } else {
            this.minecraft.field_71466_p.func_211126_b(GuiLangKeys.translateString("prefab.gui.width"), (float)(x + 147), (float)(y + 50), this.textColor);
        }
    }

    @Override
    public void buttonClicked(AbstractButton button) {
        this.configuration.houseFacing = this.minecraft.field_71439_g.func_174811_aO().func_176734_d();
        this.configuration.stairHeight = this.sldrStairHeight.getValueInt();
        this.configuration.stairWidth = this.sldrStairWidth.getValueInt();
        this.configuration.generalHeight = this.sldrGeneralHeight.getValueInt();
        this.configuration.generalWidth = this.sldrGeneralWidth.getValueInt();
        this.performCancelOrBuildOrHouseFacing(this.configuration, button);
        if (button == this.btnMaterialType) {
            this.configuration.partMaterial = EnumStructureMaterial.getMaterialByNumber(this.configuration.partMaterial.getNumber() + 1);
            this.btnMaterialType.setMessage(this.configuration.partMaterial.getTranslatedName());
        }
        if (button == this.btnStairsMaterialType) {
            this.configuration.stairsMaterial = EnumStairsMaterial.getByOrdinal(this.configuration.stairsMaterial.ordinal() + 1);
            this.btnStairsMaterialType.setMessage(this.configuration.stairsMaterial.getTranslatedName());
        } else if (button == this.btnPartStyle) {
            this.configuration.style = StructurePartConfiguration.EnumStyle.getByOrdinal(this.configuration.style.ordinal() + 1);
            this.btnPartStyle.setMessage(GuiLangKeys.translateString(this.configuration.style.translateKey));
        } else if (button == this.btnVisualize) {
            StructurePart structure = new StructurePart();
            structure.getClearSpace().getShape().setDirection(Direction.NORTH);
            structure.setupStructure((World)this.minecraft.field_71441_e, this.configuration, this.pos);
            StructureRenderHandler.setStructure(structure, Direction.SOUTH, this.configuration);
            this.minecraft.func_147108_a(null);
        }
    }
}

