/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.Structures.Gui;

import com.wuest.prefab.Events.ClientEventHandler;
import com.wuest.prefab.Gui.GuiLangKeys;
import com.wuest.prefab.Structures.Config.WareHouseConfiguration;
import com.wuest.prefab.Structures.Gui.GuiStructure;
import com.wuest.prefab.Structures.Messages.StructureTagMessage;
import com.wuest.prefab.Structures.Predefined.StructureWarehouse;
import com.wuest.prefab.Structures.Render.StructureRenderHandler;
import com.wuest.prefab.Tuple;
import net.minecraft.client.gui.widget.button.AbstractButton;
import net.minecraft.item.DyeColor;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.gui.widget.ExtendedButton;

public class GuiWareHouse
extends GuiStructure {
    private static final ResourceLocation wareHouseTopDown = new ResourceLocation("prefab", "textures/gui/warehouse_top_down.png");
    protected WareHouseConfiguration configuration;
    String clientGUIIdentifier;
    private ExtendedButton btnGlassColor;

    public GuiWareHouse() {
        super("Warehouse");
        this.structureConfiguration = StructureTagMessage.EnumStructureConfiguration.WareHouse;
        this.clientGUIIdentifier = "Warehouse";
    }

    @Override
    public void Initialize() {
        this.configuration = ClientEventHandler.playerConfig.getClientConfig(this.clientGUIIdentifier, WareHouseConfiguration.class);
        this.configuration.pos = this.pos;
        this.configuration.houseFacing = Direction.NORTH;
        int grayBoxX = this.getCenteredXAxis() - 180;
        int grayBoxY = this.getCenteredYAxis() - 83;
        this.btnGlassColor = this.createAndAddButton(grayBoxX + 10, grayBoxY + 20, 90, 20, GuiLangKeys.translateDye(this.configuration.dyeColor));
        this.btnVisualize = this.createAndAddButton(grayBoxX + 10, grayBoxY + 90, 90, 20, GuiLangKeys.translateString("prefab.gui.button.preview"));
        this.btnBuild = this.createAndAddButton(grayBoxX + 10, grayBoxY + 136, 90, 20, GuiLangKeys.translateString("prefab.gui.button.build"));
        this.btnCancel = this.createAndAddButton(grayBoxX + 147, grayBoxY + 136, 90, 20, GuiLangKeys.translateString("prefab.gui.button.cancel"));
    }

    @Override
    protected Tuple<Integer, Integer> getAdjustedXYValue() {
        return new Tuple<Integer, Integer>(this.getCenteredXAxis() - 180, this.getCenteredYAxis() - 83);
    }

    @Override
    protected void preButtonRender(int x, int y) {
        super.preButtonRender(x, y);
        this.minecraft.func_110434_K().func_110577_a(wareHouseTopDown);
        GuiWareHouse.drawModalRectWithCustomSizedTexture(x + 250, y, 1, 132, 153, 132.0f, 153.0f);
    }

    @Override
    protected void postButtonRender(int x, int y) {
        this.minecraft.field_71466_p.func_211126_b(GuiLangKeys.translateString("prefab.gui.structure.glass"), (float)(x + 10), (float)(y + 10), this.textColor);
        this.minecraft.field_71466_p.func_78279_b(GuiLangKeys.translateString("prefab.gui.structure.block.clicked"), x + 147, y + 10, 95, this.textColor);
    }

    @Override
    public void buttonClicked(AbstractButton button) {
        this.performCancelOrBuildOrHouseFacing(this.configuration, button);
        if (button == this.btnGlassColor) {
            this.configuration.dyeColor = DyeColor.func_196056_a((int)(this.configuration.dyeColor.func_196059_a() + 1));
            this.btnGlassColor.setMessage(GuiLangKeys.translateDye(this.configuration.dyeColor));
        } else if (button == this.btnVisualize) {
            if (this.configuration.advanced) {
                StructureWarehouse structure = (StructureWarehouse)StructureWarehouse.CreateInstance("assets/prefab/structures/advanced_warehouse.zip", StructureWarehouse.class);
                StructureRenderHandler.setStructure(structure, Direction.NORTH, this.configuration);
            } else {
                StructureWarehouse structure = (StructureWarehouse)StructureWarehouse.CreateInstance("assets/prefab/structures/warehouse.zip", StructureWarehouse.class);
                StructureRenderHandler.setStructure(structure, Direction.NORTH, this.configuration);
            }
            assert (this.minecraft != null);
            this.minecraft.func_147108_a(null);
        }
    }
}

