/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.Structures.Items;

import com.wuest.prefab.Gui.GuiLangKeys;
import com.wuest.prefab.ModRegistry;
import com.wuest.prefab.Prefab;
import com.wuest.prefab.Structures.Items.StructureItem;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemBulldozer
extends StructureItem {
    public ItemBulldozer(String name) {
        super(name, new Item.Properties().func_200916_a(ItemGroup.field_78026_f).func_200918_c(4));
    }

    @Override
    public ActionResultType func_195939_a(ItemUseContext context) {
        if (context.func_195991_k().field_72995_K && context.func_196000_l() == Direction.UP && this.getPoweredValue(context.func_195999_j(), context.func_221531_n())) {
            Prefab.proxy.openGuiForItem(context);
            return ActionResultType.PASS;
        }
        return ActionResultType.FAIL;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        boolean advancedKeyDown = Screen.hasShiftDown();
        if (!advancedKeyDown) {
            tooltip.add((ITextComponent)new StringTextComponent(GuiLangKeys.translateString("prefab.gui.tooltip.shift")));
        } else if (this.getPoweredValue(stack)) {
            tooltip.add((ITextComponent)new StringTextComponent(GuiLangKeys.translateString("prefab.gui.tooltip.bulldozer_powered")));
        } else {
            tooltip.add((ITextComponent)new StringTextComponent(GuiLangKeys.translateString("prefab.gui.tooltip.bulldozer_unpowered")));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return this.getPoweredValue(stack) || super.func_77636_d(stack);
    }

    public CompoundNBT getShareTag(ItemStack stack) {
        if (stack.func_77978_p() == null || stack.func_77978_p().isEmpty()) {
            stack.func_77982_d(stack.serializeNBT());
        }
        return stack.func_77978_p();
    }

    private boolean getPoweredValue(PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        return this.getPoweredValue(stack);
    }

    private boolean getPoweredValue(ItemStack stack) {
        if (stack.func_77973_b() == ModRegistry.Bulldozer()) {
            if (stack.func_77978_p() == null || stack.func_77978_p().isEmpty()) {
                stack.func_77982_d(stack.serializeNBT());
            } else {
                CompoundNBT prefabTag;
                CompoundNBT tag = stack.func_77978_p();
                if (tag.func_74764_b("prefab") && (prefabTag = tag.func_74775_l("prefab")).func_74764_b("powered")) {
                    return prefabTag.func_74767_n("powered");
                }
            }
        }
        return false;
    }

    public void setPoweredValue(ItemStack stack, boolean value) {
        if (stack.func_77978_p() == null || stack.func_77978_p().isEmpty()) {
            stack.func_77982_d(stack.serializeNBT());
        }
        CompoundNBT prefabTag = new CompoundNBT();
        prefabTag.func_74757_a("powered", value);
        stack.func_77978_p().func_218657_a("prefab", (INBT)prefabTag);
    }
}

