/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.Structures.Predefined;

import com.wuest.prefab.Config.EntityPlayerConfiguration;
import com.wuest.prefab.Prefab;
import com.wuest.prefab.Proxy.Messages.PlayerEntityTagMessage;
import com.wuest.prefab.Structures.Base.BuildBlock;
import com.wuest.prefab.Structures.Base.BuildClear;
import com.wuest.prefab.Structures.Base.BuildShape;
import com.wuest.prefab.Structures.Base.BuildingMethods;
import com.wuest.prefab.Structures.Base.PositionOffset;
import com.wuest.prefab.Structures.Base.Structure;
import com.wuest.prefab.Structures.Config.HouseConfiguration;
import com.wuest.prefab.Structures.Config.StructureConfiguration;
import java.util.ArrayList;
import net.minecraft.block.BarrelBlock;
import net.minecraft.block.BedBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ChestBlock;
import net.minecraft.block.CraftingTableBlock;
import net.minecraft.block.FurnaceBlock;
import net.minecraft.block.SeaGrassBlock;
import net.minecraft.block.StandingSignBlock;
import net.minecraft.block.TallSeaGrassBlock;
import net.minecraft.block.TorchBlock;
import net.minecraft.block.TrapDoorBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.tileentity.SignTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkDirection;

public class StructureAlternateStart
extends Structure {
    private BlockPos chestPosition = null;
    private BlockPos furnacePosition = null;
    private BlockPos trapDoorPosition = null;
    private BlockPos signPosition = null;
    private BlockPos bedHeadPosition = null;
    private BlockPos bedFootPosition = null;

    public static void ScanBasicHouseStructure(World world, BlockPos originalPos, Direction playerFacing) {
        BuildClear clearedSpace = new BuildClear();
        clearedSpace.getShape().setDirection(Direction.SOUTH);
        clearedSpace.getShape().setHeight(10);
        clearedSpace.getShape().setLength(12);
        clearedSpace.getShape().setWidth(13);
        clearedSpace.getStartingPosition().setSouthOffset(1);
        clearedSpace.getStartingPosition().setEastOffset(5);
        clearedSpace.getStartingPosition().setHeightOffset(-1);
        BlockPos corner = originalPos.func_177965_g(5).func_177968_d().func_177977_b();
        BlockPos corner2 = originalPos.func_177985_f(8).func_177970_e(13).func_177981_b(10);
        Structure.ScanStructure(world, originalPos, corner, corner2, "..\\src\\main\\resources\\assets\\prefab\\structures\\basic_house.zip", clearedSpace, playerFacing, false, false);
    }

    public static void ScanRanchStructure(World world, BlockPos originalPos, Direction playerFacing) {
        BuildClear clearedSpace = new BuildClear();
        clearedSpace.getShape().setDirection(Direction.SOUTH);
        clearedSpace.getShape().setHeight(7);
        clearedSpace.getShape().setLength(21);
        clearedSpace.getShape().setWidth(11);
        clearedSpace.getStartingPosition().setSouthOffset(1);
        clearedSpace.getStartingPosition().setEastOffset(8);
        clearedSpace.getStartingPosition().setHeightOffset(-1);
        Structure.ScanStructure(world, originalPos, originalPos.func_177965_g(8).func_177968_d().func_177977_b(), originalPos.func_177970_e(22).func_177985_f(3).func_177981_b(8), "..\\src\\main\\resources\\assets\\prefab\\structures\\ranch_house.zip", clearedSpace, playerFacing, false, false);
    }

    public static void ScanLoftStructure(World world, BlockPos originalPos, Direction playerFacing) {
        BuildClear clearedSpace = new BuildClear();
        clearedSpace.getShape().setDirection(Direction.SOUTH);
        clearedSpace.getShape().setHeight(9);
        clearedSpace.getShape().setLength(13);
        clearedSpace.getShape().setWidth(16);
        clearedSpace.getStartingPosition().setSouthOffset(1);
        clearedSpace.getStartingPosition().setEastOffset(7);
        Structure.ScanStructure(world, originalPos, originalPos.func_177965_g(7).func_177968_d(), originalPos.func_177970_e(14).func_177985_f(8).func_177981_b(9), "..\\src\\main\\resources\\assets\\prefab\\structures\\loft_house.zip", clearedSpace, playerFacing, false, false);
    }

    public static void ScanHobbitStructure(World world, BlockPos originalPos, Direction playerFacing) {
        BuildClear clearedSpace = new BuildClear();
        clearedSpace.getShape().setDirection(Direction.SOUTH);
        clearedSpace.getShape().setHeight(12);
        clearedSpace.getShape().setLength(16);
        clearedSpace.getShape().setWidth(16);
        clearedSpace.getStartingPosition().setSouthOffset(1);
        clearedSpace.getStartingPosition().setEastOffset(8);
        clearedSpace.getStartingPosition().setHeightOffset(-3);
        Structure.ScanStructure(world, originalPos, originalPos.func_177965_g(8).func_177968_d().func_177979_c(3), originalPos.func_177970_e(16).func_177985_f(8).func_177981_b(12), "..\\src\\main\\resources\\assets\\prefab\\structures\\hobbit_house.zip", clearedSpace, playerFacing, false, false);
    }

    public static void ScanDesert2Structure(World world, BlockPos originalPos, Direction playerFacing) {
        BuildClear clearedSpace = new BuildClear();
        clearedSpace.getShape().setDirection(Direction.SOUTH);
        clearedSpace.getShape().setHeight(10);
        clearedSpace.getShape().setLength(14);
        clearedSpace.getShape().setWidth(11);
        clearedSpace.getStartingPosition().setSouthOffset(1);
        clearedSpace.getStartingPosition().setEastOffset(8);
        clearedSpace.getStartingPosition().setHeightOffset(-1);
        BlockPos corner = originalPos.func_177965_g(8).func_177968_d().func_177977_b();
        BlockPos corner2 = originalPos.func_177985_f(6).func_177970_e(16).func_177981_b(10);
        Structure.ScanStructure(world, originalPos, corner, corner2, "..\\src\\main\\resources\\assets\\prefab\\structures\\desert_house2.zip", clearedSpace, playerFacing, false, false);
    }

    public static void ScanSubAquaticStructure(World world, BlockPos originalPos, Direction playerFacing) {
        BuildClear clearedSpace = new BuildClear();
        clearedSpace.getShape().setDirection(Direction.SOUTH);
        clearedSpace.getShape().setHeight(13);
        clearedSpace.getShape().setLength(9);
        clearedSpace.getShape().setWidth(12);
        clearedSpace.getStartingPosition().setSouthOffset(1);
        clearedSpace.getStartingPosition().setEastOffset(8);
        clearedSpace.getStartingPosition().setHeightOffset(-1);
        BlockPos corner = originalPos.func_177965_g(8).func_177968_d().func_177977_b();
        BlockPos corner2 = originalPos.func_177985_f(4).func_177970_e(10).func_177981_b(12);
        Structure.ScanStructure(world, originalPos, corner, corner2, "..\\src\\main\\resources\\assets\\prefab\\structures\\subaquatic_house.zip", clearedSpace, playerFacing, true, true);
    }

    public static void ScanStructure(World world, BlockPos originalPos, Direction playerFacing, String structureFileName, boolean includeAir, boolean excludeWater) {
        BuildClear clearedSpace = new BuildClear();
        clearedSpace.getShape().setDirection(Direction.SOUTH);
        clearedSpace.getShape().setHeight(8);
        clearedSpace.getShape().setLength(16);
        clearedSpace.getShape().setWidth(16);
        clearedSpace.getStartingPosition().setSouthOffset(1);
        clearedSpace.getStartingPosition().setEastOffset(8);
        clearedSpace.getStartingPosition().setHeightOffset(-1);
        BuildShape buildShape = clearedSpace.getShape();
        PositionOffset offset = clearedSpace.getStartingPosition();
        int downOffset = offset.getHeightOffset() < 0 ? Math.abs(offset.getHeightOffset()) : 0;
        BlockPos cornerPos = originalPos.func_177965_g(offset.getEastOffset()).func_177970_e(offset.getSouthOffset()).func_177979_c(downOffset);
        Structure.ScanStructure(world, originalPos, cornerPos, cornerPos.func_177970_e(buildShape.getLength()).func_177985_f(buildShape.getWidth()).func_177981_b(buildShape.getHeight()), "..\\src\\main\\resources\\assets\\prefab\\structures\\" + structureFileName + ".zip", clearedSpace, playerFacing, includeAir, excludeWater);
    }

    @Override
    protected Boolean CustomBlockProcessingHandled(StructureConfiguration configuration, BuildBlock block, World world, BlockPos originalPos, Direction assumedNorth, Block foundBlock, BlockState blockState, PlayerEntity player) {
        HouseConfiguration houseConfig = (HouseConfiguration)configuration;
        if (!houseConfig.addBed && foundBlock instanceof BedBlock || !houseConfig.addChest && foundBlock instanceof ChestBlock || !houseConfig.addTorches && foundBlock instanceof TorchBlock || !houseConfig.addCraftingTable && foundBlock instanceof CraftingTableBlock || !houseConfig.addFurnace && foundBlock instanceof FurnaceBlock || !houseConfig.addChest && foundBlock instanceof BarrelBlock || foundBlock instanceof SeaGrassBlock || foundBlock instanceof TallSeaGrassBlock) {
            return true;
        }
        if (foundBlock instanceof FurnaceBlock) {
            this.furnacePosition = block.getStartingPosition().getRelativePosition(originalPos, this.getClearSpace().getShape().getDirection(), configuration.houseFacing);
        } else if (foundBlock instanceof TrapDoorBlock && houseConfig.addMineShaft) {
            this.trapDoorPosition = block.getStartingPosition().getRelativePosition(originalPos, this.getClearSpace().getShape().getDirection(), configuration.houseFacing);
        } else if (foundBlock instanceof ChestBlock && this.chestPosition == null || foundBlock instanceof BarrelBlock && this.chestPosition == null) {
            this.chestPosition = block.getStartingPosition().getRelativePosition(originalPos, this.getClearSpace().getShape().getDirection(), configuration.houseFacing);
        } else if (foundBlock instanceof StandingSignBlock) {
            this.signPosition = block.getStartingPosition().getRelativePosition(originalPos, this.getClearSpace().getShape().getDirection(), configuration.houseFacing);
        } else if (foundBlock instanceof BedBlock && houseConfig.addBed) {
            this.bedHeadPosition = block.getStartingPosition().getRelativePosition(originalPos, this.getClearSpace().getShape().getDirection(), configuration.houseFacing);
            this.bedFootPosition = block.getSubBlock().getStartingPosition().getRelativePosition(originalPos, this.getClearSpace().getShape().getDirection(), configuration.houseFacing);
        }
        if (foundBlock.getRegistryName().func_110624_b().equals(Blocks.field_196807_gj.getRegistryName().func_110624_b()) && foundBlock.getRegistryName().func_110623_a().endsWith("stained_glass")) {
            blockState = this.getStainedGlassBlock(houseConfig.glassColor);
            block.setBlockState(blockState);
            this.priorityOneBlocks.add(block);
            return true;
        }
        if (foundBlock.getRegistryName().func_110624_b().equals(Blocks.field_196825_gz.getRegistryName().func_110624_b()) && foundBlock.getRegistryName().func_110623_a().endsWith("stained_glass_pane")) {
            blockState = this.getStainedGlassPaneBlock(houseConfig.glassColor);
            block.setBlockState(blockState);
            this.priorityOneBlocks.add(block);
            return true;
        }
        return false;
    }

    @Override
    public void AfterBuilding(StructureConfiguration configuration, ServerWorld world, BlockPos originalPos, Direction assumedNorth, PlayerEntity player) {
        TileEntity tileEntity;
        HouseConfiguration houseConfig = (HouseConfiguration)configuration;
        EntityPlayerConfiguration playerConfig = EntityPlayerConfiguration.loadFromEntityData(player);
        ArrayList<BlockPos> furnacePositions = new ArrayList<BlockPos>();
        if (this.furnacePosition != null) {
            furnacePositions.add(this.furnacePosition);
        }
        BuildingMethods.FillFurnaces((World)world, furnacePositions);
        if (this.chestPosition != null && houseConfig.addChestContents) {
            BuildingMethods.FillChest((World)world, this.chestPosition);
        }
        if (this.trapDoorPosition != null && this.trapDoorPosition.func_177956_o() > 15 && houseConfig.addMineShaft) {
            BuildingMethods.PlaceMineShaft(world, this.trapDoorPosition.func_177977_b(), houseConfig.houseFacing, false);
        }
        if (this.signPosition != null && (tileEntity = world.func_175625_s(this.signPosition)) instanceof SignTileEntity) {
            SignTileEntity signTile = (SignTileEntity)tileEntity;
            signTile.field_145915_a[0] = new StringTextComponent("This is");
            signTile.field_145915_a[1] = player.func_145748_c_().getString().length() >= 15 ? new StringTextComponent(player.func_145748_c_().getString()) : new StringTextComponent(player.func_145748_c_().getString() + "'s");
            signTile.field_145915_a[2] = new StringTextComponent("house!");
        }
        if (this.bedHeadPosition != null && houseConfig.addBed) {
            BuildingMethods.PlaceColoredBed((World)world, this.bedHeadPosition, this.bedFootPosition, houseConfig.bedColor);
        }
        playerConfig.builtStarterHouse = true;
        playerConfig.saveToPlayer(player);
        Prefab.network.sendTo((Object)new PlayerEntityTagMessage(playerConfig.getModIsPlayerNewTag(player)), ((ServerPlayerEntity)player).field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
    }
}

