/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.Structures.Render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.wuest.prefab.Events.ClientEventHandler;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.FloatBuffer;
import java.nio.charset.StandardCharsets;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.resources.IResourceManagerReloadListener;
import org.lwjgl.opengl.ARBShaderObjects;
import org.lwjgl.opengl.GL11;
import org.lwjgl.system.MemoryUtil;

public class ShaderHelper {
    public static final FloatBuffer FLOAT_BUF = MemoryUtil.memAllocFloat((int)1);
    private static final int VERT = 35633;
    private static final int FRAG = 35632;
    public static int alphaShader = 0;
    private static boolean lighting;

    public static void Initialize() {
        if (Minecraft.func_71410_x().func_195551_G() instanceof IReloadableResourceManager) {
            ((IReloadableResourceManager)Minecraft.func_71410_x().func_195551_G()).func_219534_a((IFutureReloadListener)((IResourceManagerReloadListener)manager -> {
                ShaderHelper.deleteShader(alphaShader);
                alphaShader = 0;
                alphaShader = ShaderHelper.createProgram("/assets/prefab/shader/alpha.vert", "/assets/prefab/shader/alpha.frag");
            }));
        }
    }

    public static void useShader(int shader, ShaderCallback callback) {
        if (alphaShader == 0) {
            alphaShader = ShaderHelper.createProgram("/assets/prefab/shader/alpha.vert", "/assets/prefab/shader/alpha.frag");
        }
        lighting = GL11.glGetBoolean((int)2896);
        GlStateManager.func_227722_g_();
        GlStateManager.func_227723_g_((int)shader);
        if (shader != 0) {
            int time = GlStateManager.func_227680_b_((int)shader, (CharSequence)"time");
            GlStateManager.func_227718_f_((int)time, (int)ClientEventHandler.ticksInGame);
            if (callback != null) {
                callback.call(shader);
            }
        }
    }

    public static void useShader(int shader) {
        ShaderHelper.useShader(shader, null);
    }

    public static void releaseShader() {
        if (lighting) {
            RenderSystem.enableLighting();
        }
        ShaderHelper.useShader(0);
    }

    private static int createProgram(String vert, String frag) {
        int program;
        int vertId = 0;
        int fragId = 0;
        if (vert != null) {
            vertId = ShaderHelper.createShader(vert, 35633);
        }
        if (frag != null) {
            fragId = ShaderHelper.createShader(frag, 35632);
        }
        if ((program = ARBShaderObjects.glCreateProgramObjectARB()) == 0) {
            return 0;
        }
        if (vert != null) {
            ARBShaderObjects.glAttachObjectARB((int)program, (int)vertId);
        }
        if (frag != null) {
            ARBShaderObjects.glAttachObjectARB((int)program, (int)fragId);
        }
        ARBShaderObjects.glLinkProgramARB((int)program);
        if (ARBShaderObjects.glGetObjectParameteriARB((int)program, (int)35714) == 0) {
            return 0;
        }
        ARBShaderObjects.glValidateProgramARB((int)program);
        if (ARBShaderObjects.glGetObjectParameteriARB((int)program, (int)35715) == 0) {
            return 0;
        }
        return program;
    }

    private static int createShader(String filename, int shaderType) {
        int shader = 0;
        try {
            shader = ARBShaderObjects.glCreateShaderObjectARB((int)shaderType);
            if (shader == 0) {
                return 0;
            }
            ARBShaderObjects.glShaderSourceARB((int)shader, (CharSequence)ShaderHelper.readFileAsString(filename));
            ARBShaderObjects.glCompileShaderARB((int)shader);
            if (ARBShaderObjects.glGetObjectParameteriARB((int)shader, (int)35713) == 0) {
                throw new RuntimeException("Error creating shader: " + ShaderHelper.getLogInfo(shader));
            }
            return shader;
        }
        catch (Exception e) {
            ARBShaderObjects.glDeleteObjectARB((int)shader);
            e.printStackTrace();
            return -1;
        }
    }

    private static void deleteShader(int id) {
        if (id != 0) {
            ARBShaderObjects.glDeleteObjectARB((int)id);
        }
    }

    private static String readFileAsString(String filename) throws Exception {
        InputStream in = ShaderHelper.class.getResourceAsStream(filename);
        if (in == null) {
            return "";
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
            String string = reader.lines().collect(Collectors.joining("\n"));
            return string;
        }
    }

    private static String getLogInfo(int obj) {
        return ARBShaderObjects.glGetInfoLogARB((int)obj, (int)ARBShaderObjects.glGetObjectParameteriARB((int)obj, (int)35716));
    }

    @FunctionalInterface
    public static interface ShaderCallback {
        public void call(int var1);
    }
}

