/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.Config;

import com.wuest.prefab.Config.Structures.StructureConfiguration;
import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class EntityPlayerConfiguration {
    private static final String GIVEN_HOUSEBUILDER_TAG = "givenHousebuilder";
    private static final String Built_Starter_house_Tag = "builtStarterHouse";
    public static final String PLAYER_ENTITY_TAG = "IsPlayerNew";
    public boolean givenHouseBuilder = false;
    public boolean builtStarterHouse = false;
    public HashMap<String, StructureConfiguration> clientConfigurations = new HashMap();

    public static EntityPlayerConfiguration loadFromEntityData(EntityPlayer player) {
        EntityPlayerConfiguration config = new EntityPlayerConfiguration();
        NBTTagCompound compoundTag = config.getModIsPlayerNewTag(player);
        config.loadFromNBTTagCompound(compoundTag);
        return config;
    }

    public void loadFromNBTTagCompound(NBTTagCompound tag) {
        this.givenHouseBuilder = tag.func_74767_n(GIVEN_HOUSEBUILDER_TAG);
        this.builtStarterHouse = tag.func_74767_n(Built_Starter_house_Tag);
    }

    public NBTTagCompound getModIsPlayerNewTag(EntityPlayer player) {
        NBTTagCompound tag = player.getEntityData();
        NBTTagCompound newPlayerTag = null;
        if (tag.func_74764_b(PLAYER_ENTITY_TAG)) {
            newPlayerTag = tag.func_74775_l(PLAYER_ENTITY_TAG);
        } else {
            newPlayerTag = new NBTTagCompound();
            tag.func_74782_a(PLAYER_ENTITY_TAG, (NBTBase)newPlayerTag);
        }
        return newPlayerTag;
    }

    public void saveToPlayer(EntityPlayer player) {
        NBTTagCompound compoundTag = this.getModIsPlayerNewTag(player);
        compoundTag.func_74757_a(Built_Starter_house_Tag, this.builtStarterHouse);
        compoundTag.func_74757_a(GIVEN_HOUSEBUILDER_TAG, this.givenHouseBuilder);
    }

    public <T extends StructureConfiguration> T getClientConfig(String guiName, Class<T> structureConfiguration) {
        StructureConfiguration config = this.clientConfigurations.get(guiName);
        if (config == null) {
            try {
                config = (StructureConfiguration)structureConfiguration.newInstance();
                this.clientConfigurations.put(guiName, config);
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
            }
        }
        return (T)config;
    }

    public void clearNonPersistedObjects() {
        this.clientConfigurations.clear();
    }
}

