/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.Config;

import com.wuest.prefab.Gui.GuiLangKeys;
import com.wuest.prefab.ModRegistry;
import com.wuest.prefab.Prefab;
import com.wuest.prefab.Proxy.CommonProxy;
import com.wuest.prefab.UpdateChecker;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.registry.GameRegistry;
import scala.Tuple2;

public class ModConfiguration {
    public static String OPTIONS = "general.options";
    public static String ChestContentOptions = "general.options.chest contents";
    public static String RecipeOptions = "general.options.recipes";
    public static String tagKey = "PrefabConfig";
    private static String addHouseItemName = "Add House Item On New Player Join";
    private static String enableHouseGenerationRestrictionName = "Enable House Generation Restrictions";
    private static String maximumHouseSizeName = "Maximum Starting House Size";
    private static String enableVersionCheckMessageName = "Enable Version Checking";
    private static String enableLoftHouseName = "Enable Loft House";
    private static String includeSpawnersInMasherName = "Include Spawners in Monster Masher";
    private static String enableStructurePreviewName = "Include Structure Previews";
    private static String addModerateHouseInsteadName = "Add Moderate House on World Join";
    private static String includeMineshaftChestName = "Include Mineshaft Chest";
    private static String addSwordName = "Add Sword";
    private static String addAxeName = "Add Axe";
    private static String addHoeName = "Add Hoe";
    private static String addShovelName = "Add Shovel";
    private static String addPickAxeName = "Add Pickaxe";
    private static String addArmorName = "Add Armor";
    private static String addFoodName = "Add Food";
    private static String addCropsName = "Add Crops";
    private static String addDirtName = "Add Dirt";
    private static String addCobbleName = "Add Cobblestone";
    private static String addSaplingsName = "Add Saplings";
    private static String addTorchesName = "Add Torches";
    private static String versionMessageName = "Version Message";
    private static String showMessageName = "Show Message";
    public boolean addHouseItem = true;
    public boolean enableHouseGenerationRestrictions;
    public int maximumStartingHouseSize = 16;
    public boolean enableVersionCheckMessage = true;
    public boolean enableLoftHouse;
    public boolean includeSpawnersInMasher = true;
    public boolean enableStructurePreview = true;
    public boolean addModerateHouseInstead;
    public boolean includeMineshaftChest;
    public boolean addSword;
    public boolean addAxe;
    public boolean addHoe;
    public boolean addShovel;
    public boolean addPickAxe;
    public boolean addArmor;
    public boolean addFood;
    public boolean addCrops;
    public boolean addDirt;
    public boolean addCobble;
    public boolean addSaplings;
    public boolean addTorches;
    public String versionMessage = "";
    public boolean showMessage = false;

    public static void syncConfig() {
        Configuration config = Prefab.config;
        if (CommonProxy.proxyConfiguration == null) {
            CommonProxy.proxyConfiguration = new ModConfiguration();
        }
        CommonProxy.proxyConfiguration.addHouseItem = config.getBoolean(addHouseItemName, OPTIONS, true, "Determines if the house item is added to player inventory when joining the world for the first time. Server configuration overrides client.");
        CommonProxy.proxyConfiguration.enableHouseGenerationRestrictions = config.getBoolean(enableHouseGenerationRestrictionName, OPTIONS, false, "When true this option causes the Crafting Table, Furnace and Chest to not be added when creating a house, regardless of options chosen. Server Configuration overrides client.");
        CommonProxy.proxyConfiguration.maximumStartingHouseSize = config.getInt(maximumHouseSizeName, OPTIONS, 16, 5, 16, "Determines the maximum size the starting house can be generated as. Server configuration overrides client.");
        CommonProxy.proxyConfiguration.enableVersionCheckMessage = config.getBoolean(enableVersionCheckMessageName, OPTIONS, true, "Determines if version checking is enabled when application starts. Also determines if the chat message about old versions is shown when joining a world. Server configuration overrides client.");
        CommonProxy.proxyConfiguration.enableLoftHouse = config.getBoolean(enableLoftHouseName, OPTIONS, false, "Determines if the loft starter house is enabled. This house contains Nether materials in it's construction. Server configuration overrides client.");
        CommonProxy.proxyConfiguration.includeSpawnersInMasher = config.getBoolean(includeSpawnersInMasherName, OPTIONS, true, "Determines if the spawners for the Monster Masher building are included. Server configuration overrides client.");
        CommonProxy.proxyConfiguration.enableStructurePreview = config.getBoolean(enableStructurePreviewName, OPTIONS, true, "Determines if the Preview buttons in structure GUIs and other structure previews functions are enabled. Client side only.");
        CommonProxy.proxyConfiguration.addModerateHouseInstead = config.getBoolean(addModerateHouseInsteadName, OPTIONS, false, "Determines if the moderate house item is provided to the player instead of the starting house.");
        CommonProxy.proxyConfiguration.includeMineshaftChest = config.getBoolean(includeMineshaftChestName, OPTIONS, true, "Determines if the mineshaft chest is included when building mineshafts for various structures.");
        config.get(OPTIONS, enableVersionCheckMessageName, true).setRequiresMcRestart(true);
        config.get(OPTIONS, enableLoftHouseName, false).setRequiresMcRestart(true);
        config.setCategoryComment(ChestContentOptions, "This category is to determine the contents of the chest created by the house item. When playing on a server, the server configuration is used.");
        CommonProxy.proxyConfiguration.addSword = config.getBoolean(addSwordName, ChestContentOptions, true, "Determines if a Stone Sword is added the the chest when the house is created.");
        CommonProxy.proxyConfiguration.addAxe = config.getBoolean(addAxeName, ChestContentOptions, true, "Determines if a Stone Axe is added the the chest when the house is created.");
        CommonProxy.proxyConfiguration.addShovel = config.getBoolean(addShovelName, ChestContentOptions, true, "Determines if a Stone Shovel is added the the chest when the house is created.");
        CommonProxy.proxyConfiguration.addHoe = config.getBoolean(addHoeName, ChestContentOptions, true, "Determines if a Stone Hoe is added the the chest when the house is created.");
        CommonProxy.proxyConfiguration.addPickAxe = config.getBoolean(addPickAxeName, ChestContentOptions, true, "Determines if a Stone Pickaxe is added the the chest when the house is created.");
        CommonProxy.proxyConfiguration.addArmor = config.getBoolean(addArmorName, ChestContentOptions, true, "Determines if Leather Armor is added the the chest when the house is created.");
        CommonProxy.proxyConfiguration.addFood = config.getBoolean(addFoodName, ChestContentOptions, true, "Determines if Bread is added the the chest when the house is created.");
        CommonProxy.proxyConfiguration.addCrops = config.getBoolean(addCropsName, ChestContentOptions, true, "Determines if seeds, potatoes and carros are added the the chest when the house is created.");
        CommonProxy.proxyConfiguration.addDirt = config.getBoolean(addDirtName, ChestContentOptions, true, "Determines if a stack of dirt is added the the chest when the house is created.");
        CommonProxy.proxyConfiguration.addCobble = config.getBoolean(addCobbleName, ChestContentOptions, true, "Determines if a stack of cobble is added the the chest when the house is created.");
        CommonProxy.proxyConfiguration.addSaplings = config.getBoolean(addSaplingsName, ChestContentOptions, true, "Determines if a set of oak saplings are added the the chest when the house is created.");
        CommonProxy.proxyConfiguration.addTorches = config.getBoolean(addTorchesName, ChestContentOptions, true, "Determines if a set of torches are added the the chest when the house is created.");
        config.setCategoryComment(RecipeOptions, "This category determines if the recipes for the blocks/items in this are enabled");
        config.setCategoryRequiresMcRestart(RecipeOptions, true);
        for (Map.Entry<String, Tuple2<Boolean, ArrayList<IRecipe>>> set : ModRegistry.SavedRecipes.entrySet()) {
            boolean originalValue;
            boolean value = config.getBoolean(set.getKey(), RecipeOptions, true, "Determines if the recipe(s) associated with the " + set.getKey() + " are enabled.");
            if (value == (originalValue = ((Boolean)set.getValue()._1).booleanValue())) continue;
            set.setValue((Tuple2<Boolean, ArrayList<IRecipe>>)new Tuple2((Object)value, set.getValue()._2));
            if (value) {
                for (IRecipe recipe : (ArrayList)set.getValue()._2) {
                    GameRegistry.addRecipe((IRecipe)recipe);
                }
                continue;
            }
            for (IRecipe recipe : (ArrayList)set.getValue()._2) {
                CraftingManager.func_77594_a().func_77592_b().remove(recipe);
            }
        }
        if (config.hasChanged()) {
            config.save();
        }
    }

    public NBTTagCompound ToNBTTagCompound() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74757_a(addHouseItemName, this.addHouseItem);
        tag.func_74757_a(enableHouseGenerationRestrictionName, this.enableHouseGenerationRestrictions);
        tag.func_74768_a(maximumHouseSizeName, this.maximumStartingHouseSize);
        tag.func_74757_a(enableVersionCheckMessageName, this.enableVersionCheckMessage);
        tag.func_74757_a(enableLoftHouseName, this.enableLoftHouse);
        tag.func_74757_a(includeSpawnersInMasherName, this.includeSpawnersInMasher);
        tag.func_74757_a(enableStructurePreviewName, this.enableStructurePreview);
        tag.func_74757_a(addModerateHouseInsteadName, this.addModerateHouseInstead);
        tag.func_74757_a(includeMineshaftChestName, this.includeMineshaftChest);
        tag.func_74757_a(addSwordName, this.addSword);
        tag.func_74757_a(addAxeName, this.addAxe);
        tag.func_74757_a(addShovelName, this.addShovel);
        tag.func_74757_a(addHoeName, this.addHoe);
        tag.func_74757_a(addPickAxeName, this.addPickAxe);
        tag.func_74757_a(addArmorName, this.addArmor);
        tag.func_74757_a(addFoodName, this.addFood);
        tag.func_74757_a(addCropsName, this.addCrops);
        tag.func_74757_a(addDirtName, this.addDirt);
        tag.func_74757_a(addCobbleName, this.addCobble);
        tag.func_74757_a(addSaplingsName, this.addSaplings);
        tag.func_74757_a(addTorchesName, this.addTorches);
        tag.func_74778_a(versionMessageName, UpdateChecker.messageToShow);
        tag.func_74757_a(showMessageName, UpdateChecker.showMessage);
        for (Map.Entry<String, Tuple2<Boolean, ArrayList<IRecipe>>> set : ModRegistry.SavedRecipes.entrySet()) {
            tag.func_74757_a(set.getKey(), ((Boolean)set.getValue()._1()).booleanValue());
        }
        return tag;
    }

    public static ModConfiguration getFromNBTTagCompound(NBTTagCompound tag) {
        ModConfiguration config = new ModConfiguration();
        config.addHouseItem = tag.func_74767_n(addHouseItemName);
        config.enableHouseGenerationRestrictions = tag.func_74767_n(enableHouseGenerationRestrictionName);
        config.enableVersionCheckMessage = tag.func_74767_n(enableVersionCheckMessageName);
        config.enableLoftHouse = tag.func_74767_n(enableLoftHouseName);
        config.maximumStartingHouseSize = tag.func_74762_e(maximumHouseSizeName);
        config.includeSpawnersInMasher = tag.func_74767_n(includeSpawnersInMasherName);
        config.enableStructurePreview = tag.func_74767_n(enableStructurePreviewName);
        config.addModerateHouseInstead = tag.func_74767_n(addModerateHouseInsteadName);
        config.includeMineshaftChest = tag.func_74767_n(includeMineshaftChestName);
        if (config.maximumStartingHouseSize < 5 || config.maximumStartingHouseSize > 16) {
            config.maximumStartingHouseSize = 16;
        }
        config.addSword = tag.func_74767_n(addSwordName);
        config.addAxe = tag.func_74767_n(addAxeName);
        config.addShovel = tag.func_74767_n(addShovelName);
        config.addHoe = tag.func_74767_n(addHoeName);
        config.addPickAxe = tag.func_74767_n(addPickAxeName);
        config.addArmor = tag.func_74767_n(addArmorName);
        config.addFood = tag.func_74767_n(addFoodName);
        config.addCrops = tag.func_74767_n(addCropsName);
        config.addDirt = tag.func_74767_n(addDirtName);
        config.addCobble = tag.func_74767_n(addCobbleName);
        config.addSaplings = tag.func_74767_n(addSaplingsName);
        config.addTorches = tag.func_74767_n(addTorchesName);
        config.versionMessage = tag.func_74779_i(versionMessageName);
        config.showMessage = tag.func_74767_n(showMessageName);
        for (Map.Entry<String, Tuple2<Boolean, ArrayList<IRecipe>>> set : ModRegistry.SavedRecipes.entrySet()) {
            if (!tag.func_74764_b(set.getKey())) continue;
            boolean value = tag.func_74767_n(set.getKey());
            set.setValue((Tuple2<Boolean, ArrayList<IRecipe>>)new Tuple2((Object)value, set.getValue()._2));
        }
        return config;
    }

    public static enum WallBlockType {
        Oak(0, "prefab.wall.block.type.oak"),
        Spruce(1, "prefab.wall.block.type.spruce"),
        Birch(2, "prefab.wall.block.type.birch"),
        Jungle(3, "prefab.wall.block.type.jungle"),
        Acacia(4, "prefab.wall.block.type.acacia"),
        DarkOak(5, "prefab.wall.block.type.darkoak");

        private final int value;
        private final String langKey;

        private WallBlockType(int newValue, String langKey) {
            this.value = newValue;
            this.langKey = langKey;
        }

        public int getValue() {
            return this.value;
        }

        public String getName() {
            return GuiLangKeys.translateString(this.langKey);
        }

        public static WallBlockType ValueOf(int value) {
            switch (value) {
                case 1: {
                    return Spruce;
                }
                case 2: {
                    return Birch;
                }
                case 3: {
                    return Jungle;
                }
                case 4: {
                    return Acacia;
                }
                case 5: {
                    return DarkOak;
                }
            }
            return Oak;
        }
    }

    public static enum CeilingFloorBlockType {
        StoneBrick(0, "prefab.ceiling.block.type.stone"),
        Brick(1, "prefab.ceiling.block.type.brick"),
        SandStone(2, "prefab.ceiling.block.type.sand");

        private final int value;
        private final String langKey;

        private CeilingFloorBlockType(int newValue, String langKey) {
            this.value = newValue;
            this.langKey = langKey;
        }

        public int getValue() {
            return this.value;
        }

        public String getName() {
            return GuiLangKeys.translateString(this.langKey);
        }

        public static CeilingFloorBlockType ValueOf(int value) {
            switch (value) {
                case 1: {
                    return Brick;
                }
                case 2: {
                    return SandStone;
                }
            }
            return StoneBrick;
        }
    }
}

