/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.Config.Structures;

import com.wuest.prefab.Config.Structures.StructureConfiguration;
import com.wuest.prefab.Gui.GuiLangKeys;
import com.wuest.prefab.ModRegistry;
import com.wuest.prefab.StructureGen.CustomStructures.StructureModerateHouse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ModerateHouseConfiguration
extends StructureConfiguration {
    public static String tagKey = "houseConfig";
    private static String houseStyleTag = "houseStyle";
    private static String addChestTag = "addChests";
    private static String addChestContentsTag = "addChestContents";
    private static String addMineshaftTag = "addMineshaft";
    public HouseStyle houseStyle = HouseStyle.SPRUCE_HOME;
    public boolean addChests = true;
    public boolean addChestContents = true;
    public boolean addMineshaft = true;

    @Override
    public void Initialize() {
        super.Initialize();
        this.houseStyle = HouseStyle.SPRUCE_HOME;
    }

    @Override
    protected NBTTagCompound CustomWriteToNBTTagCompound(NBTTagCompound tag) {
        tag.func_74768_a(houseStyleTag, this.houseStyle.value);
        tag.func_74757_a(addChestTag, this.addChests);
        tag.func_74757_a(addChestContentsTag, this.addChestContents);
        tag.func_74757_a(addMineshaftTag, this.addMineshaft);
        return tag;
    }

    @Override
    protected void CustomReadFromNBTTag(NBTTagCompound messageTag, StructureConfiguration config) {
        ModerateHouseConfiguration houseConfiguration = (ModerateHouseConfiguration)config;
        if (messageTag.func_74764_b(houseStyleTag)) {
            houseConfiguration.houseStyle = HouseStyle.ValueOf(messageTag.func_74762_e(houseStyleTag));
        }
        if (messageTag.func_74764_b(addChestTag)) {
            houseConfiguration.addChests = messageTag.func_74767_n(addChestTag);
        }
        if (messageTag.func_74764_b(addChestContentsTag)) {
            houseConfiguration.addChestContents = messageTag.func_74767_n(addChestContentsTag);
        }
        if (messageTag.func_74764_b(addMineshaftTag)) {
            houseConfiguration.addMineshaft = messageTag.func_74767_n(addMineshaftTag);
        }
    }

    @Override
    public ModerateHouseConfiguration ReadFromNBTTagCompound(NBTTagCompound messageTag) {
        ModerateHouseConfiguration config = new ModerateHouseConfiguration();
        return (ModerateHouseConfiguration)super.ReadFromNBTTagCompound(messageTag, config);
    }

    @Override
    protected void ConfigurationSpecificBuildStructure(EntityPlayer player, World world, BlockPos hitBlockPos) {
        StructureModerateHouse structure = (StructureModerateHouse)StructureModerateHouse.CreateInstance(this.houseStyle.getStructureLocation(), StructureModerateHouse.class);
        if (structure.BuildStructure(this, world, hitBlockPos, EnumFacing.NORTH, player)) {
            player.field_71071_by.func_174925_a((Item)ModRegistry.ModerateHouse(), -1, 1, null);
            player.field_71069_bz.func_75142_b();
        }
    }

    public static enum HouseStyle {
        SPRUCE_HOME(0, "prefab.gui.moderate_house.spruce", new ResourceLocation("prefab", "textures/gui/moderate_house_spruce_topdown.png"), 176, 154, "assets/prefab/structures/moderate_house_spruce.zip", 31, 31, 23, 8, 1),
        ACACIA_HOME(1, "prefab.gui.moderate_house.acacia", new ResourceLocation("prefab", "textures/gui/moderate_house_acacia_topdown.png"), 176, 154, "assets/prefab/structures/moderate_house_acacia.zip", 31, 31, 21, 12, 6);

        private final int value;
        private final String displayName;
        private final ResourceLocation housePicture;
        private final int imageWidth;
        private final int imageHeight;
        private final String structureLocation;
        private final int width;
        private final int length;
        private final int height;
        private final int eastOffSet;
        private final int downOffSet;

        private HouseStyle(int newValue, String displayName, ResourceLocation housePicture, int imageWidth, int imageHeight, String structureLocation, int width, int length, int height, int eastOffSet, int downOffSet) {
            this.value = newValue;
            this.displayName = displayName;
            this.housePicture = housePicture;
            this.imageWidth = imageWidth;
            this.imageHeight = imageHeight;
            this.structureLocation = structureLocation;
            this.width = width;
            this.length = length;
            this.height = height;
            this.eastOffSet = eastOffSet;
            this.downOffSet = downOffSet;
        }

        public int getValue() {
            return this.value;
        }

        public String getDisplayName() {
            return GuiLangKeys.translateString(this.displayName);
        }

        public ResourceLocation getHousePicture() {
            return this.housePicture;
        }

        public int getImageWidth() {
            return this.imageWidth;
        }

        public int getImageHeight() {
            return this.imageHeight;
        }

        public int getWidth() {
            return this.width;
        }

        public int getLength() {
            return this.length;
        }

        public int getHeight() {
            return this.height;
        }

        public int getEastOffSet() {
            return this.eastOffSet;
        }

        public int getDownOffSet() {
            return this.downOffSet;
        }

        public String getStructureLocation() {
            return this.structureLocation;
        }

        public static HouseStyle ValueOf(int value) {
            switch (value) {
                case 0: {
                    return SPRUCE_HOME;
                }
                case 1: {
                    return ACACIA_HOME;
                }
            }
            return SPRUCE_HOME;
        }
    }
}

