/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.Config.Structures;

import com.wuest.prefab.Config.Structures.StructureConfiguration;
import com.wuest.prefab.Gui.GuiLangKeys;
import com.wuest.prefab.Items.Structures.ItemVillagerHouses;
import com.wuest.prefab.StructureGen.CustomStructures.StructureVillagerHouses;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class VillagerHouseConfiguration
extends StructureConfiguration {
    public static String tagKey = "villagerHouseConfig";
    private static String houseStyleTag = "houseStyle";
    public HouseStyle houseStyle;

    @Override
    public void Initialize() {
        super.Initialize();
        this.houseStyle = HouseStyle.FLAT_ROOF;
    }

    @Override
    protected NBTTagCompound CustomWriteToNBTTagCompound(NBTTagCompound tag) {
        tag.func_74768_a(houseStyleTag, this.houseStyle.value);
        return tag;
    }

    @Override
    protected void CustomReadFromNBTTag(NBTTagCompound messageTag, StructureConfiguration config) {
        if (messageTag.func_74764_b(houseStyleTag)) {
            ((VillagerHouseConfiguration)config).houseStyle = HouseStyle.ValueOf(messageTag.func_74762_e(houseStyleTag));
        }
    }

    @Override
    public VillagerHouseConfiguration ReadFromNBTTagCompound(NBTTagCompound messageTag) {
        VillagerHouseConfiguration config = new VillagerHouseConfiguration();
        return (VillagerHouseConfiguration)super.ReadFromNBTTagCompound(messageTag, config);
    }

    @Override
    protected void ConfigurationSpecificBuildStructure(EntityPlayer player, World world, BlockPos hitBlockPos) {
        StructureVillagerHouses structure = (StructureVillagerHouses)StructureVillagerHouses.CreateInstance(this.houseStyle.getStructureLocation(), StructureVillagerHouses.class);
        if (structure.BuildStructure(this, world, hitBlockPos, EnumFacing.NORTH, player)) {
            ItemStack stack = player.func_184614_ca().func_77973_b() instanceof ItemVillagerHouses ? player.func_184614_ca() : player.func_184592_cb();
            stack.func_77972_a(1, (EntityLivingBase)player);
            player.field_71069_bz.func_75142_b();
        }
    }

    public static enum HouseStyle {
        FLAT_ROOF(0, "prefab.gui.villager.house.flat", new ResourceLocation("prefab", "textures/gui/village_house_flat.png"), 165, 128, "assets/prefab/structures/villager_house_flat.zip", 5, 6, 5, 2),
        ANGLED_ROOF(1, "prefab.gui.villager.house.angled", new ResourceLocation("prefab", "textures/gui/village_house_angled.png"), 161, 155, "assets/prefab/structures/villager_house_angled.zip", 5, 6, 6, 2),
        FENCED_ROOF(2, "prefab.gui.villager.house.fenced", new ResourceLocation("prefab", "textures/gui/village_house_fenced.png"), 159, 156, "assets/prefab/structures/villager_house_fenced.zip", 5, 6, 6, 2),
        BLACKSMITH(3, "prefab.gui.villager.blacksmith", new ResourceLocation("prefab", "textures/gui/village_house_blacksmith.png"), 157, 73, "assets/prefab/structures/villager_house_blacksmith.zip", 8, 6, 6, 4),
        LONG_HOUSE(4, "prefab.gui.villager.long_house", new ResourceLocation("prefab", "textures/gui/village_house_long.png"), 157, 114, "assets/prefab/structures/villager_house_long.zip", 9, 7, 7, 4);

        private final int value;
        private final String displayName;
        private final ResourceLocation housePicture;
        private final int imageWidth;
        private final int imageHeight;
        private final String structureLocation;
        private final int width;
        private final int length;
        private final int height;
        private final int eastOffSet;

        private HouseStyle(int newValue, String displayName, ResourceLocation housePicture, int imageWidth, int imageHeight, String structureLocation, int width, int length, int height, int eastOffSet) {
            this.value = newValue;
            this.displayName = displayName;
            this.housePicture = housePicture;
            this.imageWidth = imageWidth;
            this.imageHeight = imageHeight;
            this.structureLocation = structureLocation;
            this.width = width;
            this.length = length;
            this.height = height;
            this.eastOffSet = eastOffSet;
        }

        public int getValue() {
            return this.value;
        }

        public String getDisplayName() {
            return GuiLangKeys.translateString(this.displayName);
        }

        public ResourceLocation getHousePicture() {
            return this.housePicture;
        }

        public int getImageWidth() {
            return this.imageWidth;
        }

        public int getImageHeight() {
            return this.imageHeight;
        }

        public int getWidth() {
            return this.width;
        }

        public int getLength() {
            return this.length;
        }

        public int getHeight() {
            return this.height;
        }

        public int getEastOffSet() {
            return this.eastOffSet;
        }

        public String getStructureLocation() {
            return this.structureLocation;
        }

        public static HouseStyle ValueOf(int value) {
            switch (value) {
                case 0: {
                    return FLAT_ROOF;
                }
                case 1: {
                    return ANGLED_ROOF;
                }
                case 2: {
                    return FENCED_ROOF;
                }
                case 3: {
                    return BLACKSMITH;
                }
                case 4: {
                    return LONG_HOUSE;
                }
            }
            return FLAT_ROOF;
        }
    }
}

