/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.Gui.Structures;

import com.wuest.prefab.Config.Structures.VillagerHouseConfiguration;
import com.wuest.prefab.Events.ClientEventHandler;
import com.wuest.prefab.Gui.GuiLangKeys;
import com.wuest.prefab.Gui.GuiTabScreen;
import com.wuest.prefab.Gui.Structures.GuiStructure;
import com.wuest.prefab.Proxy.CommonProxy;
import com.wuest.prefab.Proxy.Messages.StructureTagMessage;
import com.wuest.prefab.Render.StructureRenderHandler;
import com.wuest.prefab.StructureGen.CustomStructures.StructureVillagerHouses;
import java.io.IOException;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.config.GuiButtonExt;

public class GuiVillaerHouses
extends GuiStructure {
    private static final ResourceLocation backgroundTextures = new ResourceLocation("prefab", "textures/gui/default_background.png");
    protected GuiButtonExt btnHouseStyle;
    protected VillagerHouseConfiguration configuration;
    protected VillagerHouseConfiguration.HouseStyle houseStyle;

    public GuiVillaerHouses(int x, int y, int z) {
        super(x, y, z, true);
        this.structureConfiguration = StructureTagMessage.EnumStructureConfiguration.VillagerHouses;
    }

    @Override
    public void Initialize() {
        this.configuration = ClientEventHandler.playerConfig.getClientConfig("Villager Houses", VillagerHouseConfiguration.class);
        this.configuration.pos = this.pos;
        this.configuration.houseFacing = EnumFacing.NORTH;
        this.houseStyle = this.configuration.houseStyle;
        int grayBoxX = this.getCenteredXAxis() - 205;
        int grayBoxY = this.getCenteredYAxis() - 83;
        this.btnHouseStyle = new GuiButtonExt(4, grayBoxX + 10, grayBoxY + 20, 90, 20, this.houseStyle.getDisplayName());
        this.field_146292_n.add(this.btnHouseStyle);
        this.btnHouseFacing = new GuiButtonExt(3, grayBoxX + 10, grayBoxY + 60, 90, 20, GuiLangKeys.translateFacing(this.configuration.houseFacing));
        this.field_146292_n.add(this.btnHouseFacing);
        this.btnVisualize = new GuiButtonExt(4, grayBoxX + 10, grayBoxY + 90, 90, 20, GuiLangKeys.translateString("prefab.gui.button.preview"));
        this.field_146292_n.add(this.btnVisualize);
        this.btnBuild = new GuiButtonExt(1, grayBoxX + 10, grayBoxY + 136, 90, 20, GuiLangKeys.translateString("prefab.gui.button.build"));
        this.field_146292_n.add(this.btnBuild);
        this.btnCancel = new GuiButtonExt(2, grayBoxX + 147, grayBoxY + 136, 90, 20, GuiLangKeys.translateString("prefab.gui.button.cancel"));
        this.field_146292_n.add(this.btnCancel);
    }

    public void func_73863_a(int x, int y, float f) {
        int grayBoxX = this.getCenteredXAxis() - 205;
        int grayBoxY = this.getCenteredYAxis() - 83;
        this.func_146276_q_();
        this.field_146297_k.func_110434_K().func_110577_a(this.houseStyle.getHousePicture());
        GuiTabScreen.drawModalRectWithCustomSizedTexture(grayBoxX + 250, grayBoxY, 1, this.houseStyle.getImageWidth(), this.houseStyle.getImageHeight(), this.houseStyle.getImageWidth(), this.houseStyle.getImageHeight());
        this.drawControlBackgroundAndButtonsAndLabels(grayBoxX, grayBoxY, x, y);
        this.field_146297_k.field_71466_p.func_78276_b(GuiLangKeys.translateString("prefab.gui.starter.style.label"), grayBoxX + 10, grayBoxY + 10, this.textColor);
        this.field_146297_k.field_71466_p.func_78276_b(GuiLangKeys.translateString("prefab.gui.structure.facing"), grayBoxX + 10, grayBoxY + 50, this.textColor);
        if (!CommonProxy.proxyConfiguration.enableStructurePreview) {
            this.btnVisualize.field_146124_l = false;
        }
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        this.configuration.houseStyle = this.houseStyle;
        this.performCancelOrBuildOrHouseFacing(this.configuration, button);
        if (button == this.btnHouseStyle) {
            int id = this.houseStyle.getValue() + 1;
            this.houseStyle = VillagerHouseConfiguration.HouseStyle.ValueOf(id);
            this.btnHouseStyle.field_146126_j = this.houseStyle.getDisplayName();
        } else if (button == this.btnVisualize) {
            StructureVillagerHouses structure = (StructureVillagerHouses)StructureVillagerHouses.CreateInstance(this.houseStyle.getStructureLocation(), StructureVillagerHouses.class);
            StructureRenderHandler.setStructure(structure, EnumFacing.NORTH, this.configuration);
            this.field_146297_k.func_147108_a(null);
        }
    }
}

