/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.Items.Structures;

import com.wuest.prefab.Capabilities.IStructureConfigurationCapability;
import com.wuest.prefab.Capabilities.Storage.StructureConfigurationStorage;
import com.wuest.prefab.Capabilities.StructureConfigurationCapability;
import com.wuest.prefab.Config.Structures.BasicStructureConfiguration;
import com.wuest.prefab.Items.Structures.StructureItem;
import com.wuest.prefab.ModRegistry;
import com.wuest.prefab.Prefab;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBasicStructure
extends StructureItem {
    public ItemBasicStructure(String name) {
        super(name, 13);
        this.func_77627_a(true);
    }

    @Override
    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos hitBlockPos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K && side == EnumFacing.UP) {
            player.openGui((Object)Prefab.instance, this.guiId, player.field_70170_p, hitBlockPos.func_177958_n(), hitBlockPos.func_177956_o(), hitBlockPos.func_177952_p());
            return EnumActionResult.PASS;
        }
        return EnumActionResult.FAIL;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item itemIn, CreativeTabs tab, NonNullList<ItemStack> subItems) {
        for (BasicStructureConfiguration.EnumBasicStructureName value : BasicStructureConfiguration.EnumBasicStructureName.values()) {
            if (value.getResourceLocation() == null) continue;
            ItemStack stack = new ItemStack(itemIn);
            IStructureConfigurationCapability capability = (IStructureConfigurationCapability)stack.getCapability(ModRegistry.StructureConfiguration, EnumFacing.NORTH);
            capability.getConfiguration().basicStructureName = value;
            subItems.add((Object)stack);
        }
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (entityIn instanceof EntityPlayer) {
            ItemBasicStructure.getStackCapability(stack);
        }
    }

    public String func_77667_c(ItemStack stack) {
        IStructureConfigurationCapability capability = ItemBasicStructure.getStackCapability(stack);
        if (capability != null) {
            return capability.getConfiguration().getDisplayName();
        }
        return this.func_77658_a();
    }

    public String func_77653_i(ItemStack stack) {
        return ("" + I18n.func_74838_a((String)this.func_77657_g(stack))).trim();
    }

    public int getMetadata(ItemStack stack) {
        if (stack.func_77978_p() == null || stack.func_77978_p().func_82582_d()) {
            stack.func_77982_d(stack.serializeNBT());
        }
        return 0;
    }

    public NBTTagCompound getNBTShareTag(ItemStack stack) {
        if (stack.func_77978_p() == null || stack.func_77978_p().func_82582_d()) {
            stack.func_77982_d(stack.serializeNBT());
        }
        return stack.func_77978_p();
    }

    public static ItemStack getBasicStructureItemInHand(EntityPlayer player) {
        Object stack = player.func_184592_cb();
        if (stack == null || !(stack.func_77973_b() instanceof ItemBasicStructure)) {
            stack = player.func_184614_ca() != null && player.func_184614_ca().func_77973_b() instanceof ItemBasicStructure ? player.func_184614_ca() : null;
        }
        return stack;
    }

    public static IStructureConfigurationCapability getStackCapability(ItemStack stack) {
        if (stack.hasCapability(ModRegistry.StructureConfiguration, EnumFacing.NORTH)) {
            NBTTagCompound forgeCapabilities = stack.func_179543_a("ForgeCaps");
            IStructureConfigurationCapability stackCapability = (IStructureConfigurationCapability)stack.getCapability(ModRegistry.StructureConfiguration, EnumFacing.NORTH);
            if (forgeCapabilities != null && stackCapability.getDirty() && forgeCapabilities.func_74764_b("prefab:structuresconfiguration")) {
                StructureConfigurationCapability capabilityTemp = new StructureConfigurationCapability();
                StructureConfigurationStorage storage = new StructureConfigurationStorage();
                storage.readNBT(ModRegistry.StructureConfiguration, capabilityTemp, EnumFacing.NORTH, (NBTBase)forgeCapabilities.func_74775_l("prefab:structuresconfiguration"));
                if (!capabilityTemp.getConfiguration().basicStructureName.getName().equals(stackCapability.getConfiguration().basicStructureName.getName())) {
                    stackCapability.setConfiguration(capabilityTemp.getConfiguration());
                    stackCapability.setDirty(false);
                }
            }
            return stackCapability;
        }
        return null;
    }
}

