/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.Proxy.Messages;

import com.wuest.prefab.Config.Structures.BasicStructureConfiguration;
import com.wuest.prefab.Config.Structures.ChickenCoopConfiguration;
import com.wuest.prefab.Config.Structures.FishPondConfiguration;
import com.wuest.prefab.Config.Structures.HorseStableConfiguration;
import com.wuest.prefab.Config.Structures.HouseConfiguration;
import com.wuest.prefab.Config.Structures.ModerateHouseConfiguration;
import com.wuest.prefab.Config.Structures.ModularHouseConfiguration;
import com.wuest.prefab.Config.Structures.MonsterMasherConfiguration;
import com.wuest.prefab.Config.Structures.NetherGateConfiguration;
import com.wuest.prefab.Config.Structures.ProduceFarmConfiguration;
import com.wuest.prefab.Config.Structures.StructureConfiguration;
import com.wuest.prefab.Config.Structures.TreeFarmConfiguration;
import com.wuest.prefab.Config.Structures.VillagerHouseConfiguration;
import com.wuest.prefab.Config.Structures.WareHouseConfiguration;
import com.wuest.prefab.Proxy.Messages.TagMessage;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class StructureTagMessage
extends TagMessage {
    protected EnumStructureConfiguration structureConfig;

    public StructureTagMessage() {
    }

    public StructureTagMessage(NBTTagCompound tagMessage, EnumStructureConfiguration structureConfig) {
        super(tagMessage);
        this.structureConfig = structureConfig;
    }

    public EnumStructureConfiguration getStructureConfig() {
        return this.structureConfig;
    }

    public void setStructureConfig(EnumStructureConfiguration value) {
        this.structureConfig = value;
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        NBTTagCompound tag = ByteBufUtils.readTag((ByteBuf)buf);
        this.structureConfig = EnumStructureConfiguration.getFromIdentifier(tag.func_74762_e("config"));
        this.tagMessage = tag.func_74775_l("dataTag");
    }

    @Override
    public void toBytes(ByteBuf buf) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("config", this.structureConfig.identifier);
        tag.func_74782_a("dataTag", (NBTBase)this.tagMessage);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tag);
    }

    public static enum EnumStructureConfiguration {
        Basic(0, new BasicStructureConfiguration()),
        ChickenCoop(1, new ChickenCoopConfiguration()),
        AdvancedWareHouse(2, new WareHouseConfiguration()),
        FishPond(3, new FishPondConfiguration()),
        HorseStable(4, new HorseStableConfiguration()),
        ModularHouse(5, new ModularHouseConfiguration()),
        MonsterMasher(6, new MonsterMasherConfiguration()),
        NetherGate(7, new NetherGateConfiguration()),
        ProduceFarm(8, new ProduceFarmConfiguration()),
        StartHouse(9, new HouseConfiguration()),
        TreeFarm(10, new TreeFarmConfiguration()),
        VillagerHouses(11, new VillagerHouseConfiguration()),
        WareHouse(12, new WareHouseConfiguration()),
        ModerateHouse(13, new ModerateHouseConfiguration());

        public int identifier;
        public StructureConfiguration structureConfig;

        private <T extends StructureConfiguration> EnumStructureConfiguration(int identifier, T structureConfig) {
            this.identifier = identifier;
            this.structureConfig = structureConfig;
        }

        public static EnumStructureConfiguration getFromIdentifier(int identifier) {
            for (EnumStructureConfiguration config : EnumStructureConfiguration.values()) {
                if (config.identifier != identifier) continue;
                return config;
            }
            return Basic;
        }
    }
}

