/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.events.entities;

import insane96mcp.progressivebosses.events.entities.ai.DragonMinionAttackGoal;
import insane96mcp.progressivebosses.events.entities.ai.DragonMinionAttackNearestGoal;
import insane96mcp.progressivebosses.setup.ModConfig;
import insane96mcp.progressivebosses.utils.MathRandom;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.boss.dragon.phase.ChargingPlayerPhase;
import net.minecraft.entity.boss.dragon.phase.PhaseType;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.monster.EndermiteEntity;
import net.minecraft.entity.monster.ShulkerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.storage.loot.LootTables;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class Dragon {
    public static void setStats(EntityJoinWorldEvent event) {
        if (event.getWorld().func_201675_m().func_186058_p() != DimensionType.field_223229_c_) {
            return;
        }
        if (!(event.getEntity() instanceof EnderDragonEntity)) {
            return;
        }
        EnderDragonEntity dragon = (EnderDragonEntity)event.getEntity();
        CompoundNBT tags = dragon.getPersistentData();
        boolean alreadyProcessed = tags.func_74767_n("progressivebosses:processed");
        if (alreadyProcessed) {
            return;
        }
        tags.func_74757_a("progressivebosses:processed", true);
        int radius = 160;
        BlockPos pos1 = new BlockPos(-radius, -radius, -radius);
        BlockPos pos2 = new BlockPos(radius, radius, radius);
        AxisAlignedBB bb = new AxisAlignedBB(pos1, pos2);
        List players = event.getWorld().func_217357_a(ServerPlayerEntity.class, bb);
        if (players.size() == 0) {
            return;
        }
        int eggsToDrop = 0;
        float killedCount = 0.0f;
        for (ServerPlayerEntity player : players) {
            CompoundNBT playerTags = player.getPersistentData();
            int c = playerTags.func_74762_e("progressivebosses:killed_dragons");
            if (c == 0) {
                dragon.func_184664_cU().field_186118_l = false;
                ++eggsToDrop;
            }
            killedCount += (float)c;
        }
        tags.func_74768_a("progressivebosses:eggs_to_drop", eggsToDrop);
        if (killedCount == 0.0f) {
            return;
        }
        if (!((Boolean)ModConfig.Dragon.General.sumKilledDragonsDifficulty.get()).booleanValue() && killedCount > 0.0f) {
            killedCount /= (float)players.size();
        }
        Dragon.setHealth(dragon, killedCount);
        tags.func_74776_a("progressivebosses:difficulty", killedCount);
    }

    private static void setHealth(EnderDragonEntity dragon, float killedCount) {
        IAttributeInstance attribute = dragon.func_110148_a(SharedMonsterAttributes.field_111267_a);
        attribute.func_111128_a(attribute.func_111125_b() + (double)killedCount * (Double)ModConfig.Dragon.Health.bonusPerDifficulty.get());
        dragon.func_70606_j((float)attribute.func_111125_b());
    }

    private static void dropMoreExperience(EnderDragonEntity dragon, World world) {
        if (dragon.field_70995_bG != 150) {
            return;
        }
        CompoundNBT tags = dragon.getPersistentData();
        int radius = 160;
        BlockPos pos1 = new BlockPos(-radius, -radius, -radius);
        BlockPos pos2 = new BlockPos(radius, radius, radius);
        AxisAlignedBB bb = new AxisAlignedBB(pos1, pos2);
        List players = world.func_217357_a(ServerPlayerEntity.class, bb);
        int playersAround = players.size();
        int playersFirstTime = tags.func_74762_e("progressivebosses:eggs_to_drop");
        boolean previouslyKilledDragon = false;
        if (dragon.func_184664_cU() != null) {
            previouslyKilledDragon = dragon.func_184664_cU().func_186102_d();
        }
        float difficulty = tags.func_74760_g("progressivebosses:difficulty");
        int xp = 0;
        if (!previouslyKilledDragon) {
            --playersFirstTime;
            if (playersAround > 1) {
                xp += 12000 * playersFirstTime;
            }
            if (playersAround > 1) {
                xp = (int)((double)xp + 500.0 * (((Double)ModConfig.Dragon.Rewards.bonusExperience.get() + 1.0) * (double)difficulty / 100.0) * (double)(playersAround - playersFirstTime));
            }
        } else {
            xp += (int)(500.0 * ((Double)ModConfig.Dragon.Rewards.bonusExperience.get() * (double)difficulty / 100.0));
            if (playersAround > 1) {
                xp = (int)((double)xp + 500.0 * (((Double)ModConfig.Dragon.Rewards.bonusExperience.get() + 1.0) * (double)difficulty / 100.0) * (double)(playersAround - 1));
            }
        }
        while (xp > 0) {
            int i = ExperienceOrbEntity.func_70527_a((int)xp);
            xp -= i;
            world.func_217376_c((Entity)new ExperienceOrbEntity(dragon.field_70170_p, dragon.field_70165_t, dragon.field_70163_u, dragon.field_70161_v, i));
        }
    }

    public static void onDeath(LivingDeathEvent event) {
        if (!(event.getEntity() instanceof EnderDragonEntity)) {
            return;
        }
        EnderDragonEntity dragon = (EnderDragonEntity)event.getEntity();
        CompoundNBT tags = dragon.getPersistentData();
        if (tags.func_74767_n("progressivebosses:has_been_killed")) {
            return;
        }
        tags.func_74757_a("progressivebosses:has_been_killed", true);
        int radius = 160;
        BlockPos pos1 = new BlockPos(-radius, -radius, -radius);
        BlockPos pos2 = new BlockPos(radius, radius, radius);
        AxisAlignedBB bb = new AxisAlignedBB(pos1, pos2);
        List players = dragon.field_70170_p.func_217357_a(ServerPlayerEntity.class, bb);
        if (players.size() == 0) {
            return;
        }
        for (ServerPlayerEntity player : players) {
            CompoundNBT playerTags = player.getPersistentData();
            int c = playerTags.func_74762_e("progressivebosses:killed_dragons");
            if (c >= (Integer)ModConfig.Dragon.General.maxDifficulty.get()) continue;
            playerTags.func_74768_a("progressivebosses:killed_dragons", c + 1);
        }
    }

    public static void onPlayerDamage(LivingHurtEvent event) {
        if (!(event.getSource().func_76364_f() instanceof EnderDragonEntity)) {
            return;
        }
        EnderDragonEntity dragon = (EnderDragonEntity)event.getSource().func_76364_f();
        CompoundNBT tags = dragon.getPersistentData();
        float difficulty = tags.func_74760_g("progressivebosses:difficulty");
        if (difficulty == 0.0f) {
            return;
        }
        event.setAmount((float)((double)event.getAmount() * (1.0 + (double)difficulty * ((Double)ModConfig.Dragon.Attack.bonusAttackDamage.get() / 100.0))));
    }

    private static void dropEgg(EnderDragonEntity dragon, World world) {
        if (dragon.field_70995_bG != 100) {
            return;
        }
        CompoundNBT tags = dragon.getPersistentData();
        int eggsToDrop = tags.func_74762_e("progressivebosses:eggs_to_drop");
        if (dragon.func_184664_cU() != null && !dragon.func_184664_cU().func_186102_d()) {
            --eggsToDrop;
        }
        for (int i = 0; i < eggsToDrop; ++i) {
            world.func_175656_a(new BlockPos(0, 255 - i, 0), Blocks.field_150380_bt.func_176223_P());
        }
    }

    public static void update(LivingEvent.LivingUpdateEvent event) {
        if (!(event.getEntity() instanceof EnderDragonEntity)) {
            return;
        }
        World world = event.getEntity().field_70170_p;
        EnderDragonEntity dragon = (EnderDragonEntity)event.getEntity();
        CompoundNBT tags = dragon.getPersistentData();
        Dragon.chargePlayer(dragon);
        Dragon.spawnEndermites(dragon, world);
        Dragon.spawnShulkers(dragon, world);
        Dragon.heal(dragon, tags);
        Dragon.dropEgg(dragon, world);
        Dragon.dropMoreExperience(dragon, world);
    }

    private static void chargePlayer(EnderDragonEntity dragon) {
        CompoundNBT tags = dragon.getPersistentData();
        float difficulty = tags.func_74760_g("progressivebosses:difficulty");
        double chance = (Double)ModConfig.Dragon.Attack.chargePlayerBaseChance.get() / 100.0 / 24.0;
        chance *= (double)difficulty;
        int crystalsAlive = dragon.func_184664_cU().func_186092_c() + 1;
        chance *= (double)(1.0f / (float)crystalsAlive);
        if (Math.random() < chance && dragon.func_184670_cT().func_188756_a().func_188652_i() == PhaseType.field_188741_a) {
            AxisAlignedBB axisAlignedBB = new AxisAlignedBB(-128.0, -128.0, -128.0, 128.0, 128.0, 128.0);
            ServerPlayerEntity player = (ServerPlayerEntity)dragon.field_70170_p.func_217360_a(ServerPlayerEntity.class, new EntityPredicate().func_221013_a(128.0), (LivingEntity)dragon, dragon.field_70165_t, dragon.field_70163_u + (double)dragon.func_70047_e(), dragon.field_70161_v, axisAlignedBB);
            if (player != null) {
                dragon.func_184670_cT().func_188758_a(PhaseType.field_188749_i);
                ((ChargingPlayerPhase)dragon.func_184670_cT().func_188757_b(PhaseType.field_188749_i)).func_188668_a(new Vec3d(player.field_70165_t, player.field_70163_u, player.field_70161_v));
            }
        }
    }

    private static void heal(EnderDragonEntity dragon, CompoundNBT tags) {
        if ((Double)ModConfig.Dragon.Health.maximumBonusRegen.get() == 0.0) {
            return;
        }
        if (dragon.field_70173_aa % 20 != 0) {
            return;
        }
        float difficulty = tags.func_74760_g("progressivebosses:difficulty");
        if (difficulty == 0.0f) {
            return;
        }
        double maxHeal = (Double)ModConfig.Dragon.Health.maximumBonusRegen.get();
        double heal = (double)difficulty * (Double)ModConfig.Dragon.Health.bonusRegenPerSpawned.get();
        if (heal > maxHeal) {
            heal = maxHeal;
        }
        float health = dragon.func_110143_aJ();
        if (dragon.func_110143_aJ() < dragon.func_110138_aP() && dragon.func_110143_aJ() > 0.0f) {
            dragon.func_70606_j((float)((double)health + heal));
        }
    }

    private static void spawnEndermites(EnderDragonEntity dragon, World world) {
        if ((Integer)ModConfig.Dragon.Larvae.maxSpawned.get() == 0) {
            return;
        }
        CompoundNBT tags = dragon.getPersistentData();
        tags.func_74757_a("mobspropertiesrandomness:checked", true);
        float difficulty = tags.func_74760_g("progressivebosses:difficulty");
        if (difficulty < (float)((Integer)ModConfig.Dragon.Larvae.difficultyToSpawnOneMore.get()).intValue()) {
            return;
        }
        int cooldown = tags.func_74762_e("progressivebosses:endermites_cooldown");
        if (cooldown > 0) {
            tags.func_74768_a("progressivebosses:endermites_cooldown", cooldown - 1);
        } else {
            int cooldownReduction = (int)(difficulty * (float)((Integer)ModConfig.Dragon.Larvae.cooldownReduction.get()).intValue());
            cooldown = MathRandom.getInt(world.field_73012_v, (Integer)ModConfig.Dragon.Larvae.minCooldown.get() - cooldownReduction, (Integer)ModConfig.Dragon.Larvae.maxCooldown.get() - cooldownReduction);
            tags.func_74768_a("progressivebosses:endermites_cooldown", cooldown);
            int i = 1;
            while ((float)i <= difficulty && i / (Integer)ModConfig.Dragon.Larvae.difficultyToSpawnOneMore.get() <= (Integer)ModConfig.Dragon.Larvae.maxSpawned.get()) {
                if (i % (Integer)ModConfig.Dragon.Larvae.difficultyToSpawnOneMore.get() == 0) {
                    EndermiteEntity endermite = new EndermiteEntity(EntityType.field_200804_r, world);
                    CompoundNBT endermiteTags = endermite.getPersistentData();
                    endermiteTags.func_74777_a("scalinghealth:difficulty", (short)-1);
                    float angle = world.field_73012_v.nextFloat() * (float)Math.PI * 2.0f;
                    float x = (float)(Math.cos(angle) * (double)3.15f);
                    float z = (float)(Math.sin(angle) * (double)3.15f);
                    int y = world.func_205770_a(Heightmap.Type.MOTION_BLOCKING, new BlockPos((double)x, 255.0, (double)z)).func_177956_o();
                    IAttributeInstance attribute = endermite.func_110148_a(SharedMonsterAttributes.field_111263_d);
                    attribute.func_111128_a(attribute.func_111125_b() * 1.5);
                    attribute = endermite.func_110148_a(SharedMonsterAttributes.field_111265_b);
                    attribute.func_111128_a(96.0);
                    attribute = endermite.func_110148_a(SharedMonsterAttributes.field_111267_a);
                    attribute.func_111128_a(4.0);
                    endermite.func_70606_j((float)attribute.func_111125_b());
                    endermite.func_70107_b((double)x, (double)y, (double)z);
                    endermite.func_200203_b((ITextComponent)new TranslationTextComponent("dragon.larva", new Object[0]));
                    ArrayList toRemove = new ArrayList();
                    endermite.field_70715_bh.field_220892_d.forEach(goal -> {
                        if (goal.func_220772_j() instanceof NearestAttackableTargetGoal) {
                            toRemove.add(goal.func_220772_j());
                        }
                    });
                    for (Goal goal2 : toRemove) {
                        endermite.field_70715_bh.func_85156_a(goal2);
                    }
                    endermite.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)endermite, PlayerEntity.class, false));
                    endermite.field_70728_aV = 1;
                    world.func_217376_c((Entity)endermite);
                }
                ++i;
            }
        }
    }

    private static void spawnShulkers(EnderDragonEntity dragon, World world) {
        if ((Integer)ModConfig.Dragon.Minion.difficultyToSpawn.get() <= 0) {
            return;
        }
        CompoundNBT tags = dragon.getPersistentData();
        tags.func_74757_a("mpr:prevent_processing", true);
        float difficulty = tags.func_74760_g("progressivebosses:difficulty");
        if (difficulty < (float)((Integer)ModConfig.Dragon.Minion.difficultyToSpawn.get()).intValue()) {
            return;
        }
        int cooldown = tags.func_74762_e("progressivebosses:shulkers_cooldown");
        if (cooldown > 0) {
            tags.func_74768_a("progressivebosses:shulkers_cooldown", cooldown - 1);
        } else {
            int cooldownReduction = (int)(difficulty * (float)((Integer)ModConfig.Dragon.Minion.cooldownReduction.get()).intValue());
            cooldown = MathRandom.getInt(world.field_73012_v, (Integer)ModConfig.Dragon.Minion.minCooldown.get() - cooldownReduction, (Integer)ModConfig.Dragon.Minion.maxCooldown.get() - cooldownReduction);
            tags.func_74768_a("progressivebosses:shulkers_cooldown", cooldown);
            ShulkerEntity shulker = new ShulkerEntity(EntityType.field_200738_ad, world);
            CompoundNBT shulkerTags = shulker.getPersistentData();
            shulkerTags.func_74777_a("scalinghealth:difficulty", (short)-1);
            float angle = world.field_73012_v.nextFloat() * (float)Math.PI * 2.0f;
            float x = (float)(Math.cos(angle) * (double)MathRandom.getFloat(world.field_73012_v, 15.0f, 40.0f));
            float z = (float)(Math.sin(angle) * (double)MathRandom.getFloat(world.field_73012_v, 15.0f, 40.0f));
            float y = world.func_205770_a(Heightmap.Type.MOTION_BLOCKING, new BlockPos((double)x, 255.0, (double)z)).func_177956_o();
            IAttributeInstance followRange = shulker.func_110148_a(SharedMonsterAttributes.field_111265_b);
            followRange.func_111128_a(64.0);
            shulker.func_70107_b((double)x, (double)y, (double)z);
            CompoundNBT compound = shulker.serializeNBT();
            compound.func_74774_a("Color", (byte)15);
            shulker.deserializeNBT(compound);
            shulker.func_200203_b((ITextComponent)new TranslationTextComponent("dragon.minion", new Object[0]));
            ArrayList toRemove = new ArrayList();
            shulker.field_70714_bg.field_220892_d.forEach(goal -> {
                if (goal.func_220772_j() instanceof ShulkerEntity.AttackGoal) {
                    toRemove.add(goal.func_220772_j());
                }
            });
            for (Goal goal2 : toRemove) {
                shulker.field_70714_bg.func_85156_a(goal2);
            }
            toRemove.clear();
            shulker.field_70715_bh.field_220892_d.forEach(goal -> {
                if (goal.func_220772_j() instanceof NearestAttackableTargetGoal) {
                    toRemove.add(goal.func_220772_j());
                }
            });
            for (Goal goal2 : toRemove) {
                shulker.field_70714_bg.func_85156_a(goal2);
            }
            toRemove.clear();
            shulker.field_70714_bg.func_75776_a(1, (Goal)new DragonMinionAttackGoal(shulker));
            shulker.field_70715_bh.func_75776_a(2, (Goal)new DragonMinionAttackNearestGoal(shulker));
            shulker.field_184659_bA = LootTables.field_186419_a;
            shulker.field_70728_aV = 2;
            world.func_217376_c((Entity)shulker);
        }
    }
}

