/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import insane96mcp.progressivebosses.setup.ModConfig;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class DifficultyCommand {
    private DifficultyCommand() {
    }

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"progressivebosses").requires(source -> source.func_197034_c(2))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.func_197056_a((String)"targetPlayer", (ArgumentType)EntityArgument.func_197096_c()).then(Commands.func_197057_a((String)"get").executes(context -> DifficultyCommand.getBossDifficulty((CommandSource)context.getSource(), EntityArgument.func_197089_d((CommandContext)context, (String)"targetPlayer"))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"set").then(Commands.func_197057_a((String)"wither").then(Commands.func_197056_a((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)0, (int)((Integer)ModConfig.COMMON.wither.general.maxDifficulty.get()))).executes(context -> DifficultyCommand.setBossDifficulty((CommandSource)context.getSource(), EntityArgument.func_197089_d((CommandContext)context, (String)"targetPlayer"), "wither", IntegerArgumentType.getInteger((CommandContext)context, (String)"amount")))))).then(Commands.func_197057_a((String)"dragon").then(Commands.func_197056_a((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)0, (int)((Integer)ModConfig.COMMON.dragon.general.maxDifficulty.get()))).executes(context -> DifficultyCommand.setBossDifficulty((CommandSource)context.getSource(), EntityArgument.func_197089_d((CommandContext)context, (String)"targetPlayer"), "dragon", IntegerArgumentType.getInteger((CommandContext)context, (String)"amount"))))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"add").then(Commands.func_197057_a((String)"wither").then(Commands.func_197056_a((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)0, (int)((Integer)ModConfig.COMMON.wither.general.maxDifficulty.get()))).executes(context -> DifficultyCommand.addBossDifficulty((CommandSource)context.getSource(), EntityArgument.func_197089_d((CommandContext)context, (String)"targetPlayer"), "wither", IntegerArgumentType.getInteger((CommandContext)context, (String)"amount")))))).then(Commands.func_197057_a((String)"dragon").then(Commands.func_197056_a((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)0, (int)((Integer)ModConfig.COMMON.dragon.general.maxDifficulty.get()))).executes(context -> DifficultyCommand.addBossDifficulty((CommandSource)context.getSource(), EntityArgument.func_197089_d((CommandContext)context, (String)"targetPlayer"), "dragon", IntegerArgumentType.getInteger((CommandContext)context, (String)"amount"))))))));
    }

    private static int setBossDifficulty(CommandSource source, ServerPlayerEntity targetPlayer, String boss, int amount) {
        CompoundNBT targetNBT = targetPlayer.getPersistentData();
        if (boss.equals("wither")) {
            targetNBT.func_74768_a("progressivebosses:spawned_withers", amount);
        }
        if (boss.equals("dragon")) {
            targetNBT.func_74768_a("progressivebosses:killed_dragons", amount);
        }
        source.func_197030_a((ITextComponent)new TranslationTextComponent("command.set_player_boss_difficulty", new Object[]{targetPlayer.func_200200_C_(), boss, amount}), true);
        return amount;
    }

    private static int addBossDifficulty(CommandSource source, ServerPlayerEntity targetPlayer, String boss, int amount) {
        int difficulty;
        int currDifficulty;
        CompoundNBT targetNBT = targetPlayer.getPersistentData();
        if (boss.equals("wither")) {
            currDifficulty = targetNBT.func_74762_e("progressivebosses:spawned_withers");
            difficulty = currDifficulty + amount;
            difficulty = MathHelper.func_76125_a((int)difficulty, (int)0, (int)((Integer)ModConfig.COMMON.wither.general.maxDifficulty.get()));
            targetNBT.func_74768_a("progressivebosses:spawned_withers", difficulty);
        }
        if (boss.equals("dragon")) {
            currDifficulty = targetNBT.func_74762_e("progressivebosses:killed_dragons");
            difficulty = currDifficulty + amount;
            difficulty = MathHelper.func_76125_a((int)difficulty, (int)0, (int)((Integer)ModConfig.COMMON.dragon.general.maxDifficulty.get()));
            targetNBT.func_74768_a("progressivebosses:killed_dragons", difficulty);
        }
        source.func_197030_a((ITextComponent)new TranslationTextComponent("command.add_player_boss_difficulty", new Object[]{targetPlayer.func_200200_C_(), amount, boss}), true);
        return amount;
    }

    private static int getBossDifficulty(CommandSource source, ServerPlayerEntity targetPlayer) {
        CompoundNBT targetNBT = targetPlayer.getPersistentData();
        source.func_197030_a((ITextComponent)new TranslationTextComponent("command.get_player_boss_difficulty", new Object[]{targetPlayer.func_200200_C_(), targetNBT.func_74762_e("progressivebosses:spawned_withers"), targetNBT.func_74762_e("progressivebosses:killed_dragons")}), true);
        return 1;
    }
}

