/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.events.entities;

import insane96mcp.progressivebosses.events.entities.ai.WitherMinionHurtByTargetGoal;
import insane96mcp.progressivebosses.items.ModItems;
import insane96mcp.progressivebosses.setup.ModConfig;
import insane96mcp.progressivebosses.utils.MathRandom;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.FleeSunGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RestrictSunGoal;
import net.minecraft.entity.boss.WitherEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.WitherSkeletonEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootTables;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;

public class Wither {
    private static final Predicate<LivingEntity> NOT_UNDEAD = livingEntity -> livingEntity instanceof LivingEntity && livingEntity.func_70668_bt() != CreatureAttribute.field_223223_b_ && livingEntity.func_190631_cK();

    public static void setStats(EntityJoinWorldEvent event) {
        if (!(event.getEntity() instanceof WitherEntity)) {
            return;
        }
        WitherEntity wither = (WitherEntity)event.getEntity();
        CompoundNBT tags = wither.getPersistentData();
        boolean alreadyProcessed = tags.func_74767_n("progressivebosses:processed");
        if (alreadyProcessed) {
            return;
        }
        tags.func_74757_a("progressivebosses:processed", true);
        int radius = (Integer)ModConfig.COMMON.wither.general.spawnRadiusPlayerCheck.get();
        BlockPos pos1 = wither.func_233580_cy_().func_177982_a(-radius, -radius, -radius);
        BlockPos pos2 = wither.func_233580_cy_().func_177982_a(radius, radius, radius);
        AxisAlignedBB bb = new AxisAlignedBB(pos1, pos2);
        List players = event.getWorld().func_217357_a(ServerPlayerEntity.class, bb);
        if (players.size() == 0) {
            return;
        }
        float spawnedCount = 1.0f;
        for (ServerPlayerEntity player : players) {
            CompoundNBT playerTags = player.getPersistentData();
            int c = playerTags.func_74762_e("progressivebosses:spawned_withers");
            spawnedCount += (float)c;
            if (c >= (Integer)ModConfig.COMMON.wither.general.maxDifficulty.get()) continue;
            playerTags.func_74768_a("progressivebosses:spawned_withers", c + 1);
        }
        if (spawnedCount == 1.0f) {
            return;
        }
        if (!((Boolean)ModConfig.COMMON.wither.general.sumSpawnedWitherDifficulty.get()).booleanValue()) {
            spawnedCount /= (float)players.size();
        }
        Wither.setHealth(wither, spawnedCount);
        Wither.setArmor(wither, spawnedCount);
        Wither.setExperience(wither, spawnedCount);
        tags.func_74776_a("progressivebosses:difficulty", spawnedCount);
        int cooldown = MathRandom.getInt(wither.field_70170_p.field_73012_v, (Integer)ModConfig.COMMON.wither.minions.minCooldown.get(), (Integer)ModConfig.COMMON.wither.minions.maxCooldown.get());
        tags.func_74768_a("progressivebosses:skeletons_cooldown", cooldown);
    }

    private static void setExperience(WitherEntity wither, float difficulty) {
        int xp;
        wither.field_70728_aV = xp = 50 + (int)(50.0 * ((Double)ModConfig.COMMON.wither.rewards.bonusExperience.get() * (double)difficulty / 100.0));
    }

    private static void setHealth(WitherEntity wither, float spawnedCount) {
        ModifiableAttributeInstance health = wither.func_110148_a(Attributes.field_233818_a_);
        health.func_111128_a(health.func_111125_b() + (double)spawnedCount * (Double)ModConfig.COMMON.wither.health.bonusPerDifficulty.get());
        wither.func_70606_j(Math.max(1.0f, (float)health.func_111125_b() - 200.0f));
    }

    private static void setArmor(WitherEntity wither, float killedCount) {
        ModifiableAttributeInstance attribute = wither.func_110148_a(Attributes.field_233826_i_);
        double armor = (double)killedCount * (Double)ModConfig.COMMON.wither.armor.bonusPerDifficulty.get();
        if (armor > (Double)ModConfig.COMMON.wither.armor.maximum.get()) {
            armor = (Double)ModConfig.COMMON.wither.armor.maximum.get();
        }
        attribute.func_111128_a(armor);
    }

    public static void update(LivingEvent.LivingUpdateEvent event) {
        if (!(event.getEntity() instanceof WitherEntity)) {
            return;
        }
        World world = event.getEntity().field_70170_p;
        WitherEntity wither = (WitherEntity)event.getEntity();
        CompoundNBT tags = wither.getPersistentData();
        if (wither.func_110143_aJ() < 0.0f) {
            return;
        }
        if (wither.func_82212_n() > 0) {
            wither.field_184744_bE.func_186735_a(wither.func_110143_aJ() / wither.func_110138_aP());
        } else {
            Wither.spawnSkeletons(wither, world);
            Wither.heal(wither, tags);
        }
    }

    private static void heal(WitherEntity wither, CompoundNBT tags) {
        if ((Double)ModConfig.COMMON.wither.health.maximumBonusRegen.get() == 0.0) {
            return;
        }
        float difficulty = tags.func_74760_g("progressivebosses:difficulty");
        if (difficulty <= 0.0f) {
            return;
        }
        double maxHeal = (Double)ModConfig.COMMON.wither.health.maximumBonusRegen.get();
        double heal = (double)difficulty * (Double)ModConfig.COMMON.wither.health.bonusRegenPerSpawned.get();
        if (heal > maxHeal) {
            heal = maxHeal;
        }
        heal /= 20.0;
        double health = wither.func_110143_aJ();
        if (wither.func_110143_aJ() < wither.func_110138_aP() && wither.func_110143_aJ() > 0.0f) {
            wither.func_70606_j((float)(health + heal));
        }
    }

    private static void spawnSkeletons(WitherEntity wither, World world) {
        BlockPos pos2;
        if ((Integer)ModConfig.COMMON.wither.minions.maxSpawned.get() == 0) {
            return;
        }
        int radius = 32;
        BlockPos pos1 = wither.func_233580_cy_().func_177982_a(-radius, -radius, -radius);
        AxisAlignedBB bb = new AxisAlignedBB(pos1, pos2 = wither.func_233580_cy_().func_177982_a(radius, radius, radius));
        List players = world.func_217357_a(ServerPlayerEntity.class, bb);
        if (players.isEmpty()) {
            return;
        }
        List minions = world.func_217357_a(WitherSkeletonEntity.class, bb);
        int minionsCount = minions.size();
        if (minionsCount >= (Integer)ModConfig.COMMON.wither.minions.maxAround.get()) {
            return;
        }
        CompoundNBT witherTags = wither.getPersistentData();
        witherTags.func_74757_a("mobsrandomizzation:preventProcessing", true);
        float difficulty = witherTags.func_74760_g("progressivebosses:difficulty");
        int cooldown = witherTags.func_74762_e("progressivebosses:skeletons_cooldown");
        if (cooldown > 0) {
            witherTags.func_74768_a("progressivebosses:skeletons_cooldown", cooldown - 1);
        } else {
            int minCooldown = (int)((float)((Integer)ModConfig.COMMON.wither.minions.minCooldown.get()).intValue() * (wither.func_110143_aJ() / wither.func_110138_aP()));
            if ((double)minCooldown < (double)((Integer)ModConfig.COMMON.wither.minions.minCooldown.get()).intValue() * 0.25) {
                minCooldown = (int)((double)((Integer)ModConfig.COMMON.wither.minions.minCooldown.get()).intValue() * 0.25);
            }
            cooldown = MathRandom.getInt(world.field_73012_v, minCooldown, (Integer)ModConfig.COMMON.wither.minions.maxCooldown.get());
            witherTags.func_74768_a("progressivebosses:skeletons_cooldown", cooldown);
            int i = (Integer)ModConfig.COMMON.wither.minions.difficultyToSpawn.get();
            while ((float)i <= difficulty) {
                if (minionsCount >= (Integer)ModConfig.COMMON.wither.minions.maxAround.get() && (Integer)ModConfig.COMMON.wither.minions.maxAround.get() > 0) {
                    return;
                }
                int spawn = i - (Integer)ModConfig.COMMON.wither.minions.difficultyToSpawn.get();
                if (spawn / (Integer)ModConfig.COMMON.wither.minions.difficultyToSpawnOneMore.get() >= (Integer)ModConfig.COMMON.wither.minions.maxSpawned.get()) break;
                if (spawn % (Integer)ModConfig.COMMON.wither.minions.difficultyToSpawnOneMore.get() == 0) {
                    WitherSkeletonEntity witherSkeleton = new WitherSkeletonEntity(EntityType.field_200722_aA, world);
                    CompoundNBT skellyTags = witherSkeleton.getPersistentData();
                    skellyTags.func_74777_a("scalinghealth:difficulty", (short)-1);
                    int x = 0;
                    int y = 0;
                    int z = 0;
                    boolean shouldSpawn = false;
                    for (int t = 0; t < 10; ++t) {
                        x = (int)(wither.func_213303_ch().func_82615_a() + (double)MathRandom.getInt(world.field_73012_v, -3, 3));
                        y = (int)(wither.func_213303_ch().func_82617_b() - 3.0);
                        z = (int)(wither.func_213303_ch().func_82616_c() + (double)MathRandom.getInt(world.field_73012_v, -3, 3));
                        while ((double)y < wither.func_213303_ch().func_82617_b() + 4.0) {
                            if (Wither.canSpawn((MobEntity)witherSkeleton, new BlockPos(x, y, z), world)) {
                                shouldSpawn = true;
                                break;
                            }
                            ++y;
                        }
                        if (shouldSpawn) break;
                    }
                    if (shouldSpawn) {
                        ModifiableAttributeInstance minionHealth = witherSkeleton.func_110148_a(Attributes.field_233818_a_);
                        float health = MathRandom.getFloat(world.field_73012_v, ((Integer)ModConfig.COMMON.wither.minions.minHealth.get()).intValue(), ((Integer)ModConfig.COMMON.wither.minions.maxHealth.get()).intValue());
                        minionHealth.func_111128_a((double)health);
                        ModifiableAttributeInstance speedAttibute = witherSkeleton.func_110148_a(Attributes.field_233821_d_);
                        float maxSpeedMultiplier = 1.2f;
                        float speedMultiplier = difficulty / 100.0f + 1.0f;
                        if (speedMultiplier > maxSpeedMultiplier) {
                            speedMultiplier = maxSpeedMultiplier;
                        }
                        speedAttibute.func_111128_a(speedAttibute.func_111125_b() * (double)speedMultiplier);
                        witherSkeleton.func_70107_b((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f));
                        witherSkeleton.func_200203_b((ITextComponent)new TranslationTextComponent("wither.minion"));
                        witherSkeleton.field_184659_bA = LootTables.field_186419_a;
                        witherSkeleton.field_70728_aV = 1;
                        ListNBT minionsList = witherTags.func_150295_c("minions", 10);
                        CompoundNBT uuid = new CompoundNBT();
                        uuid.func_186854_a("uuid", witherSkeleton.func_110124_au());
                        minionsList.add((Object)uuid);
                        witherTags.func_218657_a("minions", (INBT)minionsList);
                        ArrayList toRemove = new ArrayList();
                        witherSkeleton.field_70714_bg.field_220892_d.forEach(goal -> {
                            if (goal.func_220772_j() instanceof FleeSunGoal) {
                                toRemove.add(goal.func_220772_j());
                            }
                            if (goal.func_220772_j() instanceof RestrictSunGoal) {
                                toRemove.add(goal.func_220772_j());
                            }
                            if (goal.func_220772_j() instanceof AvoidEntityGoal) {
                                toRemove.add(goal.func_220772_j());
                            }
                        });
                        for (Goal goal2 : toRemove) {
                            witherSkeleton.field_70714_bg.func_85156_a(goal2);
                        }
                        toRemove.clear();
                        witherSkeleton.field_70715_bh.field_220892_d.forEach(goal -> {
                            if (goal.func_220772_j() instanceof NearestAttackableTargetGoal) {
                                toRemove.add(goal.func_220772_j());
                            }
                            if (goal.func_220772_j() instanceof HurtByTargetGoal) {
                                toRemove.add(goal.func_220772_j());
                            }
                        });
                        for (Goal goal2 : toRemove) {
                            witherSkeleton.field_70715_bh.func_85156_a(goal2);
                        }
                        toRemove.clear();
                        witherSkeleton.field_70715_bh.func_75776_a(1, (Goal)new WitherMinionHurtByTargetGoal((CreatureEntity)witherSkeleton, WitherEntity.class));
                        witherSkeleton.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)witherSkeleton, PlayerEntity.class, true));
                        witherSkeleton.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)witherSkeleton, IronGolemEntity.class, true));
                        witherSkeleton.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)witherSkeleton, MobEntity.class, 0, false, false, NOT_UNDEAD));
                        world.func_217376_c((Entity)witherSkeleton);
                        ++minionsCount;
                    }
                }
                ++i;
            }
        }
    }

    private static boolean canSpawn(MobEntity mob, BlockPos pos, World world) {
        int height = (int)Math.ceil(mob.func_213302_cg());
        boolean canSpawn = true;
        for (int i = 0; i < height; ++i) {
            if (!world.func_180495_p(pos.func_177981_b(i)).func_185904_a().func_76230_c()) continue;
            canSpawn = false;
            break;
        }
        if (!world.func_180495_p(pos.func_177977_b()).func_185904_a().func_76230_c()) {
            canSpawn = false;
        }
        return canSpawn;
    }

    public static void onDeath(LivingDeathEvent event) {
        if (!(event.getEntity() instanceof WitherEntity)) {
            return;
        }
        WitherEntity wither = (WitherEntity)event.getEntity();
        World world = wither.field_70170_p;
        CompoundNBT tags = wither.getPersistentData();
        ListNBT minionsList = tags.func_150295_c("minions", 10);
        AxisAlignedBB axisAlignedBB = new AxisAlignedBB(new BlockPos((Vector3i)wither.func_233580_cy_().func_177982_a(-128, -128, -128)), wither.func_233580_cy_().func_177982_a(128, 128, 128));
        List witherSkeletons = world.func_217357_a(WitherSkeletonEntity.class, axisAlignedBB);
        block0: for (int i = 0; i < minionsList.size(); ++i) {
            UUID uuid = minionsList.func_150305_b(i).func_186857_a("uuid");
            for (WitherSkeletonEntity skeleton : witherSkeletons) {
                if (!skeleton.func_110124_au().equals(uuid)) continue;
                skeleton.func_195064_c(new EffectInstance(Effects.field_76432_h, 10000, 0, true, false));
                continue block0;
            }
        }
    }

    public static void setDrops(LivingDropsEvent event) {
        int tries;
        if (!(event.getEntityLiving() instanceof WitherEntity)) {
            return;
        }
        WitherEntity wither = (WitherEntity)event.getEntityLiving();
        CompoundNBT tags = wither.getPersistentData();
        float difficulty = tags.func_74760_g("progressivebosses:difficulty");
        double chance = (Double)ModConfig.COMMON.wither.rewards.shardPerDifficulty.get() * (double)difficulty;
        if (chance > (Double)ModConfig.COMMON.wither.rewards.shardMaxChance.get()) {
            chance = (Double)ModConfig.COMMON.wither.rewards.shardMaxChance.get();
        }
        if ((tries = (int)(difficulty / (float)((Integer)ModConfig.COMMON.wither.rewards.shardDivider.get()).intValue()) + 1) > (Integer)ModConfig.COMMON.wither.rewards.shardMaxCount.get()) {
            tries = (Integer)ModConfig.COMMON.wither.rewards.shardMaxCount.get();
        }
        int count = 0;
        for (int i = 0; i < tries; ++i) {
            if ((double)wither.field_70170_p.field_73012_v.nextFloat() >= chance / 100.0) continue;
            ++count;
        }
        if (count == 0) {
            return;
        }
        ItemEntity shard = new ItemEntity(wither.field_70170_p, wither.func_213303_ch().func_82615_a(), wither.func_213303_ch().func_82617_b(), wither.func_213303_ch().func_82616_c(), new ItemStack((IItemProvider)ModItems.NETHER_STAR_SHARD, count));
        event.getDrops().add(shard);
    }
}

