/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.emc;

import java.util.Objects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class SimpleStack {
    public final ResourceLocation id;
    public final int damage;

    public SimpleStack(ResourceLocation id, int damage) {
        this.id = id;
        this.damage = damage;
    }

    public SimpleStack(ItemStack stack) {
        if (stack == null) {
            this.id = new ResourceLocation("minecraft", "air");
            this.damage = 0;
        } else {
            this.id = stack.func_77973_b().getRegistryName();
            this.damage = stack.func_77952_i();
        }
    }

    public SimpleStack withMeta(int meta) {
        return new SimpleStack(this.id, meta);
    }

    public boolean isValid() {
        return !this.id.equals((Object)new ResourceLocation("minecraft", "air"));
    }

    public ItemStack toItemStack() {
        Item item;
        if (this.isValid() && (item = (Item)Item.field_150901_e.func_82594_a((Object)this.id)) != null) {
            return new ItemStack(item, 1, this.damage);
        }
        return null;
    }

    public int hashCode() {
        int hash = 31 * this.id.hashCode();
        if (this.damage == Short.MAX_VALUE) {
            hash = hash * 57 ^ this.damage;
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SimpleStack) {
            SimpleStack other = (SimpleStack)obj;
            if (this.damage == Short.MAX_VALUE || other.damage == Short.MAX_VALUE) {
                return Objects.equals(this.id, other.id);
            }
            return Objects.equals(this.id, other.id) && this.damage == other.damage;
        }
        return false;
    }

    public String toString() {
        Item obj = (Item)Item.field_150901_e.func_82594_a((Object)this.id);
        if (obj != null) {
            return this.id + " " + this.damage;
        }
        return "id:" + this.id + " damage:" + this.damage;
    }
}

