/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.events;

import com.google.common.math.LongMath;
import moze_intel.projecte.api.item.IItemEmc;
import moze_intel.projecte.api.item.IPedestalItem;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.ObjHandler;
import moze_intel.projecte.utils.Constants;
import moze_intel.projecte.utils.EMCHelper;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.oredict.OreDictionary;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class ToolTipEvent {
    @SubscribeEvent
    public static void tTipEvent(ItemTooltipEvent event) {
        ItemStack current = event.getItemStack();
        Item currentItem = current.func_77973_b();
        Block currentBlock = Block.func_149634_a((Item)currentItem);
        if (ProjectEConfig.showPedestalTooltip && currentItem instanceof IPedestalItem) {
            event.getToolTip().add(TextFormatting.DARK_PURPLE + I18n.func_135052_a((String)"pe.pedestal.on_pedestal", (Object[])new Object[0]) + " ");
            Object description = ((IPedestalItem)currentItem).getPedestalDescription();
            if (description.isEmpty()) {
                event.getToolTip().add(IPedestalItem.TOOLTIPDISABLED);
            } else {
                event.getToolTip().addAll(((IPedestalItem)currentItem).getPedestalDescription());
            }
        }
        if (ProjectEConfig.showODNames) {
            for (int id : OreDictionary.getOreIDs((ItemStack)current)) {
                event.getToolTip().add("OD: " + OreDictionary.getOreName((int)id));
            }
            if (currentBlock instanceof BlockFluidBase) {
                event.getToolTip().add("Fluid: " + ((BlockFluidBase)currentBlock).getFluid().getName());
            }
        }
        if (ProjectEConfig.showEMCTooltip && EMCHelper.doesItemHaveEmc(current)) {
            int value = EMCHelper.getEmcValue(current);
            event.getToolTip().add(TextFormatting.YELLOW + I18n.func_135052_a((String)"pe.emc.emc_tooltip_prefix", (Object[])new Object[0]) + " " + TextFormatting.WHITE + Constants.EMC_FORMATTER.format(value) + TextFormatting.BLUE + EMCHelper.getEmcSellString(current, 1));
            if (current.field_77994_a > 1) {
                long total;
                try {
                    total = LongMath.checkedMultiply((long)value, (long)current.field_77994_a);
                }
                catch (ArithmeticException e) {
                    total = Long.MAX_VALUE;
                }
                if (total < 0L || total <= (long)value || total > Integer.MAX_VALUE) {
                    event.getToolTip().add(TextFormatting.YELLOW + I18n.func_135052_a((String)"pe.emc.stackemc_tooltip_prefix", (Object[])new Object[0]) + " " + TextFormatting.OBFUSCATED + I18n.func_135052_a((String)"pe.emc.too_much", (Object[])new Object[0]));
                } else {
                    event.getToolTip().add(TextFormatting.YELLOW + I18n.func_135052_a((String)"pe.emc.stackemc_tooltip_prefix", (Object[])new Object[0]) + " " + TextFormatting.WHITE + Constants.EMC_FORMATTER.format(value * current.field_77994_a) + TextFormatting.BLUE + EMCHelper.getEmcSellString(current, current.field_77994_a));
                }
            }
        }
        if (ProjectEConfig.showStatTooltip) {
            String unit = I18n.func_135052_a((String)"pe.emc.name", (Object[])new Object[0]);
            String rate = I18n.func_135052_a((String)"pe.emc.rate", (Object[])new Object[0]);
            if (currentBlock == ObjHandler.energyCollector) {
                event.getToolTip().add(TextFormatting.DARK_PURPLE + String.format(I18n.func_135052_a((String)"pe.emc.maxgenrate_tooltip", (Object[])new Object[0]) + TextFormatting.BLUE + " %d " + rate, 4));
                event.getToolTip().add(TextFormatting.DARK_PURPLE + String.format(I18n.func_135052_a((String)"pe.emc.maxstorage_tooltip", (Object[])new Object[0]) + TextFormatting.BLUE + " %d " + unit, 10000));
            }
            if (currentBlock == ObjHandler.collectorMK2) {
                event.getToolTip().add(TextFormatting.DARK_PURPLE + String.format(I18n.func_135052_a((String)"pe.emc.maxgenrate_tooltip", (Object[])new Object[0]) + TextFormatting.BLUE + " %d " + rate, 12));
                event.getToolTip().add(TextFormatting.DARK_PURPLE + String.format(I18n.func_135052_a((String)"pe.emc.maxstorage_tooltip", (Object[])new Object[0]) + TextFormatting.BLUE + " %d " + unit, 30000));
            }
            if (currentBlock == ObjHandler.collectorMK3) {
                event.getToolTip().add(TextFormatting.DARK_PURPLE + String.format(I18n.func_135052_a((String)"pe.emc.maxgenrate_tooltip", (Object[])new Object[0]) + TextFormatting.BLUE + " %d " + rate, 40));
                event.getToolTip().add(TextFormatting.DARK_PURPLE + String.format(I18n.func_135052_a((String)"pe.emc.maxstorage_tooltip", (Object[])new Object[0]) + TextFormatting.BLUE + " %d " + unit, 60000));
            }
            if (currentBlock == ObjHandler.relay) {
                event.getToolTip().add(TextFormatting.DARK_PURPLE + String.format(I18n.func_135052_a((String)"pe.emc.maxoutrate_tooltip", (Object[])new Object[0]) + TextFormatting.BLUE + " %d " + rate, 64));
                event.getToolTip().add(TextFormatting.DARK_PURPLE + String.format(I18n.func_135052_a((String)"pe.emc.maxstorage_tooltip", (Object[])new Object[0]) + TextFormatting.BLUE + " %d " + unit, 100000));
            }
            if (currentBlock == ObjHandler.relayMK2) {
                event.getToolTip().add(TextFormatting.DARK_PURPLE + String.format(I18n.func_135052_a((String)"pe.emc.maxoutrate_tooltip", (Object[])new Object[0]) + TextFormatting.BLUE + " %d " + rate, 192));
                event.getToolTip().add(TextFormatting.DARK_PURPLE + String.format(I18n.func_135052_a((String)"pe.emc.maxstorage_tooltip", (Object[])new Object[0]) + TextFormatting.BLUE + " %d " + unit, 1000000));
            }
            if (currentBlock == ObjHandler.relayMK3) {
                event.getToolTip().add(TextFormatting.DARK_PURPLE + String.format(I18n.func_135052_a((String)"pe.emc.maxoutrate_tooltip", (Object[])new Object[0]) + TextFormatting.BLUE + " %d " + rate, 640));
                event.getToolTip().add(TextFormatting.DARK_PURPLE + String.format(I18n.func_135052_a((String)"pe.emc.maxstorage_tooltip", (Object[])new Object[0]) + TextFormatting.BLUE + " %d " + unit, 10000000));
            }
        }
        if (current.func_77942_o() && (current.func_77973_b() instanceof IItemEmc || current.func_77978_p().func_74764_b("StoredEMC"))) {
            double value = 0.0;
            value = current.func_77978_p().func_74764_b("StoredEMC") ? current.func_77978_p().func_74769_h("StoredEMC") : ((IItemEmc)current.func_77973_b()).getStoredEmc(current);
            event.getToolTip().add(TextFormatting.YELLOW + I18n.func_135052_a((String)"pe.emc.storedemc_tooltip", (Object[])new Object[0]) + " " + TextFormatting.RESET + Constants.EMC_FORMATTER.format(value));
        }
    }
}

