/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.events;

import com.google.common.collect.Lists;
import java.util.List;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.ObjHandler;
import moze_intel.projecte.gameObjs.items.ItemMode;
import moze_intel.projecte.gameObjs.items.PhilosophersStone;
import moze_intel.projecte.utils.ItemHelper;
import moze_intel.projecte.utils.ReflectionHelperClient;
import moze_intel.projecte.utils.WorldTransmutations;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class TransmutationRenderingEvent {
    private final Minecraft mc = Minecraft.func_71410_x();
    private final List<AxisAlignedBB> renderList = Lists.newArrayList();
    private double playerX;
    private double playerY;
    private double playerZ;
    private IBlockState transmutationResult;

    @SubscribeEvent
    public void preDrawHud(RenderGameOverlayEvent.Pre event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.CROSSHAIRS && this.transmutationResult != null) {
            if (FluidRegistry.lookupFluidForBlock((Block)this.transmutationResult.func_177230_c()) != null) {
                TextureAtlasSprite sprite = this.mc.func_147117_R().func_110572_b(FluidRegistry.lookupFluidForBlock((Block)this.transmutationResult.func_177230_c()).getFlowing().toString());
                this.mc.field_71446_o.func_110577_a(TextureMap.field_110575_b);
                VertexBuffer wr = Tessellator.func_178181_a().func_178180_c();
                wr.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                wr.func_181662_b(0.0, 0.0, 0.0).func_187315_a((double)sprite.func_94209_e(), (double)sprite.func_94206_g()).func_181675_d();
                wr.func_181662_b(0.0, 16.0, 0.0).func_187315_a((double)sprite.func_94209_e(), (double)sprite.func_94210_h()).func_181675_d();
                wr.func_181662_b(16.0, 16.0, 0.0).func_187315_a((double)sprite.func_94212_f(), (double)sprite.func_94210_h()).func_181675_d();
                wr.func_181662_b(16.0, 0.0, 0.0).func_187315_a((double)sprite.func_94212_f(), (double)sprite.func_94206_g()).func_181675_d();
                Tessellator.func_178181_a().func_78381_a();
            } else {
                RenderHelper.func_74519_b();
                IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_184389_a(this.transmutationResult);
                ReflectionHelperClient.renderBakedModelIntoGUI(ItemHelper.stateToDroppedStack(this.transmutationResult, 1), 0, 0, model);
                RenderHelper.func_74518_a();
            }
        }
    }

    @SubscribeEvent
    public void onOverlay(DrawBlockHighlightEvent event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        World world = player.func_130014_f_();
        ItemStack stack = player.func_184586_b(EnumHand.MAIN_HAND);
        if (stack == null) {
            stack = player.func_184586_b(EnumHand.OFF_HAND);
        }
        if (stack == null || stack.func_77973_b() != ObjHandler.philosStone) {
            this.transmutationResult = null;
            return;
        }
        this.playerX = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)event.getPartialTicks();
        this.playerY = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)event.getPartialTicks();
        this.playerZ = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)event.getPartialTicks();
        RayTraceResult mop = ((PhilosophersStone)ObjHandler.philosStone).getHitBlock((EntityPlayer)player);
        if (mop != null && mop.field_72313_a == RayTraceResult.Type.BLOCK) {
            IBlockState current = world.func_180495_p(mop.func_178782_a());
            this.transmutationResult = WorldTransmutations.getWorldTransmutation(current, player.func_70093_af());
            if (this.transmutationResult != null) {
                byte charge = ((ItemMode)stack.func_77973_b()).getCharge(stack);
                byte mode = ((ItemMode)stack.func_77973_b()).getMode(stack);
                for (BlockPos pos : PhilosophersStone.getAffectedPositions(world, mop.func_178782_a(), (EntityPlayer)player, mop.field_178784_b, mode, charge)) {
                    this.addBlockToRenderList(world, pos);
                }
                this.drawAll();
                this.renderList.clear();
            }
        } else {
            this.transmutationResult = null;
        }
    }

    private void drawAll() {
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179090_x();
        GlStateManager.func_179129_p();
        GlStateManager.func_179140_f();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)(ProjectEConfig.pulsatingOverlay ? this.getPulseProportion() * 0.6f : 0.35f));
        Tessellator tess = Tessellator.func_178181_a();
        VertexBuffer wr = tess.func_178180_c();
        wr.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        for (AxisAlignedBB b : this.renderList) {
            wr.func_181662_b(b.field_72340_a, b.field_72337_e, b.field_72339_c).func_181675_d();
            wr.func_181662_b(b.field_72336_d, b.field_72337_e, b.field_72339_c).func_181675_d();
            wr.func_181662_b(b.field_72336_d, b.field_72337_e, b.field_72334_f).func_181675_d();
            wr.func_181662_b(b.field_72340_a, b.field_72337_e, b.field_72334_f).func_181675_d();
            wr.func_181662_b(b.field_72340_a, b.field_72338_b, b.field_72339_c).func_181675_d();
            wr.func_181662_b(b.field_72336_d, b.field_72338_b, b.field_72339_c).func_181675_d();
            wr.func_181662_b(b.field_72336_d, b.field_72338_b, b.field_72334_f).func_181675_d();
            wr.func_181662_b(b.field_72340_a, b.field_72338_b, b.field_72334_f).func_181675_d();
            wr.func_181662_b(b.field_72336_d, b.field_72337_e, b.field_72334_f).func_181675_d();
            wr.func_181662_b(b.field_72340_a, b.field_72337_e, b.field_72334_f).func_181675_d();
            wr.func_181662_b(b.field_72340_a, b.field_72338_b, b.field_72334_f).func_181675_d();
            wr.func_181662_b(b.field_72336_d, b.field_72338_b, b.field_72334_f).func_181675_d();
            wr.func_181662_b(b.field_72336_d, b.field_72338_b, b.field_72339_c).func_181675_d();
            wr.func_181662_b(b.field_72340_a, b.field_72338_b, b.field_72339_c).func_181675_d();
            wr.func_181662_b(b.field_72340_a, b.field_72337_e, b.field_72339_c).func_181675_d();
            wr.func_181662_b(b.field_72336_d, b.field_72337_e, b.field_72339_c).func_181675_d();
            wr.func_181662_b(b.field_72340_a, b.field_72337_e, b.field_72334_f).func_181675_d();
            wr.func_181662_b(b.field_72340_a, b.field_72337_e, b.field_72339_c).func_181675_d();
            wr.func_181662_b(b.field_72340_a, b.field_72338_b, b.field_72339_c).func_181675_d();
            wr.func_181662_b(b.field_72340_a, b.field_72338_b, b.field_72334_f).func_181675_d();
            wr.func_181662_b(b.field_72336_d, b.field_72337_e, b.field_72334_f).func_181675_d();
            wr.func_181662_b(b.field_72336_d, b.field_72337_e, b.field_72339_c).func_181675_d();
            wr.func_181662_b(b.field_72336_d, b.field_72338_b, b.field_72339_c).func_181675_d();
            wr.func_181662_b(b.field_72336_d, b.field_72338_b, b.field_72334_f).func_181675_d();
        }
        tess.func_78381_a();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179089_o();
        GlStateManager.func_179145_e();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }

    private void addBlockToRenderList(World world, BlockPos pos) {
        AxisAlignedBB box = world.func_180495_p(pos).func_185918_c(world, pos).func_186662_g(0.02);
        box = box.func_72317_d(-this.playerX, -this.playerY, -this.playerZ);
        this.renderList.add(box);
    }

    private float getPulseProportion() {
        return (float)(0.5 * Math.sin((double)System.currentTimeMillis() / 350.0) + 0.5);
    }
}

