/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.integration.jei.world_transmute;

import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class WorldTransmuteRecipeCategory
implements IRecipeCategory {
    public static final String UID = "pe.worldtransmute";
    private final IDrawable background;
    private final IDrawable arrow;
    private final String localizedName;

    public WorldTransmuteRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(175, 48);
        this.arrow = guiHelper.createDrawable(new ResourceLocation("projecte:textures/gui/arrow.png"), 0, 0, 32, 32);
        this.localizedName = I18n.func_135052_a((String)"pe.nei.worldtransmute", (Object[])new Object[0]);
    }

    @Nonnull
    public String getUid() {
        return UID;
    }

    @Nonnull
    public String getTitle() {
        return this.localizedName;
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public void drawExtras(@Nonnull Minecraft minecraft) {
        this.arrow.draw(minecraft, -30, 0);
    }

    public void drawAnimations(@Nonnull Minecraft minecraft) {
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull IRecipeWrapper recipeWrapper) {
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull IRecipeWrapper recipeWrapper, @Nonnull IIngredients ingredients) {
        int itemSlots = 0;
        int fluidSlots = 0;
        int xPos = 16;
        for (List s : ingredients.getInputs(FluidStack.class)) {
            recipeLayout.getFluidStacks().init(fluidSlots, true, xPos, 16, 16, 16, 1000, false, null);
            recipeLayout.getFluidStacks().set(fluidSlots, s);
            ++fluidSlots;
            xPos += 16;
        }
        xPos = 16;
        for (List s : ingredients.getInputs(ItemStack.class)) {
            recipeLayout.getItemStacks().init(itemSlots, true, xPos, 16);
            recipeLayout.getItemStacks().set(itemSlots, s);
            ++itemSlots;
            xPos += 16;
        }
        xPos = 128;
        for (List s : ingredients.getOutputs(ItemStack.class)) {
            recipeLayout.getItemStacks().init(itemSlots, false, xPos, 16);
            recipeLayout.getItemStacks().set(itemSlots, (ItemStack)s);
            ++itemSlots;
            xPos += 16;
        }
        xPos = 128;
        for (List s : ingredients.getOutputs(FluidStack.class)) {
            recipeLayout.getFluidStacks().init(fluidSlots, false, xPos, 16, 16, 16, 1000, false, null);
            recipeLayout.getFluidStacks().set(fluidSlots, (FluidStack)s);
            ++fluidSlots;
            xPos += 16;
        }
    }
}

