/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.manual;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import moze_intel.projecte.gameObjs.ObjHandler;
import moze_intel.projecte.manual.AbstractPage;
import moze_intel.projecte.manual.IndexPage;
import moze_intel.projecte.manual.PageCategory;
import moze_intel.projecte.utils.PELogger;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

@SideOnly(value=Side.CLIENT)
public class ManualPageHandler {
    public static final List<IndexPage> indexPages = Lists.newArrayList();
    public static final List<AbstractPage> pages = Lists.newArrayList();
    public static final Map<PageCategory, List<AbstractPage>> categoryMap = Maps.newEnumMap(PageCategory.class);
    public static final List<Pair<AbstractPage, AbstractPage>> spreads = Lists.newArrayList();

    public static void init() {
        IResourceManager resourceManager = Minecraft.func_71410_x().func_110442_L();
        if (resourceManager instanceof IReloadableResourceManager) {
            ((IReloadableResourceManager)resourceManager).func_110542_a(resourceManager1 -> ManualPageHandler.reset());
        }
        ManualPageHandler.reset();
    }

    private static void reset() {
        indexPages.clear();
        pages.clear();
        categoryMap.clear();
        spreads.clear();
        ManualPageHandler.setupPages();
    }

    private static void setupPages() {
        for (PageCategory e : PageCategory.values()) {
            categoryMap.put(e, Lists.newArrayList());
        }
        ManualPageHandler.addTextPage("introduction", PageCategory.NONE);
        ManualPageHandler.addBlock(ObjHandler.alchChest, PageCategory.BLOCK);
        ManualPageHandler.addImagePage("img_alchchest", new ResourceLocation("projecte:textures/gui/alchchest.png"), PageCategory.BLOCK);
        ManualPageHandler.addBlock(ObjHandler.confuseTorch, PageCategory.BLOCK);
        ManualPageHandler.addBlock(ObjHandler.transmuteStone, PageCategory.BLOCK);
        ManualPageHandler.addBlock(ObjHandler.condenser, PageCategory.BLOCK);
        ManualPageHandler.addBlock(ObjHandler.condenserMk2, PageCategory.BLOCK);
        ManualPageHandler.addBlock(ObjHandler.rmFurnaceOff, PageCategory.BLOCK);
        ManualPageHandler.addBlock(ObjHandler.dmFurnaceOff, PageCategory.BLOCK);
        ManualPageHandler.addBlock(ObjHandler.dmPedestal, PageCategory.BLOCK);
        ManualPageHandler.addBlock(ObjHandler.energyCollector, PageCategory.BLOCK);
        ManualPageHandler.addBlock(ObjHandler.collectorMK2, PageCategory.BLOCK);
        ManualPageHandler.addBlock(ObjHandler.collectorMK3, PageCategory.BLOCK);
        ManualPageHandler.addBlock(ObjHandler.relay, PageCategory.BLOCK);
        ManualPageHandler.addBlock(ObjHandler.relayMK2, PageCategory.BLOCK);
        ManualPageHandler.addBlock(ObjHandler.relayMK3, PageCategory.BLOCK);
        ManualPageHandler.addBlock(ObjHandler.novaCatalyst, PageCategory.BLOCK);
        ManualPageHandler.addBlock(ObjHandler.novaCataclysm, PageCategory.BLOCK);
        ManualPageHandler.addBlock(ObjHandler.matterBlock, PageCategory.BLOCK);
        ManualPageHandler.addBlock(ObjHandler.fuelBlock, PageCategory.BLOCK);
        ManualPageHandler.addItem(ObjHandler.philosStone, PageCategory.ITEM);
        ManualPageHandler.addItem(ObjHandler.alchBag, PageCategory.ITEM);
        ManualPageHandler.addItem(ObjHandler.repairTalisman, PageCategory.ITEM);
        ManualPageHandler.addItem(ObjHandler.dmPick, PageCategory.TOOLS);
        ManualPageHandler.addItem(ObjHandler.dmAxe, PageCategory.TOOLS);
        ManualPageHandler.addItem(ObjHandler.dmShovel, PageCategory.TOOLS);
        ManualPageHandler.addItem(ObjHandler.dmSword, PageCategory.TOOLS);
        ManualPageHandler.addItem(ObjHandler.dmHoe, PageCategory.TOOLS);
        ManualPageHandler.addItem(ObjHandler.dmShears, PageCategory.TOOLS);
        ManualPageHandler.addItem(ObjHandler.dmHammer, PageCategory.TOOLS);
        ManualPageHandler.addItem(ObjHandler.rmPick, PageCategory.TOOLS);
        ManualPageHandler.addItem(ObjHandler.rmAxe, PageCategory.TOOLS);
        ManualPageHandler.addItem(ObjHandler.rmShovel, PageCategory.TOOLS);
        ManualPageHandler.addItem(ObjHandler.rmSword, PageCategory.TOOLS);
        ManualPageHandler.addItem(ObjHandler.rmHoe, PageCategory.TOOLS);
        ManualPageHandler.addItem(ObjHandler.rmShears, PageCategory.TOOLS);
        ManualPageHandler.addItem(ObjHandler.rmHammer, PageCategory.TOOLS);
        ManualPageHandler.addItem(ObjHandler.rmKatar, PageCategory.TOOLS);
        ManualPageHandler.addItem(ObjHandler.rmStar, PageCategory.TOOLS);
        ManualPageHandler.addItem(ObjHandler.dmHelmet, PageCategory.ARMOR);
        ManualPageHandler.addItem(ObjHandler.dmChest, PageCategory.ARMOR);
        ManualPageHandler.addItem(ObjHandler.dmLegs, PageCategory.ARMOR);
        ManualPageHandler.addItem(ObjHandler.dmFeet, PageCategory.ARMOR);
        ManualPageHandler.addItem(ObjHandler.rmHelmet, PageCategory.ARMOR);
        ManualPageHandler.addItem(ObjHandler.rmChest, PageCategory.ARMOR);
        ManualPageHandler.addItem(ObjHandler.rmLegs, PageCategory.ARMOR);
        ManualPageHandler.addItem(ObjHandler.rmFeet, PageCategory.ARMOR);
        ManualPageHandler.addItem(ObjHandler.gemHelmet, PageCategory.ARMOR);
        ManualPageHandler.addItem(ObjHandler.gemChest, PageCategory.ARMOR);
        ManualPageHandler.addItem(ObjHandler.gemLegs, PageCategory.ARMOR);
        ManualPageHandler.addItem(ObjHandler.gemFeet, PageCategory.ARMOR);
        ManualPageHandler.addItem(ObjHandler.ironBand, PageCategory.MUSTFIGUREOUTTHERESTOFTHESE);
        ManualPageHandler.addItem(ObjHandler.blackHole, PageCategory.MUSTFIGUREOUTTHERESTOFTHESE);
        ManualPageHandler.addItem(ObjHandler.angelSmite, PageCategory.MUSTFIGUREOUTTHERESTOFTHESE);
        ManualPageHandler.addItem(ObjHandler.harvestGod, PageCategory.MUSTFIGUREOUTTHERESTOFTHESE);
        ManualPageHandler.addItem(ObjHandler.ignition, PageCategory.MUSTFIGUREOUTTHERESTOFTHESE);
        ManualPageHandler.addItem(ObjHandler.zero, PageCategory.MUSTFIGUREOUTTHERESTOFTHESE);
        ManualPageHandler.addItem(ObjHandler.swrg, PageCategory.MUSTFIGUREOUTTHERESTOFTHESE);
        ManualPageHandler.addItem(ObjHandler.timeWatch, PageCategory.MUSTFIGUREOUTTHERESTOFTHESE);
        ManualPageHandler.addItem(ObjHandler.everTide, PageCategory.MUSTFIGUREOUTTHERESTOFTHESE);
        ManualPageHandler.addItem(ObjHandler.volcanite, PageCategory.MUSTFIGUREOUTTHERESTOFTHESE);
        ManualPageHandler.addItem(ObjHandler.eternalDensity, PageCategory.MUSTFIGUREOUTTHERESTOFTHESE);
        ManualPageHandler.addItem(ObjHandler.dRod1, PageCategory.MUSTFIGUREOUTTHERESTOFTHESE);
        ManualPageHandler.addItem(ObjHandler.dRod2, PageCategory.MUSTFIGUREOUTTHERESTOFTHESE);
        ManualPageHandler.addItem(ObjHandler.dRod3, PageCategory.MUSTFIGUREOUTTHERESTOFTHESE);
        ManualPageHandler.addItem(ObjHandler.mercEye, PageCategory.MUSTFIGUREOUTTHERESTOFTHESE);
        ManualPageHandler.addItem(ObjHandler.voidRing, PageCategory.MUSTFIGUREOUTTHERESTOFTHESE);
        ManualPageHandler.addItem(ObjHandler.arcana, PageCategory.MUSTFIGUREOUTTHERESTOFTHESE);
        ManualPageHandler.addItem(ObjHandler.dCatalyst, PageCategory.MUSTFIGUREOUTTHERESTOFTHESE);
        ManualPageHandler.addItem(ObjHandler.hyperLens, PageCategory.MUSTFIGUREOUTTHERESTOFTHESE);
        ManualPageHandler.addItem(ObjHandler.cataliticLens, PageCategory.MUSTFIGUREOUTTHERESTOFTHESE);
        ManualPageHandler.addItem(ObjHandler.bodyStone, PageCategory.MUSTFIGUREOUTTHERESTOFTHESE);
        ManualPageHandler.addItem(ObjHandler.soulStone, PageCategory.MUSTFIGUREOUTTHERESTOFTHESE);
        ManualPageHandler.addItem(ObjHandler.mindStone, PageCategory.MUSTFIGUREOUTTHERESTOFTHESE);
        ManualPageHandler.addItem(ObjHandler.lifeStone, PageCategory.MUSTFIGUREOUTTHERESTOFTHESE);
        ManualPageHandler.addItem(ObjHandler.tome, PageCategory.MUSTFIGUREOUTTHERESTOFTHESE);
        ManualPageHandler.addItem(ObjHandler.transmutationTablet, PageCategory.MUSTFIGUREOUTTHERESTOFTHESE);
        ManualPageHandler.addItem(ObjHandler.matter, PageCategory.MUSTFIGUREOUTTHERESTOFTHESE);
        ManualPageHandler.addItem(ObjHandler.fuels, PageCategory.MUSTFIGUREOUTTHERESTOFTHESE);
        ManualPageHandler.addItem(ObjHandler.covalence, PageCategory.MUSTFIGUREOUTTHERESTOFTHESE);
        ManualPageHandler.addItem(ObjHandler.kleinStars, PageCategory.MUSTFIGUREOUTTHERESTOFTHESE);
        for (List list : categoryMap.values()) {
            Collections.sort(list, (o1, o2) -> I18n.func_135052_a((String)o1.getHeaderText(), (Object[])new Object[0]).compareToIgnoreCase(I18n.func_135052_a((String)o2.getHeaderText(), (Object[])new Object[0])));
            for (AbstractPage page : list) {
                pages.add(page);
            }
        }
        PELogger.logDebug("Built %d standard pages", pages.size());
        ManualPageHandler.generateDummyIndexPages();
        ManualPageHandler.buildPageSpreads();
    }

    private static void generateDummyIndexPages() {
        ArrayList toAdd = Lists.newArrayList();
        int numIndexPages = Math.round((float)pages.size() / 16.0f);
        PELogger.logDebug("" + (float)pages.size() / 16.0f);
        for (int i = 0; i < numIndexPages; ++i) {
            toAdd.add(new IndexPage());
        }
        indexPages.addAll(toAdd);
        pages.addAll(0, indexPages);
        PELogger.logDebug("Built %d dummy index pages", indexPages.size());
    }

    private static void buildPageSpreads() {
        int firstNormalPage = 0;
        for (AbstractPage page : pages) {
            if (page instanceof IndexPage) continue;
            firstNormalPage = pages.indexOf(page);
            break;
        }
        ManualPageHandler.doBuildSpread(pages.subList(0, firstNormalPage));
        PELogger.logDebug("Built %d index spreads", spreads.size());
        ManualPageHandler.doBuildSpread(pages.subList(firstNormalPage, pages.size()));
        PELogger.logDebug("Built %d spreads total", spreads.size());
    }

    private static void doBuildSpread(List<AbstractPage> list) {
        for (int i = 0; i < list.size(); i += 2) {
            if (i == list.size() - 1) {
                spreads.add((Pair<AbstractPage, AbstractPage>)ImmutablePair.of((Object)list.get(i), (Object)null));
                continue;
            }
            spreads.add((Pair<AbstractPage, AbstractPage>)ImmutablePair.of((Object)list.get(i), (Object)list.get(i + 1)));
        }
    }

    private static void addItem(Item item, PageCategory category) {
        List<ItemStack> list = item == ObjHandler.alchBag || !item.func_77614_k() ? Collections.singletonList(new ItemStack(item)) : ManualPageHandler.getSubItems(item);
        for (ItemStack s : list) {
            AbstractPage page = AbstractPage.createItemPage(s, category);
            categoryMap.get((Object)category).add(page);
            categoryMap.get((Object)category).addAll(page.subPages);
            PELogger.logDebug("Added %d item pages for stack %s", page.subPages.size() + 1, s.toString());
        }
    }

    private static void addBlock(Block block, PageCategory category) {
        ManualPageHandler.addItem(Item.func_150898_a((Block)block), category);
    }

    private static void addTextPage(String identifier, PageCategory category) {
        AbstractPage page = AbstractPage.createTextPages(identifier, category);
        categoryMap.get((Object)category).add(page);
        categoryMap.get((Object)category).addAll(page.subPages);
        PELogger.logDebug("Added %d text pages for identifier %s", page.subPages.size() + 1, identifier);
    }

    private static void addImagePage(String identifier, ResourceLocation resource, PageCategory category) {
        AbstractPage page = AbstractPage.createImagePage(identifier, resource, category);
        categoryMap.get((Object)category).add(page);
    }

    private static List<ItemStack> getSubItems(Item i) {
        ArrayList list = Lists.newArrayList();
        i.func_150895_a(i, null, (List)list);
        return list;
    }
}

