/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.utils;

import moze_intel.projecte.api.item.IItemEmc;
import moze_intel.projecte.gameObjs.tiles.CollectorMK1Tile;
import moze_intel.projecte.gameObjs.tiles.RelayMK1Tile;
import moze_intel.projecte.utils.MathUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public final class ComparatorHelper {
    public static int getForAlchChest(World world, BlockPos pos) {
        return ComparatorHelper.calcRedstoneFromInventory((IItemHandler)world.func_175625_s(pos).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null));
    }

    public static int getForCollector(World world, BlockPos pos) {
        CollectorMK1Tile tile = (CollectorMK1Tile)world.func_175625_s(pos);
        ItemStack charging = ((IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP)).getStackInSlot(0);
        if (charging != null) {
            if (charging.func_77973_b() instanceof IItemEmc) {
                IItemEmc itemEmc = (IItemEmc)charging.func_77973_b();
                double max = itemEmc.getMaximumEmc(charging);
                double current = itemEmc.getStoredEmc(charging);
                return MathUtils.scaleToRedstone(current, max);
            }
            double needed = tile.getEmcToNextGoal();
            double current = tile.getStoredEmc();
            return MathUtils.scaleToRedstone(current, needed);
        }
        return MathUtils.scaleToRedstone(tile.getStoredEmc(), tile.getMaximumEmc());
    }

    public static int getForCondenser(World world, BlockPos pos) {
        return ComparatorHelper.calcRedstoneFromInventory((IItemHandler)world.func_175625_s(pos).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null));
    }

    public static int getForMatterFurnace(World world, BlockPos pos) {
        return ComparatorHelper.calcRedstoneFromInventory((IItemHandler)world.func_175625_s(pos).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null));
    }

    public static int getForRelay(World world, BlockPos pos) {
        RelayMK1Tile relay = (RelayMK1Tile)world.func_175625_s(pos);
        return MathUtils.scaleToRedstone(relay.getStoredEmc(), relay.getMaximumEmc());
    }

    private static int calcRedstoneFromInventory(IItemHandler handler) {
        if (handler == null) {
            return 0;
        }
        int i = 0;
        float f = 0.0f;
        for (int j = 0; j < handler.getSlots(); ++j) {
            ItemStack itemstack = handler.getStackInSlot(j);
            if (itemstack == null) continue;
            f += (float)itemstack.field_77994_a / (float)itemstack.func_77976_d();
            ++i;
        }
        return MathHelper.func_76141_d((float)((f /= (float)handler.getSlots()) * 14.0f)) + (i > 0 ? 1 : 0);
    }
}

