/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.config;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.annotations.SerializedName;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import moze_intel.projecte.PECore;
import moze_intel.projecte.emc.json.NSSItem;
import moze_intel.projecte.emc.json.NSSOreDictionary;
import moze_intel.projecte.emc.json.NormalizedSimpleStack;

public final class CustomEMCParser {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(NormalizedSimpleStack.class, (Object)NormalizedSimpleStack.Serializer.INSTANCE).setPrettyPrinting().create();
    private static final File CONFIG = new File(PECore.CONFIG_DIR, "custom_emc.json");
    public static CustomEMCFile currentEntries;
    private static boolean dirty;

    public static void init() {
        CustomEMCParser.flush();
        if (!CONFIG.exists()) {
            try {
                if (CONFIG.createNewFile()) {
                    CustomEMCParser.writeDefaultFile();
                }
            }
            catch (IOException e2) {
                PECore.LOGGER.fatal("Exception in file I/O: couldn't create custom configuration files.");
            }
        }
        try (BufferedReader reader = new BufferedReader(new FileReader(CONFIG));){
            currentEntries = (CustomEMCFile)GSON.fromJson((Reader)reader, CustomEMCFile.class);
            CustomEMCParser.currentEntries.entries.removeIf(e -> e.nss == null || e.emc < 0 || !(e.nss instanceof NSSItem) && !(e.nss instanceof NSSOreDictionary));
        }
        catch (JsonParseException | IOException e3) {
            PECore.LOGGER.fatal("Couldn't read custom emc file");
            e3.printStackTrace();
            currentEntries = new CustomEMCFile(new ArrayList<CustomEMCEntry>());
        }
    }

    private static NormalizedSimpleStack getNss(String str, int meta) {
        if (str.contains(":")) {
            return NSSItem.create(str, meta);
        }
        return NSSOreDictionary.create(str);
    }

    public static boolean addToFile(String toAdd, int meta, int emc) {
        NormalizedSimpleStack nss = CustomEMCParser.getNss(toAdd, meta);
        CustomEMCEntry entry = new CustomEMCEntry(nss, emc);
        int setAt = -1;
        for (int i = 0; i < CustomEMCParser.currentEntries.entries.size(); ++i) {
            if (!CustomEMCParser.currentEntries.entries.get((int)i).nss.equals(nss)) continue;
            setAt = i;
            break;
        }
        if (setAt == -1) {
            CustomEMCParser.currentEntries.entries.add(entry);
        } else {
            CustomEMCParser.currentEntries.entries.set(setAt, entry);
        }
        dirty = true;
        return true;
    }

    public static boolean removeFromFile(String toRemove, int meta) {
        NormalizedSimpleStack nss = CustomEMCParser.getNss(toRemove, meta);
        Iterator<CustomEMCEntry> iter = CustomEMCParser.currentEntries.entries.iterator();
        boolean removed = false;
        while (iter.hasNext()) {
            if (!iter.next().nss.equals(nss)) continue;
            iter.remove();
            dirty = true;
            removed = true;
        }
        return removed;
    }

    private static void flush() {
        if (dirty) {
            try {
                Files.write((CharSequence)GSON.toJson((Object)currentEntries), (File)CONFIG, (Charset)Charsets.UTF_8);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            dirty = false;
        }
    }

    private static void writeDefaultFile() {
        JsonObject elem = (JsonObject)GSON.toJsonTree((Object)new CustomEMCFile(new ArrayList<CustomEMCEntry>()));
        elem.add("__comment", (JsonElement)new JsonPrimitive("Use the in-game commands to edit this file"));
        try {
            Files.write((CharSequence)GSON.toJson((JsonElement)elem), (File)CONFIG, (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        dirty = false;
    }

    public static class CustomEMCEntry {
        @SerializedName(value="item")
        public final NormalizedSimpleStack nss;
        public final int emc;

        private CustomEMCEntry(NormalizedSimpleStack nss, int emc) {
            this.nss = nss;
            this.emc = emc;
        }

        public boolean equals(Object o) {
            return o == this || o instanceof CustomEMCEntry && this.nss.equals(((CustomEMCEntry)o).nss) && this.emc == ((CustomEMCEntry)o).emc;
        }

        public int hashCode() {
            return this.nss.hashCode() ^ 31 * this.emc;
        }
    }

    public static class CustomEMCFile {
        public final List<CustomEMCEntry> entries;

        public CustomEMCFile(List<CustomEMCEntry> entries) {
            this.entries = entries;
        }
    }
}

