/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.config;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import moze_intel.projecte.PECore;
import moze_intel.projecte.utils.NBTWhitelist;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;

public final class NBTWhitelistParser {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(NBTWhiteList.class, (Object)new Serializer()).setPrettyPrinting().create();
    private static final File CONFIG = new File(PECore.CONFIG_DIR, "nbt_whitelist.json");

    public static void init() {
        if (!CONFIG.exists()) {
            try {
                if (CONFIG.createNewFile()) {
                    NBTWhitelistParser.writeDefaultFile();
                }
            }
            catch (IOException e) {
                PECore.LOGGER.fatal("Exception in file I/O: couldn't create custom configuration files.");
                e.printStackTrace();
            }
        }
        try (BufferedReader reader = new BufferedReader(new FileReader(CONFIG));){
            NBTWhiteList whitelist = (NBTWhiteList)GSON.fromJson((Reader)reader, NBTWhiteList.class);
            for (Item i : whitelist.items) {
                NBTWhitelist.register(new ItemStack(i));
            }
        }
        catch (IOException e) {
            PECore.LOGGER.fatal("Couldn't read nbt whitelist file");
        }
    }

    private static void writeDefaultFile() {
        ArrayList<Item> defaults = new ArrayList<Item>();
        if (Loader.isModLoaded((String)"tconstruct")) {
            defaults.add(Item.func_111206_d((String)"tconstruct:pickaxe"));
        }
        if (Loader.isModLoaded((String)"botania")) {
            defaults.add(Item.func_111206_d((String)"botania:specialFlower"));
        }
        JsonObject obj = (JsonObject)GSON.toJsonTree((Object)new NBTWhiteList(defaults));
        obj.add("__comment", (JsonElement)new JsonPrimitive("To add items to NBT Whitelist, simply add its registry name as a String to the above array"));
        try {
            Files.write((CharSequence)GSON.toJson((JsonElement)obj), (File)CONFIG, (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static class Serializer
    implements JsonSerializer<NBTWhiteList>,
    JsonDeserializer<NBTWhiteList> {
        private Serializer() {
        }

        public NBTWhiteList deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject obj = JsonUtils.func_151210_l((JsonElement)json, (String)"nbt whitelist");
            JsonArray arr = JsonUtils.func_151214_t((JsonObject)obj, (String)"items");
            List itemNames = (List)context.deserialize((JsonElement)arr, new TypeToken<List<String>>(){}.getType());
            ArrayList<Item> items = new ArrayList<Item>();
            for (String s : itemNames) {
                Item i = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(s));
                if (i != null) {
                    items.add(i);
                    continue;
                }
                PECore.LOGGER.warn("Could not find Item {} specified in nbt_whitelist.cfg", new Object[]{s});
            }
            return new NBTWhiteList(items);
        }

        public JsonElement serialize(NBTWhiteList src, Type typeOfSrc, JsonSerializationContext context) {
            ArrayList<String> registryNames = new ArrayList<String>();
            for (Item item : src.items) {
                registryNames.add(item.getRegistryName().toString());
            }
            JsonObject ret = new JsonObject();
            ret.add("items", context.serialize(registryNames));
            return ret;
        }
    }

    private static class NBTWhiteList {
        public final List<Item> items;

        private NBTWhiteList(List<Item> items) {
            this.items = items;
        }
    }
}

