/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.emc.mappers;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import moze_intel.projecte.PECore;
import moze_intel.projecte.emc.IngredientMap;
import moze_intel.projecte.emc.collector.IMappingCollector;
import moze_intel.projecte.emc.json.NSSFake;
import moze_intel.projecte.emc.json.NSSItem;
import moze_intel.projecte.emc.json.NormalizedSimpleStack;
import moze_intel.projecte.emc.mappers.IEMCMapper;
import moze_intel.projecte.gameObjs.customRecipes.RecipeShapedKleinStar;
import moze_intel.projecte.gameObjs.customRecipes.RecipeShapelessHidden;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class CraftingMapper
implements IEMCMapper<NormalizedSimpleStack, Integer> {
    private final List<IRecipeMapper> recipeMappers = Arrays.asList(new VanillaRecipeMapper(), new VanillaOreRecipeMapper(), new PECustomRecipeMapper());
    private final Set<Class> canNotMap = Sets.newHashSet();
    private final Map<Class, Integer> recipeCount = Maps.newHashMap();

    @Override
    public void addMappings(IMappingCollector<NormalizedSimpleStack, Integer> mapper, Configuration config) {
        this.recipeCount.clear();
        this.canNotMap.clear();
        block2: for (IRecipe iRecipe : CraftingManager.func_77594_a().func_77592_b()) {
            boolean handled = false;
            ItemStack recipeOutput = iRecipe.func_77571_b();
            if (recipeOutput == null) continue;
            NormalizedSimpleStack recipeOutputNorm = NSSItem.create(recipeOutput);
            for (IRecipeMapper recipeMapper : this.recipeMappers) {
                if (!config.getBoolean("enable" + recipeMapper.getName(), "IRecipeImplementations", true, recipeMapper.getDescription()) || !recipeMapper.canHandle(iRecipe)) continue;
                handled = true;
                Iterable<CraftingIngredients> craftingIngredientIterable = recipeMapper.getIngredientsFor(iRecipe);
                if (craftingIngredientIterable != null) {
                    for (CraftingIngredients variation : craftingIngredientIterable) {
                        IngredientMap<NormalizedSimpleStack> ingredientMap = new IngredientMap<NormalizedSimpleStack>();
                        for (ItemStack itemStack : variation.fixedIngredients) {
                            if (itemStack.func_190926_b()) continue;
                            if (itemStack.func_77952_i() == Short.MAX_VALUE) {
                                ingredientMap.addIngredient(NSSItem.create(itemStack), 1);
                                continue;
                            }
                            try {
                                if (itemStack.func_77973_b().hasContainerItem(itemStack)) {
                                    ingredientMap.addIngredient(NSSItem.create(itemStack.func_77973_b().getContainerItem(itemStack)), -1);
                                }
                                ingredientMap.addIngredient(NSSItem.create(itemStack), 1);
                            }
                            catch (Exception e) {
                                PECore.LOGGER.fatal("Exception in CraftingMapper when parsing Recipe Ingredients: RecipeType: {}, Ingredient: {}", new Object[]{iRecipe.getClass().getName(), itemStack.toString()});
                                e.printStackTrace();
                                continue block2;
                            }
                        }
                        for (Iterable iterable : variation.multiIngredients) {
                            NormalizedSimpleStack normalizedSimpleStack = NSSFake.create(iterable.toString());
                            ingredientMap.addIngredient(normalizedSimpleStack, 1);
                            for (ItemStack stack : iterable) {
                                if (stack.func_190926_b()) continue;
                                IngredientMap<NormalizedSimpleStack> groupIngredientMap = new IngredientMap<NormalizedSimpleStack>();
                                if (stack.func_77973_b().hasContainerItem(stack)) {
                                    groupIngredientMap.addIngredient(NSSItem.create(stack.func_77973_b().getContainerItem(stack)), -1);
                                }
                                groupIngredientMap.addIngredient(NSSItem.create(stack), 1);
                                mapper.addConversion(1, normalizedSimpleStack, groupIngredientMap.getMap());
                            }
                        }
                        if (recipeOutput.func_190916_E() > 0) {
                            mapper.addConversion(recipeOutput.func_190916_E(), recipeOutputNorm, ingredientMap.getMap());
                            continue;
                        }
                        PECore.LOGGER.warn("Ignoring Recipe because outnumber <= 0: {} -> {}", new Object[]{ingredientMap.getMap().toString(), recipeOutput});
                    }
                    break;
                }
                PECore.LOGGER.warn("RecipeMapper {} failed to map Recipe {}", new Object[]{recipeMapper, iRecipe});
                break;
            }
            if (!handled) {
                if (this.canNotMap.contains(iRecipe.getClass())) continue;
                this.canNotMap.add(iRecipe.getClass());
                PECore.LOGGER.warn("Can not map Crafting Recipes with Type: {}", new Object[]{iRecipe.getClass().getName()});
                continue;
            }
            int count = 0;
            if (this.recipeCount.containsKey(iRecipe.getClass())) {
                count = this.recipeCount.get(iRecipe.getClass());
            }
            this.recipeCount.put(iRecipe.getClass(), ++count);
        }
        PECore.LOGGER.info("CraftingMapper Statistics:");
        for (Map.Entry entry : this.recipeCount.entrySet()) {
            PECore.LOGGER.info("Found {} Recipes of Type {}", new Object[]{entry.getValue(), entry.getKey()});
        }
    }

    @Override
    public String getName() {
        return "CraftingMapper";
    }

    @Override
    public String getDescription() {
        return "Add Conversions for Crafting Recipes gathered from net.minecraft.item.crafting.CraftingManager";
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    private static class PECustomRecipeMapper
    implements IRecipeMapper {
        private PECustomRecipeMapper() {
        }

        @Override
        public String getName() {
            return "PECustomRecipeMapper";
        }

        @Override
        public String getDescription() {
            return "Maps custom IRecipe's from ProjectE";
        }

        @Override
        public boolean canHandle(IRecipe recipe) {
            return recipe instanceof RecipeShapedKleinStar || recipe instanceof RecipeShapelessHidden;
        }

        @Override
        public Iterable<CraftingIngredients> getIngredientsFor(IRecipe recipe) {
            List<ItemStack> recipeItems = null;
            if (recipe instanceof RecipeShapedKleinStar) {
                recipeItems = Arrays.asList(((RecipeShapedKleinStar)recipe).recipeItems);
            } else if (recipe instanceof RecipeShapelessHidden) {
                recipeItems = ((RecipeShapelessHidden)recipe).getInput();
            }
            LinkedList<ItemStack> inputs = new LinkedList<ItemStack>();
            for (Object t : recipeItems) {
                if (t == null) continue;
                if (t instanceof ItemStack) {
                    ItemStack recipeItem = (ItemStack)t;
                    inputs.add(recipeItem);
                    continue;
                }
                PECore.LOGGER.warn("Illegal Ingredient in Crafting Recipe: {}", new Object[]{t});
            }
            return Collections.singletonList(new CraftingIngredients(inputs, new LinkedList<Iterable<ItemStack>>()));
        }
    }

    private static class VanillaOreRecipeMapper
    implements IRecipeMapper {
        private VanillaOreRecipeMapper() {
        }

        @Override
        public String getName() {
            return "VanillaOreRecipeMapper";
        }

        @Override
        public String getDescription() {
            return "Maps `IRecipe` crafting recipes that extend `ShapedOreRecipe` or `ShapelessOreRecipe`. This includes CraftingRecipes that use OreDictionary ingredients.";
        }

        @Override
        public boolean canHandle(IRecipe recipe) {
            return recipe instanceof ShapedOreRecipe || recipe instanceof ShapelessOreRecipe;
        }

        @Override
        public Iterable<CraftingIngredients> getIngredientsFor(IRecipe recipe) {
            NonNullList recipeItems = null;
            if (recipe instanceof ShapedOreRecipe) {
                recipeItems = Arrays.asList(((ShapedOreRecipe)recipe).getInput());
            } else if (recipe instanceof ShapelessOreRecipe) {
                recipeItems = ((ShapelessOreRecipe)recipe).getInput();
            }
            if (recipeItems == null) {
                return null;
            }
            ArrayList variableInputs = Lists.newArrayList();
            ArrayList fixedInputs = Lists.newArrayList();
            for (Object recipeItem : recipeItems) {
                if (recipeItem instanceof ItemStack) {
                    fixedInputs.add((ItemStack)recipeItem);
                    continue;
                }
                if (!(recipeItem instanceof Collection)) continue;
                LinkedList<ItemStack> recipeItemOptions = new LinkedList<ItemStack>();
                Collection recipeItemCollection = (Collection)recipeItem;
                if (recipeItemCollection.size() == 1) {
                    Object element = recipeItemCollection.iterator().next();
                    if (element instanceof ItemStack) {
                        fixedInputs.add(((ItemStack)element).func_77946_l());
                        continue;
                    }
                    PECore.LOGGER.warn("Can not map recipe {} because found {} instead of ItemStack", new Object[]{recipe, element});
                    return null;
                }
                for (Object option : recipeItemCollection) {
                    if (option instanceof ItemStack) {
                        recipeItemOptions.add(((ItemStack)option).func_77946_l());
                        continue;
                    }
                    PECore.LOGGER.warn("Can not map recipe {} because found {} instead of ItemStack", new Object[]{recipe, option});
                    return null;
                }
                variableInputs.add(recipeItemOptions);
            }
            return Collections.singletonList(new CraftingIngredients(fixedInputs, variableInputs));
        }
    }

    private static class VanillaRecipeMapper
    implements IRecipeMapper {
        private VanillaRecipeMapper() {
        }

        @Override
        public String getName() {
            return "VanillaRecipeMapper";
        }

        @Override
        public String getDescription() {
            return "Maps `IRecipe` crafting recipes that extend `ShapedRecipes` or `ShapelessRecipes`";
        }

        @Override
        public boolean canHandle(IRecipe recipe) {
            return recipe instanceof ShapedRecipes || recipe instanceof ShapelessRecipes;
        }

        @Override
        public Iterable<CraftingIngredients> getIngredientsFor(IRecipe recipe) {
            List recipeItems = null;
            if (recipe instanceof ShapedRecipes) {
                recipeItems = Arrays.asList(((ShapedRecipes)recipe).field_77574_d);
            } else if (recipe instanceof ShapelessRecipes) {
                recipeItems = ((ShapelessRecipes)recipe).field_77579_b;
            }
            LinkedList<ItemStack> inputs = new LinkedList<ItemStack>();
            for (Object o : recipeItems) {
                if (o == null) continue;
                if (o instanceof ItemStack) {
                    ItemStack recipeItem = (ItemStack)o;
                    inputs.add(recipeItem.func_77946_l());
                    continue;
                }
                PECore.LOGGER.warn("Illegal Ingredient in Crafting Recipe: {}", new Object[]{o});
            }
            return Collections.singletonList(new CraftingIngredients(inputs, new LinkedList<Iterable<ItemStack>>()));
        }
    }

    private static class CraftingIngredients {
        public final Iterable<ItemStack> fixedIngredients;
        public final Iterable<Iterable<ItemStack>> multiIngredients;

        public CraftingIngredients(Iterable<ItemStack> fixedIngredients, Iterable<Iterable<ItemStack>> multiIngredients) {
            this.fixedIngredients = fixedIngredients;
            this.multiIngredients = multiIngredients;
        }
    }

    public static interface IRecipeMapper {
        public String getName();

        public String getDescription();

        public boolean canHandle(IRecipe var1);

        public Iterable<CraftingIngredients> getIngredientsFor(IRecipe var1);
    }
}

