/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.emc.mappers.customConversions.json;

import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import moze_intel.projecte.emc.json.NormalizedSimpleStack;
import moze_intel.projecte.emc.mappers.customConversions.json.CustomConversion;
import moze_intel.projecte.emc.mappers.customConversions.json.FixedValues;

public class FixedValuesDeserializer
implements JsonDeserializer<FixedValues> {
    public FixedValues deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        FixedValues fixed = new FixedValues();
        JsonObject o = json.getAsJsonObject();
        for (Map.Entry entry : o.entrySet()) {
            if (((String)entry.getKey()).equals("before")) {
                fixed.setValueBefore = this.parseSetValueMap(((JsonElement)entry.getValue()).getAsJsonObject(), context);
                continue;
            }
            if (((String)entry.getKey()).equals("after")) {
                fixed.setValueAfter = this.parseSetValueMap(((JsonElement)entry.getValue()).getAsJsonObject(), context);
                continue;
            }
            if (((String)entry.getKey()).equals("conversion")) {
                fixed.conversion = (List)context.deserialize((JsonElement)((JsonElement)entry.getValue()).getAsJsonArray(), new TypeToken<List<CustomConversion>>(){}.getType());
                continue;
            }
            throw new JsonParseException(String.format("Can not parse \"%s\":%s in fixedValues", entry.getKey(), entry.getValue()));
        }
        return fixed;
    }

    private Map<NormalizedSimpleStack, Integer> parseSetValueMap(JsonObject o, JsonDeserializationContext context) {
        HashMap out = Maps.newHashMap();
        for (Map.Entry entry : o.entrySet()) {
            JsonPrimitive primitive = ((JsonElement)entry.getValue()).getAsJsonPrimitive();
            if (primitive.isNumber()) {
                out.put(context.deserialize((JsonElement)new JsonPrimitive((String)entry.getKey()), NormalizedSimpleStack.class), primitive.getAsInt());
                continue;
            }
            if (primitive.isString() && primitive.getAsString().toLowerCase().equals("free")) {
                out.put(context.deserialize((JsonElement)new JsonPrimitive((String)entry.getKey()), NormalizedSimpleStack.class), Integer.MIN_VALUE);
                continue;
            }
            throw new JsonParseException("Could not parse " + o + " into 'free' or integer.");
        }
        return out;
    }
}

