/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import moze_intel.projecte.api.PESounds;
import moze_intel.projecte.api.item.IPedestalItem;
import moze_intel.projecte.api.item.IProjectileShooter;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.entity.EntityWaterProjectile;
import moze_intel.projecte.gameObjs.items.ItemPE;
import moze_intel.projecte.gameObjs.tiles.DMPedestalTile;
import moze_intel.projecte.utils.ClientKeyHelper;
import moze_intel.projecte.utils.FluidHelper;
import moze_intel.projecte.utils.MathUtils;
import moze_intel.projecte.utils.PEKeybind;
import moze_intel.projecte.utils.PlayerHelper;
import net.minecraft.block.BlockCauldron;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Optional.Interface(iface="baubles.api.IBauble", modid="baubles")
public class EvertideAmulet
extends ItemPE
implements IProjectileShooter,
IBauble,
IPedestalItem {
    public EvertideAmulet() {
        this.func_77655_b("evertide_amulet");
        this.func_77625_d(1);
        this.setNoRepair();
        this.func_77642_a(this);
    }

    @Nonnull
    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing sideHit, float f1, float f2, float f3) {
        if (!world.field_72995_K && PlayerHelper.hasEditPermission((EntityPlayerMP)player, pos)) {
            TileEntity tile = world.func_175625_s(pos);
            if (tile != null && tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, sideHit)) {
                FluidHelper.tryFillTank(tile, FluidRegistry.WATER, sideHit, 1000);
            } else {
                IBlockState state = world.func_180495_p(pos);
                if (state.func_177230_c() == Blocks.field_150383_bp) {
                    int waterLevel = (Integer)state.func_177229_b((IProperty)BlockCauldron.field_176591_a);
                    if (waterLevel < 3) {
                        ((BlockCauldron)state.func_177230_c()).func_176590_a(world, pos, state, waterLevel + 1);
                    }
                } else {
                    world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, PESounds.WATER, SoundCategory.PLAYERS, 1.0f, 1.0f);
                    this.placeWater(world, player, pos.func_177972_a(sideHit));
                }
            }
        }
        return EnumActionResult.SUCCESS;
    }

    @Nonnull
    public ICapabilityProvider initCapabilities(final ItemStack stack, NBTTagCompound oldCapNbt) {
        return new ICapabilityProvider(){
            private final IFluidHandlerItem handler;
            {
                this.handler = new InfiniteFluidHandler(stack);
            }

            public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
                return capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY;
            }

            public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
                if (capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY) {
                    return (T)CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY.cast((Object)this.handler);
                }
                return null;
            }
        };
    }

    private void placeWater(World world, EntityPlayer player, BlockPos pos) {
        Material material = world.func_180495_p(pos).func_185904_a();
        if (world.field_73011_w.func_177500_n()) {
            world.func_184133_a(null, pos, SoundEvents.field_187646_bt, SoundCategory.PLAYERS, 0.5f, 2.6f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.8f);
            for (int l = 0; l < 8; ++l) {
                world.func_175688_a(EnumParticleTypes.SMOKE_LARGE, (double)pos.func_177958_n() + Math.random(), (double)pos.func_177956_o() + Math.random(), (double)pos.func_177952_p() + Math.random(), 0.0, 0.0, 0.0, new int[0]);
            }
        } else {
            if (!(world.field_72995_K || material.func_76220_a() || material.func_76224_d())) {
                world.func_175655_b(pos, true);
            }
            world.func_175656_a(pos, Blocks.field_150358_i.func_176223_P());
            PlayerHelper.checkedPlaceBlock((EntityPlayerMP)player, pos, Blocks.field_150358_i.func_176223_P());
        }
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int invSlot, boolean par5) {
        int z;
        int y;
        if (invSlot > 8 || !(entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        int x = (int)Math.floor(player.field_70165_t);
        BlockPos pos = new BlockPos(x, y = (int)(player.field_70163_u - player.func_70033_W()), z = (int)Math.floor(player.field_70161_v));
        if ((world.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150355_j || world.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150358_i) && world.func_175623_d(pos)) {
            if (!player.func_70093_af()) {
                player.field_70181_x = 0.0;
                player.field_70143_R = 0.0f;
                player.field_70122_E = true;
            }
            if (!world.field_72995_K && player.field_71075_bZ.func_75094_b() < 0.25f) {
                PlayerHelper.setPlayerWalkSpeed(player, 0.25f);
            }
        } else if (!world.field_72995_K) {
            if (player.func_70090_H()) {
                player.func_70050_g(300);
            }
            if (player.field_71075_bZ.func_75094_b() != 0.1f) {
                PlayerHelper.setPlayerWalkSpeed(player, 0.1f);
            }
        }
    }

    @Override
    public boolean shootProjectile(@Nonnull EntityPlayer player, @Nonnull ItemStack stack, EnumHand hand) {
        World world = player.func_130014_f_();
        if (!world.field_73011_w.func_177500_n()) {
            world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, PESounds.WATER, SoundCategory.PLAYERS, 1.0f, 1.0f);
            EntityWaterProjectile ent = new EntityWaterProjectile(world, player);
            ent.func_184538_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, 1.5f, 1.0f);
            world.func_72838_d((Entity)ent);
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> list, boolean par4) {
        list.add(I18n.func_135052_a((String)"pe.evertide.tooltip1", (Object[])new Object[]{ClientKeyHelper.getKeyName(PEKeybind.FIRE_PROJECTILE)}));
        list.add(I18n.func_135052_a((String)"pe.evertide.tooltip2", (Object[])new Object[0]));
        list.add(I18n.func_135052_a((String)"pe.evertide.tooltip3", (Object[])new Object[0]));
        list.add(I18n.func_135052_a((String)"pe.evertide.tooltip4", (Object[])new Object[0]));
    }

    @Optional.Method(modid="baubles")
    public BaubleType getBaubleType(ItemStack itemstack) {
        return BaubleType.AMULET;
    }

    @Optional.Method(modid="baubles")
    public void onWornTick(ItemStack stack, EntityLivingBase player) {
        this.func_77663_a(stack, player.func_130014_f_(), (Entity)player, 0, false);
    }

    @Optional.Method(modid="baubles")
    public void onEquipped(ItemStack itemstack, EntityLivingBase player) {
    }

    @Optional.Method(modid="baubles")
    public void onUnequipped(ItemStack itemstack, EntityLivingBase player) {
    }

    @Optional.Method(modid="baubles")
    public boolean canEquip(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }

    @Optional.Method(modid="baubles")
    public boolean canUnequip(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }

    @Override
    public void updateInPedestal(@Nonnull World world, @Nonnull BlockPos pos) {
        if (!world.field_72995_K && ProjectEConfig.pedestalCooldown.evertidePedCooldown != -1) {
            DMPedestalTile tile = (DMPedestalTile)world.func_175625_s(pos);
            if (tile.getActivityCooldown() == 0) {
                int i = (300 + world.field_73012_v.nextInt(600)) * 20;
                world.func_72912_H().func_76080_g(i);
                world.func_72912_H().func_76090_f(i);
                world.func_72912_H().func_76084_b(true);
                tile.setActivityCooldown(ProjectEConfig.pedestalCooldown.evertidePedCooldown);
            } else {
                tile.decrementActivityCooldown();
            }
        }
    }

    @Override
    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public List<String> getPedestalDescription() {
        ArrayList list = Lists.newArrayList();
        if (ProjectEConfig.pedestalCooldown.evertidePedCooldown != -1) {
            list.add(TextFormatting.BLUE + I18n.func_135052_a((String)"pe.evertide.pedestal1", (Object[])new Object[0]));
            list.add(TextFormatting.BLUE + I18n.func_135052_a((String)"pe.evertide.pedestal2", (Object[])new Object[]{MathUtils.tickToSecFormatted(ProjectEConfig.pedestalCooldown.evertidePedCooldown)}));
        }
        return list;
    }

    private static class InfiniteFluidHandler
    implements IFluidHandlerItem {
        private final ItemStack container;
        private final FluidTankProperties props = new FluidTankProperties(new FluidStack(FluidRegistry.WATER, 1000), 1000);

        InfiniteFluidHandler(ItemStack stack) {
            this.container = stack;
        }

        public IFluidTankProperties[] getTankProperties() {
            return new IFluidTankProperties[]{this.props};
        }

        public int fill(FluidStack resource, boolean doFill) {
            return 0;
        }

        @Nullable
        public FluidStack drain(FluidStack resource, boolean doDrain) {
            if (resource.getFluid() == FluidRegistry.WATER) {
                return resource.copy();
            }
            return null;
        }

        @Nullable
        public FluidStack drain(int maxDrain, boolean doDrain) {
            return new FluidStack(FluidRegistry.WATER, Math.min(maxDrain, 1000));
        }

        @Nonnull
        public ItemStack getContainer() {
            return this.container;
        }
    }
}

