/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items;

import baubles.api.BaubleType;
import baubles.api.BaublesApi;
import baubles.api.IBauble;
import baubles.api.cap.IBaublesItemHandler;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import moze_intel.projecte.api.item.IAlchBagItem;
import moze_intel.projecte.api.item.IAlchChestItem;
import moze_intel.projecte.api.item.IModeChanger;
import moze_intel.projecte.api.item.IPedestalItem;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.items.ItemPE;
import moze_intel.projecte.gameObjs.items.rings.RingToggle;
import moze_intel.projecte.gameObjs.tiles.AlchChestTile;
import moze_intel.projecte.gameObjs.tiles.DMPedestalTile;
import moze_intel.projecte.handlers.InternalTimers;
import moze_intel.projecte.utils.ItemHelper;
import moze_intel.projecte.utils.MathUtils;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

@Optional.Interface(iface="baubles.api.IBauble", modid="baubles")
public class RepairTalisman
extends ItemPE
implements IAlchBagItem,
IAlchChestItem,
IBauble,
IPedestalItem {
    public RepairTalisman() {
        this.func_77655_b("repair_talisman");
        this.func_77625_d(1);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int par4, boolean par5) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (world.field_72995_K || !(entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        ((InternalTimers)player.getCapability(InternalTimers.CAPABILITY, null)).activateRepair();
        if (((InternalTimers)player.getCapability(InternalTimers.CAPABILITY, null)).canRepair()) {
            this.repairAllItems(player);
        }
    }

    private void repairAllItems(EntityPlayer player) {
        IItemHandler inv = (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack invStack = inv.getStackInSlot(i);
            if (invStack.func_190926_b() || invStack.func_77973_b() instanceof IModeChanger || !invStack.func_77973_b().isRepairable() || invStack == player.func_184582_a(EntityEquipmentSlot.MAINHAND) && player.field_82175_bq || !ItemHelper.isDamageable(invStack) || invStack.func_77952_i() <= 0) continue;
            invStack.func_77964_b(invStack.func_77952_i() - 1);
        }
        if (Loader.isModLoaded((String)"baubles")) {
            this.baubleRepair(player);
        }
    }

    @Optional.Method(modid="baubles")
    public void baubleRepair(EntityPlayer player) {
        IBaublesItemHandler bInv = BaublesApi.getBaublesHandler((EntityPlayer)player);
        for (int i = 0; i < bInv.getSlots(); ++i) {
            ItemStack bInvStack = bInv.getStackInSlot(i);
            if (bInvStack.func_190926_b() || bInvStack.func_77973_b() instanceof IModeChanger || !bInvStack.func_77973_b().isRepairable() || !ItemHelper.isDamageable(bInvStack) || bInvStack.func_77952_i() <= 0) continue;
            bInvStack.func_77964_b(bInvStack.func_77952_i() - 1);
        }
    }

    @Optional.Method(modid="baubles")
    public BaubleType getBaubleType(ItemStack itemstack) {
        return BaubleType.BELT;
    }

    @Optional.Method(modid="baubles")
    public void onWornTick(ItemStack stack, EntityLivingBase player) {
        this.func_77663_a(stack, player.func_130014_f_(), (Entity)player, 0, false);
    }

    @Optional.Method(modid="baubles")
    public void onEquipped(ItemStack itemstack, EntityLivingBase player) {
    }

    @Optional.Method(modid="baubles")
    public void onUnequipped(ItemStack itemstack, EntityLivingBase player) {
    }

    @Optional.Method(modid="baubles")
    public boolean canEquip(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }

    @Optional.Method(modid="baubles")
    public boolean canUnequip(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }

    @Override
    public void updateInPedestal(@Nonnull World world, @Nonnull BlockPos pos) {
        if (!world.field_72995_K && ProjectEConfig.pedestalCooldown.repairPedCooldown != -1) {
            DMPedestalTile tile = (DMPedestalTile)world.func_175625_s(pos);
            if (tile.getActivityCooldown() == 0) {
                world.func_72872_a(EntityPlayerMP.class, tile.getEffectBounds()).forEach(this::repairAllItems);
                tile.setActivityCooldown(ProjectEConfig.pedestalCooldown.repairPedCooldown);
            } else {
                tile.decrementActivityCooldown();
            }
        }
    }

    @Override
    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public List<String> getPedestalDescription() {
        ArrayList list = Lists.newArrayList();
        if (ProjectEConfig.pedestalCooldown.repairPedCooldown != -1) {
            list.add(TextFormatting.BLUE + I18n.func_135052_a((String)"pe.repairtalisman.pedestal1", (Object[])new Object[0]));
            list.add(TextFormatting.BLUE + I18n.func_135052_a((String)"pe.repairtalisman.pedestal2", (Object[])new Object[]{MathUtils.tickToSecFormatted(ProjectEConfig.pedestalCooldown.repairPedCooldown)}));
        }
        return list;
    }

    @Override
    public void updateInAlchChest(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull ItemStack stack) {
        if (world.field_72995_K) {
            return;
        }
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        AlchChestTile tile = (AlchChestTile)world.func_175625_s(pos);
        byte coolDown = stack.func_77978_p().func_74771_c("Cooldown");
        if (coolDown > 0) {
            stack.func_77978_p().func_74774_a("Cooldown", (byte)(coolDown - 1));
        } else {
            boolean hasAction = false;
            IItemHandler inv = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            for (int i = 0; i < inv.getSlots(); ++i) {
                ItemStack invStack = inv.getStackInSlot(i);
                if (invStack.func_190926_b() || invStack.func_77973_b() instanceof RingToggle || !invStack.func_77973_b().isRepairable() || !ItemHelper.isDamageable(invStack) || invStack.func_77952_i() <= 0) continue;
                invStack.func_77964_b(invStack.func_77952_i() - 1);
                if (hasAction) continue;
                hasAction = true;
            }
            if (hasAction) {
                stack.func_77978_p().func_74774_a("Cooldown", (byte)19);
                tile.func_70296_d();
            }
        }
    }

    @Override
    public boolean updateInAlchBag(@Nonnull IItemHandler inv, @Nonnull EntityPlayer player, @Nonnull ItemStack stack) {
        byte coolDown;
        if (player.func_130014_f_().field_72995_K) {
            return false;
        }
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if ((coolDown = stack.func_77978_p().func_74771_c("Cooldown")) > 0) {
            stack.func_77978_p().func_74774_a("Cooldown", (byte)(coolDown - 1));
        } else {
            boolean hasAction = false;
            for (int i = 0; i < inv.getSlots(); ++i) {
                ItemStack invStack = inv.getStackInSlot(i);
                if (invStack.func_190926_b() || invStack.func_77973_b() instanceof RingToggle || !invStack.func_77973_b().isRepairable() || !ItemHelper.isDamageable(invStack) || invStack.func_77952_i() <= 0) continue;
                invStack.func_77964_b(invStack.func_77952_i() - 1);
                if (hasAction) continue;
                hasAction = true;
            }
            if (hasAction) {
                stack.func_77978_p().func_74774_a("Cooldown", (byte)19);
                return true;
            }
        }
        return false;
    }
}

