/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items.rings;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import moze_intel.projecte.api.item.IAlchBagItem;
import moze_intel.projecte.api.item.IAlchChestItem;
import moze_intel.projecte.api.item.IPedestalItem;
import moze_intel.projecte.gameObjs.items.rings.RingToggle;
import moze_intel.projecte.gameObjs.tiles.AlchChestTile;
import moze_intel.projecte.gameObjs.tiles.DMPedestalTile;
import moze_intel.projecte.utils.ItemHelper;
import moze_intel.projecte.utils.WorldHelper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.InvWrapper;

@Optional.Interface(iface="baubles.api.IBauble", modid="baubles")
public class BlackHoleBand
extends RingToggle
implements IAlchBagItem,
IAlchChestItem,
IBauble,
IPedestalItem {
    public BlackHoleBand() {
        super("black_hole");
        this.setNoRepair();
    }

    @Nonnull
    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        BlockPos fluidPos = pos.func_177972_a(facing);
        IBlockState state = world.func_180495_p(fluidPos);
        if (state.func_177230_c() instanceof BlockFluidBase || state.func_177230_c() instanceof BlockLiquid) {
            if (!world.field_72995_K) {
                world.func_175698_g(fluidPos);
                Fluid f = FluidRegistry.lookupFluidForBlock((Block)state.func_177230_c());
                if (f != null) {
                    world.func_184133_a(null, pos, f.getFillSound(world, fluidPos), SoundCategory.BLOCKS, 1.0f, 1.0f);
                }
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, @Nonnull EnumHand hand) {
        if (!world.field_72995_K) {
            this.changeMode(player, player.func_184586_b(hand), hand);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }

    @Override
    public void func_77663_a(ItemStack stack, World world, Entity entity, int par4, boolean par5) {
        if (stack.func_77952_i() != 1 || !(entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        AxisAlignedBB bBox = player.func_174813_aQ().func_72314_b(7.0, 7.0, 7.0);
        List itemList = world.func_72872_a(EntityItem.class, bBox);
        for (EntityItem item : itemList) {
            if (!ItemHelper.hasSpace((NonNullList<ItemStack>)player.field_71071_by.field_70462_a, item.func_92059_d())) continue;
            WorldHelper.gravitateEntityTowards((Entity)item, player.field_70165_t, player.field_70163_u, player.field_70161_v);
        }
    }

    @Optional.Method(modid="baubles")
    public BaubleType getBaubleType(ItemStack itemstack) {
        return BaubleType.RING;
    }

    @Optional.Method(modid="baubles")
    public void onWornTick(ItemStack stack, EntityLivingBase player) {
        this.func_77663_a(stack, player.func_130014_f_(), (Entity)player, 0, false);
    }

    @Optional.Method(modid="baubles")
    public void onEquipped(ItemStack itemstack, EntityLivingBase player) {
    }

    @Optional.Method(modid="baubles")
    public void onUnequipped(ItemStack itemstack, EntityLivingBase player) {
    }

    @Optional.Method(modid="baubles")
    public boolean canEquip(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }

    @Optional.Method(modid="baubles")
    public boolean canUnequip(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }

    @Override
    public void updateInPedestal(@Nonnull World world, @Nonnull BlockPos pos) {
        DMPedestalTile tile = (DMPedestalTile)world.func_175625_s(pos);
        if (tile != null) {
            List list = world.func_72872_a(EntityItem.class, tile.getEffectBounds());
            for (EntityItem item : list) {
                WorldHelper.gravitateEntityTowards((Entity)item, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
                if (world.field_72995_K || !(item.func_70092_e((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5) < 1.21) || item.field_70128_L) continue;
                this.suckDumpItem(item, tile);
            }
        }
    }

    private void suckDumpItem(EntityItem item, DMPedestalTile tile) {
        Map<EnumFacing, TileEntity> map = WorldHelper.getAdjacentTileEntitiesMapped(tile.func_145831_w(), tile);
        for (Map.Entry<EnumFacing, TileEntity> e : map.entrySet()) {
            IItemHandler inv = null;
            if (e.getValue().hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, e.getKey())) {
                inv = (IItemHandler)e.getValue().getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, e.getKey());
            } else if (e.getValue() instanceof IInventory) {
                inv = new InvWrapper((IInventory)e.getValue());
            }
            ItemStack result = ItemHandlerHelper.insertItemStacked(inv, (ItemStack)item.func_92059_d(), (boolean)false);
            if (result.func_190926_b()) {
                item.func_70106_y();
                return;
            }
            item.func_92058_a(result);
        }
    }

    @Override
    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public List<String> getPedestalDescription() {
        return Lists.newArrayList((Object[])new String[]{TextFormatting.BLUE + I18n.func_135052_a((String)"pe.bhb.pedestal1", (Object[])new Object[0]), TextFormatting.BLUE + I18n.func_135052_a((String)"pe.bhb.pedestal2", (Object[])new Object[0])});
    }

    @Override
    public void updateInAlchChest(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull ItemStack stack) {
        AlchChestTile tile = (AlchChestTile)world.func_175625_s(pos);
        if (stack.func_77952_i() == 1) {
            AxisAlignedBB aabb = new AxisAlignedBB((double)(tile.func_174877_v().func_177958_n() - 5), (double)(tile.func_174877_v().func_177956_o() - 5), (double)(tile.func_174877_v().func_177952_p() - 5), (double)(tile.func_174877_v().func_177958_n() + 5), (double)(tile.func_174877_v().func_177956_o() + 5), (double)(tile.func_174877_v().func_177952_p() + 5));
            double centeredX = (double)tile.func_174877_v().func_177958_n() + 0.5;
            double centeredY = (double)tile.func_174877_v().func_177956_o() + 0.5;
            double centeredZ = (double)tile.func_174877_v().func_177952_p() + 0.5;
            for (EntityItem e : tile.func_145831_w().func_72872_a(EntityItem.class, aabb)) {
                WorldHelper.gravitateEntityTowards((Entity)e, centeredX, centeredY, centeredZ);
                if (e.func_130014_f_().field_72995_K || e.field_70128_L || !(e.func_70092_e(centeredX, centeredY, centeredZ) < 1.21)) continue;
                ItemStack result = ItemHandlerHelper.insertItemStacked((IItemHandler)((IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)), (ItemStack)e.func_92059_d(), (boolean)false);
                if (result.func_190926_b()) {
                    e.func_92058_a(result);
                    continue;
                }
                e.func_70106_y();
            }
        }
    }

    @Override
    public boolean updateInAlchBag(@Nonnull IItemHandler inv, @Nonnull EntityPlayer player, @Nonnull ItemStack stack) {
        if (stack.func_77952_i() == 1) {
            for (EntityItem e : player.func_130014_f_().func_72872_a(EntityItem.class, player.func_174813_aQ().func_72314_b(5.0, 5.0, 5.0))) {
                WorldHelper.gravitateEntityTowards((Entity)e, player.field_70165_t, player.field_70163_u, player.field_70161_v);
            }
        }
        return false;
    }
}

