/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.impl;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import moze_intel.projecte.api.proxy.IConversionProxy;
import moze_intel.projecte.emc.IngredientMap;
import moze_intel.projecte.emc.json.NSSFake;
import moze_intel.projecte.emc.json.NSSFluid;
import moze_intel.projecte.emc.json.NSSItem;
import moze_intel.projecte.emc.json.NSSOreDictionary;
import moze_intel.projecte.emc.json.NormalizedSimpleStack;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import org.apache.commons.lang3.ClassUtils;

public class ConversionProxyImpl
implements IConversionProxy {
    public static final ConversionProxyImpl instance = new ConversionProxyImpl();
    final Map<Object, NormalizedSimpleStack> fakes = Maps.newHashMap();
    public final Map<String, List<APIConversion>> storedConversions = Maps.newHashMap();

    @Override
    public void addConversion(int amount, @Nonnull Object output, @Nonnull Map<Object, Integer> ingredients) {
        List<Object> conversionsFromMod;
        NormalizedSimpleStack nssOut = this.objectToNSS(output);
        IngredientMap<NormalizedSimpleStack> ingredientMap = new IngredientMap<NormalizedSimpleStack>();
        for (Map.Entry<Object, Integer> entry : ingredients.entrySet()) {
            NormalizedSimpleStack nss = this.objectToNSS(entry.getKey());
            ingredientMap.addIngredient(nss, entry.getValue());
        }
        String modId = this.getActiveMod();
        if (this.storedConversions.containsKey(modId)) {
            conversionsFromMod = this.storedConversions.get(modId);
        } else {
            conversionsFromMod = Lists.newLinkedList();
            this.storedConversions.put(modId, (List<APIConversion>)conversionsFromMod);
        }
        conversionsFromMod.add(new APIConversion(amount, nssOut, ImmutableMap.copyOf(ingredientMap.getMap())));
    }

    public NormalizedSimpleStack objectToNSS(Object object) {
        if (object instanceof Block) {
            return this.objectToNSS(new ItemStack((Block)object));
        }
        if (object instanceof Item) {
            return this.objectToNSS(new ItemStack((Item)object));
        }
        if (object instanceof ItemStack) {
            return NSSItem.create((ItemStack)object);
        }
        if (object instanceof FluidStack) {
            return NSSFluid.create(((FluidStack)object).getFluid());
        }
        if (object instanceof String) {
            return NSSOreDictionary.create((String)object);
        }
        if (object != null && object.getClass().equals(Object.class)) {
            if (this.fakes.containsKey(object)) {
                return this.fakes.get(object);
            }
            NormalizedSimpleStack nss = NSSFake.create("" + this.fakes.size() + " by " + this.getActiveMod());
            this.fakes.put(object, nss);
            return nss;
        }
        throw new IllegalArgumentException("Can not turn " + object + " (" + ClassUtils.getPackageCanonicalName((Object)object, (String)"") + ") into NormalizedSimpleStack. need ItemStack, FluidStack, String or 'Object'");
    }

    private String getActiveMod() {
        ModContainer activeMod = Loader.instance().activeModContainer();
        return activeMod == null ? "unknown Mod" : activeMod.getModId();
    }

    public static class APIConversion {
        public final int amount;
        public final NormalizedSimpleStack output;
        public final ImmutableMap<NormalizedSimpleStack, Integer> ingredients;

        private APIConversion(int amount, NormalizedSimpleStack output, ImmutableMap<NormalizedSimpleStack, Integer> ingredients) {
            this.amount = amount;
            this.output = output;
            this.ingredients = ingredients;
        }
    }
}

