/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.integration.jei.world_transmute;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import moze_intel.projecte.utils.ItemHelper;
import moze_intel.projecte.utils.WorldTransmutations;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class WorldTransmuteRecipeWrapper
implements IRecipeWrapper {
    private final WorldTransmutations.Entry entry;

    public WorldTransmuteRecipeWrapper(WorldTransmutations.Entry recipe) {
        this.entry = recipe;
    }

    public void getIngredients(@Nonnull IIngredients ingredients) {
        IBlockState in = this.entry.input;
        Fluid f = FluidRegistry.lookupFluidForBlock((Block)in.func_177230_c());
        if (f != null) {
            ingredients.setInput(FluidStack.class, (Object)new FluidStack(f, 1000));
        } else {
            ingredients.setInput(ItemStack.class, (Object)ItemHelper.stateToStack(in, 1));
        }
        IBlockState out = (IBlockState)this.entry.outputs.getLeft();
        IBlockState altOut = (IBlockState)this.entry.outputs.getRight();
        ArrayList<ItemStack> outItems = new ArrayList<ItemStack>(2);
        ArrayList<FluidStack> outFluids = new ArrayList<FluidStack>(2);
        f = FluidRegistry.lookupFluidForBlock((Block)out.func_177230_c());
        if (f != null) {
            outFluids.add(new FluidStack(f, 1000));
        } else {
            outItems.add(ItemHelper.stateToStack(out, 1));
        }
        if (altOut != null) {
            f = FluidRegistry.lookupFluidForBlock((Block)altOut.func_177230_c());
            if (f != null) {
                outFluids.add(new FluidStack(f, 1000));
            } else {
                outItems.add(ItemHelper.stateToStack(altOut, 1));
            }
        }
        ingredients.setOutputs(ItemStack.class, outItems);
        ingredients.setOutputs(FluidStack.class, outFluids);
    }

    public void drawInfo(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
    }

    @Nonnull
    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        return ImmutableList.of();
    }

    public boolean handleClick(@Nonnull Minecraft minecraft, int mouseX, int mouseY, int mouseButton) {
        return false;
    }
}

