/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.network.commands;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import moze_intel.projecte.network.commands.ChangelogCMD;
import moze_intel.projecte.network.commands.ClearKnowledgeCMD;
import moze_intel.projecte.network.commands.ProjectEBaseCMD;
import moze_intel.projecte.network.commands.ReloadEmcCMD;
import moze_intel.projecte.network.commands.RemoveEmcCMD;
import moze_intel.projecte.network.commands.ResetEmcCMD;
import moze_intel.projecte.network.commands.SetEmcCMD;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class ProjectECMD
extends ProjectEBaseCMD {
    private static final List<String> commands = Lists.newArrayList((Object[])new String[]{"changelog", "clearKnowledge", "setEMC", "reloadEMC", "removeEMC", "resetEMC"});
    private final ChangelogCMD changelogcmd = new ChangelogCMD();
    private final ReloadEmcCMD reloademccmd = new ReloadEmcCMD();
    private final SetEmcCMD setemccmd = new SetEmcCMD();
    private final RemoveEmcCMD removeemccmd = new RemoveEmcCMD();
    private final ResetEmcCMD resetemccmd = new ResetEmcCMD();
    private final ClearKnowledgeCMD clearknowledgecmd = new ClearKnowledgeCMD();

    @Override
    @Nonnull
    public String func_71517_b() {
        return "projecte";
    }

    @Override
    @Nonnull
    public String func_71518_a(@Nonnull ICommandSender sender) {
        return "pe.command.main.usage";
    }

    @Override
    public int func_82362_a() {
        return 0;
    }

    @Nonnull
    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] params, BlockPos pos) {
        if (params.length == 1) {
            return Lists.newArrayList((Iterable)Iterables.filter(commands, (Predicate)new LowerCasePrefixPredicate(params[0])));
        }
        return ImmutableList.of();
    }

    @Override
    public void func_184881_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender, @Nonnull String[] params) throws CommandException {
        String subName;
        if (params.length < 1) {
            this.sendError(sender, (ITextComponent)new TextComponentTranslation("pe.command.main.usage", new Object[0]));
            return;
        }
        String[] relayparams = new String[]{};
        if (params.length > 1) {
            relayparams = Arrays.copyOfRange(params, 1, params.length);
        }
        if ("setemc".equals(subName = params[0].toLowerCase(Locale.ROOT))) {
            if (this.setemccmd.func_184882_a(server, sender)) {
                this.setemccmd.func_184881_a(server, sender, relayparams);
            } else {
                this.sendError(sender, (ITextComponent)new TextComponentTranslation("commands.generic.permission", new Object[0]));
            }
        } else if ("resetemc".equals(subName)) {
            if (this.resetemccmd.func_184882_a(server, sender)) {
                this.resetemccmd.func_184881_a(server, sender, relayparams);
            } else {
                this.sendError(sender, (ITextComponent)new TextComponentTranslation("commands.generic.permission", new Object[0]));
            }
        } else if ("removeemc".equals(subName)) {
            if (this.removeemccmd.func_184882_a(server, sender)) {
                this.removeemccmd.func_184881_a(server, sender, relayparams);
            } else {
                this.sendError(sender, (ITextComponent)new TextComponentTranslation("commands.generic.permission", new Object[0]));
            }
        } else if ("reloademc".equals(subName)) {
            if (this.reloademccmd.func_184882_a(server, sender)) {
                this.reloademccmd.func_184881_a(server, sender, relayparams);
            } else {
                this.sendError(sender, (ITextComponent)new TextComponentTranslation("commands.generic.permission", new Object[0]));
            }
        } else if ("clearknowledge".equals(subName)) {
            if (this.clearknowledgecmd.func_184882_a(server, sender)) {
                this.clearknowledgecmd.func_184881_a(server, sender, relayparams);
            } else {
                this.sendError(sender, (ITextComponent)new TextComponentTranslation("commands.generic.permission", new Object[0]));
            }
        } else if ("changelog".equals(subName)) {
            if (this.changelogcmd.func_184882_a(server, sender)) {
                this.changelogcmd.func_184881_a(server, sender, relayparams);
            } else {
                this.sendError(sender, (ITextComponent)new TextComponentTranslation("commands.generic.permission", new Object[0]));
            }
        }
    }

    private static class LowerCasePrefixPredicate
    implements Predicate<String> {
        private final String prefix;

        public LowerCasePrefixPredicate(String prefix) {
            this.prefix = prefix;
        }

        public boolean apply(String input) {
            return input.toLowerCase(Locale.ROOT).startsWith(this.prefix.toLowerCase(Locale.ROOT));
        }
    }
}

