/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import moze_intel.projecte.api.ProjectEAPI;
import moze_intel.projecte.api.capabilities.IKnowledgeProvider;
import moze_intel.projecte.api.event.PlayerKnowledgeChangeEvent;
import moze_intel.projecte.gameObjs.ObjHandler;
import moze_intel.projecte.network.PacketHandler;
import moze_intel.projecte.network.packets.KnowledgeSyncPKT;
import moze_intel.projecte.playerData.Transmutation;
import moze_intel.projecte.utils.EMCHelper;
import moze_intel.projecte.utils.ItemHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public final class KnowledgeImpl {
    public static void init() {
        CapabilityManager.INSTANCE.register(IKnowledgeProvider.class, (Capability.IStorage)new Capability.IStorage<IKnowledgeProvider>(){

            public NBTTagCompound writeNBT(Capability<IKnowledgeProvider> capability, IKnowledgeProvider instance, EnumFacing side) {
                return (NBTTagCompound)instance.serializeNBT();
            }

            public void readNBT(Capability<IKnowledgeProvider> capability, IKnowledgeProvider instance, EnumFacing side, NBTBase nbt) {
                if (nbt instanceof NBTTagCompound) {
                    instance.deserializeNBT((NBTBase)((NBTTagCompound)nbt));
                }
            }
        }, () -> new DefaultImpl(null));
    }

    private KnowledgeImpl() {
    }

    public static class Provider
    implements ICapabilitySerializable<NBTTagCompound> {
        public static final ResourceLocation NAME = new ResourceLocation("projecte", "knowledge");
        private final DefaultImpl knowledge;

        public Provider(EntityPlayer player) {
            this.knowledge = new DefaultImpl(player);
        }

        public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing facing) {
            return capability == ProjectEAPI.KNOWLEDGE_CAPABILITY;
        }

        public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
            if (capability == ProjectEAPI.KNOWLEDGE_CAPABILITY) {
                return (T)ProjectEAPI.KNOWLEDGE_CAPABILITY.cast((Object)this.knowledge);
            }
            return null;
        }

        public NBTTagCompound serializeNBT() {
            return this.knowledge.serializeNBT();
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            this.knowledge.deserializeNBT(nbt);
        }
    }

    private static class DefaultImpl
    implements IKnowledgeProvider {
        @Nullable
        private final EntityPlayer player;
        private final List<ItemStack> knowledge = new ArrayList<ItemStack>();
        private final IItemHandlerModifiable inputLocks = new ItemStackHandler(9);
        private double emc = 0.0;
        private boolean fullKnowledge = false;

        private DefaultImpl(EntityPlayer player) {
            this.player = player;
        }

        private void fireChangedEvent() {
            if (this.player != null && !this.player.field_70170_p.field_72995_K) {
                MinecraftForge.EVENT_BUS.post((Event)new PlayerKnowledgeChangeEvent(this.player));
            }
        }

        @Override
        public boolean hasFullKnowledge() {
            return this.fullKnowledge;
        }

        @Override
        public void setFullKnowledge(boolean fullKnowledge) {
            boolean changed = this.fullKnowledge != fullKnowledge;
            this.fullKnowledge = fullKnowledge;
            if (changed) {
                this.fireChangedEvent();
            }
        }

        @Override
        public void clearKnowledge() {
            this.knowledge.clear();
            this.fullKnowledge = false;
            this.fireChangedEvent();
        }

        @Override
        public boolean hasKnowledge(@Nonnull ItemStack stack) {
            if (stack.func_190926_b()) {
                return false;
            }
            if (this.fullKnowledge) {
                return true;
            }
            for (ItemStack s : this.knowledge) {
                if (!ItemHelper.basicAreStacksEqual(s, stack)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean addKnowledge(@Nonnull ItemStack stack) {
            if (this.fullKnowledge) {
                return false;
            }
            if (stack.func_77973_b() == ObjHandler.tome) {
                if (!this.hasKnowledge(stack)) {
                    this.knowledge.add(stack);
                }
                this.fullKnowledge = true;
                this.fireChangedEvent();
                return true;
            }
            if (!this.hasKnowledge(stack)) {
                this.knowledge.add(stack);
                this.fireChangedEvent();
                return true;
            }
            return false;
        }

        @Override
        public boolean removeKnowledge(@Nonnull ItemStack stack) {
            boolean removed = false;
            if (stack.func_77973_b() == ObjHandler.tome) {
                this.fullKnowledge = false;
                removed = true;
            }
            if (this.fullKnowledge) {
                return false;
            }
            Iterator<ItemStack> iter = this.knowledge.iterator();
            while (iter.hasNext()) {
                if (!ItemStack.func_77989_b((ItemStack)stack, (ItemStack)iter.next())) continue;
                iter.remove();
                removed = true;
            }
            if (removed) {
                this.fireChangedEvent();
            }
            return removed;
        }

        @Override
        @Nonnull
        public List<ItemStack> getKnowledge() {
            return this.fullKnowledge ? Transmutation.getCachedTomeKnowledge() : Collections.unmodifiableList(this.knowledge);
        }

        @Nonnull
        public IItemHandlerModifiable getInputAndLocks() {
            return this.inputLocks;
        }

        @Override
        public double getEmc() {
            return this.emc;
        }

        @Override
        public void setEmc(double emc) {
            this.emc = emc;
        }

        @Override
        public void sync(@Nonnull EntityPlayerMP player) {
            PacketHandler.sendTo(new KnowledgeSyncPKT(this.serializeNBT()), player);
        }

        public NBTTagCompound serializeNBT() {
            NBTTagCompound properties = new NBTTagCompound();
            properties.func_74780_a("transmutationEmc", this.emc);
            NBTTagList knowledgeWrite = new NBTTagList();
            for (ItemStack i : this.knowledge) {
                NBTTagCompound tag = i.func_77955_b(new NBTTagCompound());
                knowledgeWrite.func_74742_a((NBTBase)tag);
            }
            properties.func_74782_a("knowledge", (NBTBase)knowledgeWrite);
            properties.func_74782_a("inputlock", CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.writeNBT((Object)this.inputLocks, null));
            properties.func_74757_a("fullknowledge", this.fullKnowledge);
            return properties;
        }

        public void deserializeNBT(NBTTagCompound properties) {
            int i;
            this.emc = properties.func_74769_h("transmutationEmc");
            NBTTagList list = properties.func_150295_c("knowledge", 10);
            for (i = 0; i < list.func_74745_c(); ++i) {
                ItemStack item = new ItemStack(list.func_150305_b(i));
                if (item.func_190926_b()) continue;
                this.knowledge.add(item);
            }
            this.pruneStaleKnowledge();
            this.pruneDuplicateKnowledge();
            for (i = 0; i < this.inputLocks.getSlots(); ++i) {
                this.inputLocks.setStackInSlot(i, ItemStack.field_190927_a);
            }
            CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.readNBT((Object)this.inputLocks, null, (NBTBase)properties.func_150295_c("inputlock", 10));
            this.fullKnowledge = properties.func_74767_n("fullknowledge");
        }

        private void pruneDuplicateKnowledge() {
            ItemHelper.compactItemListNoStacksize(this.knowledge);
            for (ItemStack s : this.knowledge) {
                if (s.func_190916_E() <= 1) continue;
                s.func_190920_e(1);
            }
        }

        private void pruneStaleKnowledge() {
            this.knowledge.removeIf(stack -> !EMCHelper.doesItemHaveEmc(stack));
        }
    }
}

