/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCarpet;
import net.minecraft.block.BlockColored;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockNewLeaf;
import net.minecraft.block.BlockNewLog;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockPumpkin;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.BlockStaticLiquid;
import net.minecraft.block.BlockStone;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public final class WorldTransmutations {
    private static final List<Entry> ENTRIES;

    private static IBlockState cyclePropertyBackwards(IBlockState state, IProperty<?> property) {
        IBlockState result = state;
        for (int i = 0; i < property.func_177700_c().size() - 1; ++i) {
            result = result.func_177231_a(property);
        }
        return result;
    }

    public static IBlockState getWorldTransmutation(World world, BlockPos pos, boolean isSneaking) {
        return WorldTransmutations.getWorldTransmutation(world.func_180495_p(pos), isSneaking);
    }

    public static IBlockState getWorldTransmutation(IBlockState current, boolean isSneaking) {
        for (Entry e : ENTRIES) {
            if (e.input != current) continue;
            Pair<IBlockState, IBlockState> result = e.outputs;
            return isSneaking ? (result.getRight() == null ? (IBlockState)result.getLeft() : (IBlockState)result.getRight()) : (IBlockState)result.getLeft();
        }
        return null;
    }

    public static List<Entry> getWorldTransmutations() {
        return ENTRIES;
    }

    public static void register(IBlockState from, IBlockState result, IBlockState altResult) {
        ENTRIES.add(new Entry(from, (Pair<IBlockState, IBlockState>)ImmutablePair.of((Object)result, (Object)altResult)));
    }

    private static void registerDefault(Block from, Block result, Block altResult) {
        WorldTransmutations.register(from.func_176223_P(), result.func_176223_P(), altResult == null ? null : altResult.func_176223_P());
    }

    static {
        IBlockState state;
        ENTRIES = new ArrayList<Entry>();
        WorldTransmutations.registerDefault(Blocks.field_150348_b, Blocks.field_150347_e, (Block)Blocks.field_150349_c);
        WorldTransmutations.registerDefault(Blocks.field_150347_e, Blocks.field_150348_b, (Block)Blocks.field_150349_c);
        WorldTransmutations.registerDefault((Block)Blocks.field_150349_c, (Block)Blocks.field_150354_m, Blocks.field_150347_e);
        WorldTransmutations.registerDefault(Blocks.field_150346_d, (Block)Blocks.field_150354_m, Blocks.field_150347_e);
        WorldTransmutations.registerDefault((Block)Blocks.field_150354_m, (Block)Blocks.field_150349_c, Blocks.field_150347_e);
        WorldTransmutations.registerDefault(Blocks.field_150351_n, Blocks.field_150322_A, null);
        WorldTransmutations.registerDefault(Blocks.field_150322_A, Blocks.field_150351_n, null);
        WorldTransmutations.registerDefault((Block)Blocks.field_150355_j, Blocks.field_150432_aD, null);
        WorldTransmutations.registerDefault(Blocks.field_150432_aD, (Block)Blocks.field_150355_j, null);
        WorldTransmutations.registerDefault((Block)Blocks.field_150353_l, Blocks.field_150343_Z, null);
        WorldTransmutations.registerDefault(Blocks.field_150343_Z, (Block)Blocks.field_150353_l, null);
        WorldTransmutations.register(Blocks.field_150440_ba.func_176223_P(), Blocks.field_150423_aK.func_176223_P().func_177226_a((IProperty)BlockPumpkin.field_185512_D, (Comparable)EnumFacing.SOUTH), null);
        for (EnumFacing enumFacing : EnumFacing.field_176754_o) {
            WorldTransmutations.register(Blocks.field_150423_aK.func_176223_P().func_177226_a((IProperty)BlockPumpkin.field_185512_D, (Comparable)enumFacing), Blocks.field_150440_ba.func_176223_P(), null);
        }
        for (IBlockState s : Blocks.field_150364_r.func_176194_O().func_177619_a()) {
            if (s.func_177229_b((IProperty)BlockOldLog.field_176301_b) == BlockPlanks.EnumType.OAK) {
                WorldTransmutations.register(s, s.func_177231_a((IProperty)BlockOldLog.field_176301_b), Blocks.field_150363_s.func_176223_P().func_177226_a((IProperty)BlockNewLog.field_176300_b, (Comparable)BlockPlanks.EnumType.DARK_OAK).func_177226_a((IProperty)BlockNewLog.field_176299_a, s.func_177229_b((IProperty)BlockOldLog.field_176299_a)));
                continue;
            }
            if (s.func_177229_b((IProperty)BlockOldLog.field_176301_b) == BlockPlanks.EnumType.JUNGLE) {
                WorldTransmutations.register(s, Blocks.field_150363_s.func_176223_P().func_177226_a((IProperty)BlockNewLog.field_176300_b, (Comparable)BlockPlanks.EnumType.ACACIA).func_177226_a((IProperty)BlockNewLog.field_176299_a, s.func_177229_b((IProperty)BlockOldLog.field_176299_a)), WorldTransmutations.cyclePropertyBackwards(s, BlockOldLog.field_176301_b));
                continue;
            }
            WorldTransmutations.register(s, s.func_177231_a((IProperty)BlockOldLog.field_176301_b), WorldTransmutations.cyclePropertyBackwards(s, BlockOldLog.field_176301_b));
        }
        for (IBlockState s : Blocks.field_150362_t.func_176194_O().func_177619_a()) {
            if (s.func_177229_b((IProperty)BlockOldLeaf.field_176239_P) == BlockPlanks.EnumType.OAK) {
                WorldTransmutations.register(s, s.func_177231_a((IProperty)BlockOldLeaf.field_176239_P), Blocks.field_150361_u.func_176223_P().func_177226_a((IProperty)BlockNewLeaf.field_176240_P, (Comparable)BlockPlanks.EnumType.DARK_OAK).func_177226_a((IProperty)BlockNewLeaf.field_176236_b, s.func_177229_b((IProperty)BlockOldLeaf.field_176236_b)).func_177226_a((IProperty)BlockNewLeaf.field_176237_a, s.func_177229_b((IProperty)BlockOldLeaf.field_176237_a)));
                continue;
            }
            if (s.func_177229_b((IProperty)BlockOldLeaf.field_176239_P) == BlockPlanks.EnumType.JUNGLE) {
                WorldTransmutations.register(s, Blocks.field_150361_u.func_176223_P().func_177226_a((IProperty)BlockNewLeaf.field_176240_P, (Comparable)BlockPlanks.EnumType.ACACIA).func_177226_a((IProperty)BlockNewLeaf.field_176236_b, s.func_177229_b((IProperty)BlockNewLeaf.field_176236_b)).func_177226_a((IProperty)BlockNewLeaf.field_176237_a, s.func_177229_b((IProperty)BlockOldLeaf.field_176237_a)), WorldTransmutations.cyclePropertyBackwards(s, BlockOldLeaf.field_176239_P));
                continue;
            }
            WorldTransmutations.register(s, s.func_177231_a((IProperty)BlockOldLeaf.field_176239_P), WorldTransmutations.cyclePropertyBackwards(s, BlockOldLeaf.field_176239_P));
        }
        for (IBlockState s : Blocks.field_150363_s.func_176194_O().func_177619_a()) {
            if (s.func_177229_b((IProperty)BlockNewLog.field_176300_b) == BlockPlanks.EnumType.ACACIA) {
                WorldTransmutations.register(s, s.func_177231_a((IProperty)BlockNewLog.field_176300_b), Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.JUNGLE).func_177226_a((IProperty)BlockOldLog.field_176299_a, s.func_177229_b((IProperty)BlockNewLog.field_176299_a)));
                continue;
            }
            if (s.func_177229_b((IProperty)BlockNewLog.field_176300_b) == BlockPlanks.EnumType.DARK_OAK) {
                WorldTransmutations.register(s, Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.OAK).func_177226_a((IProperty)BlockOldLog.field_176299_a, s.func_177229_b((IProperty)BlockNewLog.field_176299_a)), WorldTransmutations.cyclePropertyBackwards(s, BlockNewLog.field_176300_b));
                continue;
            }
            WorldTransmutations.register(s, s.func_177231_a((IProperty)BlockNewLog.field_176300_b), WorldTransmutations.cyclePropertyBackwards(s, BlockNewLog.field_176300_b));
        }
        for (IBlockState s : Blocks.field_150361_u.func_176194_O().func_177619_a()) {
            if (s.func_177229_b((IProperty)BlockNewLeaf.field_176240_P) == BlockPlanks.EnumType.ACACIA) {
                WorldTransmutations.register(s, s.func_177231_a((IProperty)BlockNewLeaf.field_176240_P), Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.JUNGLE).func_177226_a((IProperty)BlockOldLeaf.field_176236_b, s.func_177229_b((IProperty)BlockNewLeaf.field_176236_b)).func_177226_a((IProperty)BlockOldLeaf.field_176237_a, s.func_177229_b((IProperty)BlockNewLeaf.field_176237_a)));
                continue;
            }
            if (s.func_177229_b((IProperty)BlockNewLeaf.field_176240_P) == BlockPlanks.EnumType.DARK_OAK) {
                WorldTransmutations.register(s, Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.OAK).func_177226_a((IProperty)BlockOldLeaf.field_176236_b, s.func_177229_b((IProperty)BlockNewLeaf.field_176236_b)).func_177226_a((IProperty)BlockOldLeaf.field_176237_a, s.func_177229_b((IProperty)BlockNewLeaf.field_176237_a)), WorldTransmutations.cyclePropertyBackwards(s, BlockNewLeaf.field_176240_P));
                continue;
            }
            WorldTransmutations.register(s, s.func_177231_a((IProperty)BlockNewLeaf.field_176240_P), WorldTransmutations.cyclePropertyBackwards(s, BlockNewLeaf.field_176240_P));
        }
        for (BlockPlanks.EnumType enumType : BlockPlanks.EnumType.values()) {
            state = Blocks.field_150345_g.func_176223_P().func_177226_a((IProperty)BlockSapling.field_176480_a, (Comparable)enumType);
            WorldTransmutations.register(state, state.func_177231_a((IProperty)BlockSapling.field_176480_a), WorldTransmutations.cyclePropertyBackwards(state, BlockSapling.field_176480_a));
        }
        for (BlockPlanks.EnumType enumType : EnumDyeColor.values()) {
            state = Blocks.field_150325_L.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)enumType);
            WorldTransmutations.register(state, state.func_177231_a((IProperty)BlockColored.field_176581_a), WorldTransmutations.cyclePropertyBackwards(state, BlockColored.field_176581_a));
            state = Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)enumType);
            WorldTransmutations.register(state, state.func_177231_a((IProperty)BlockColored.field_176581_a), WorldTransmutations.cyclePropertyBackwards(state, BlockColored.field_176581_a));
            state = Blocks.field_150404_cg.func_176223_P().func_177226_a((IProperty)BlockCarpet.field_176330_a, (Comparable)enumType);
            WorldTransmutations.register(state, state.func_177231_a((IProperty)BlockCarpet.field_176330_a), WorldTransmutations.cyclePropertyBackwards(state, BlockCarpet.field_176330_a));
        }
        IBlockState granite = Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.GRANITE);
        IBlockState diorite = Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.DIORITE);
        IBlockState andesite = Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.ANDESITE);
        WorldTransmutations.register(granite, diorite, andesite);
        WorldTransmutations.register(diorite, andesite, granite);
        WorldTransmutations.register(andesite, granite, diorite);
    }

    public static class Entry
    implements IRecipeWrapper {
        public final IBlockState input;
        public final Pair<IBlockState, IBlockState> outputs;

        public Entry(IBlockState from, Pair<IBlockState, IBlockState> results) {
            this.input = from;
            this.outputs = results;
        }

        public void getIngredients(IIngredients ingredients) {
            if (this.input.func_177228_b().containsKey((Object)BlockHorizontal.field_185512_D) && this.input.func_177229_b((IProperty)BlockHorizontal.field_185512_D) != EnumFacing.NORTH || this.input.func_177228_b().containsKey((Object)BlockLog.field_176299_a) && this.input.func_177229_b((IProperty)BlockLog.field_176299_a) != BlockLog.EnumAxis.NONE) {
                return;
            }
            ArrayList<ItemStack> outputList = new ArrayList<ItemStack>();
            if (this.input.func_177230_c() instanceof BlockStaticLiquid || ((IBlockState)this.outputs.getLeft()).func_177230_c() instanceof BlockStaticLiquid) {
                if (this.input.func_177230_c() == Blocks.field_150355_j) {
                    ingredients.setInput(FluidStack.class, (Object)new FluidStack(FluidRegistry.WATER, 1000));
                } else if (this.input.func_177230_c() == Blocks.field_150353_l) {
                    ingredients.setInput(FluidStack.class, (Object)new FluidStack(FluidRegistry.LAVA, 1000));
                } else {
                    ingredients.setInput(ItemStack.class, (Object)new ItemStack(this.input.func_177230_c()));
                }
                if (((IBlockState)this.outputs.getLeft()).func_177230_c() == Blocks.field_150355_j) {
                    ingredients.setOutput(FluidStack.class, (Object)new FluidStack(FluidRegistry.WATER, 1000));
                } else if (((IBlockState)this.outputs.getLeft()).func_177230_c() == Blocks.field_150353_l) {
                    ingredients.setOutput(FluidStack.class, (Object)new FluidStack(FluidRegistry.LAVA, 1000));
                } else {
                    ingredients.setOutput(ItemStack.class, (Object)new ItemStack(((IBlockState)this.outputs.getLeft()).func_177230_c()));
                }
            }
            if (this.input.func_177228_b().containsKey((Object)BlockColored.field_176581_a)) {
                ingredients.setInput(ItemStack.class, (Object)new ItemStack(this.input.func_177230_c(), 1, ((EnumDyeColor)this.input.func_177229_b((IProperty)BlockColored.field_176581_a)).func_176765_a()));
                outputList.add(new ItemStack(((IBlockState)this.outputs.getLeft()).func_177230_c(), 1, ((EnumDyeColor)((IBlockState)this.outputs.getLeft()).func_177229_b((IProperty)BlockColored.field_176581_a)).func_176765_a()));
                if (this.outputs.getRight() != null) {
                    outputList.add(new ItemStack(((IBlockState)this.outputs.getRight()).func_177230_c(), 1, ((EnumDyeColor)((IBlockState)this.outputs.getRight()).func_177229_b((IProperty)BlockColored.field_176581_a)).func_176765_a()));
                }
            } else if (this.input.func_177228_b().containsKey((Object)BlockStone.field_176247_a)) {
                ingredients.setInput(ItemStack.class, (Object)new ItemStack(this.input.func_177230_c(), 1, ((BlockStone.EnumType)this.input.func_177229_b((IProperty)BlockStone.field_176247_a)).func_176642_a()));
                if (((IBlockState)this.outputs.getLeft()).func_177230_c() == Blocks.field_150347_e || ((IBlockState)this.outputs.getLeft()).func_177230_c() == Blocks.field_150349_c) {
                    outputList.add(new ItemStack(((IBlockState)this.outputs.getLeft()).func_177230_c()));
                } else {
                    outputList.add(new ItemStack(((IBlockState)this.outputs.getLeft()).func_177230_c(), 1, ((BlockStone.EnumType)((IBlockState)this.outputs.getLeft()).func_177229_b((IProperty)BlockStone.field_176247_a)).func_176642_a()));
                }
                if (this.outputs.getRight() != null) {
                    if (((IBlockState)this.outputs.getRight()).func_177230_c() == Blocks.field_150347_e || ((IBlockState)this.outputs.getRight()).func_177230_c() == Blocks.field_150349_c) {
                        outputList.add(new ItemStack(((IBlockState)this.outputs.getRight()).func_177230_c()));
                    } else {
                        outputList.add(new ItemStack(((IBlockState)this.outputs.getRight()).func_177230_c(), 1, ((BlockStone.EnumType)((IBlockState)this.outputs.getRight()).func_177229_b((IProperty)BlockStone.field_176247_a)).func_176642_a()));
                    }
                }
            } else if (this.input.func_177228_b().containsKey((Object)BlockOldLog.field_176301_b)) {
                ingredients.setInput(ItemStack.class, (Object)new ItemStack(this.input.func_177230_c(), 1, ((BlockPlanks.EnumType)this.input.func_177229_b((IProperty)BlockOldLog.field_176301_b)).func_176839_a()));
                if (((IBlockState)this.outputs.getLeft()).func_177228_b().containsKey((Object)BlockOldLog.field_176301_b)) {
                    outputList.add(new ItemStack(((IBlockState)this.outputs.getLeft()).func_177230_c(), 1, ((BlockPlanks.EnumType)((IBlockState)this.outputs.getLeft()).func_177229_b((IProperty)BlockOldLog.field_176301_b)).func_176839_a()));
                } else {
                    outputList.add(new ItemStack(((IBlockState)this.outputs.getLeft()).func_177230_c(), 1, ((BlockPlanks.EnumType)((IBlockState)this.outputs.getLeft()).func_177229_b((IProperty)BlockNewLog.field_176300_b)).func_176839_a() - 4));
                }
                if (this.outputs.getRight() != null) {
                    if (((IBlockState)this.outputs.getRight()).func_177228_b().containsKey((Object)BlockOldLog.field_176301_b)) {
                        outputList.add(new ItemStack(((IBlockState)this.outputs.getRight()).func_177230_c(), 1, ((BlockPlanks.EnumType)((IBlockState)this.outputs.getRight()).func_177229_b((IProperty)BlockOldLog.field_176301_b)).func_176839_a()));
                    } else {
                        outputList.add(new ItemStack(((IBlockState)this.outputs.getRight()).func_177230_c(), 1, ((BlockPlanks.EnumType)((IBlockState)this.outputs.getRight()).func_177229_b((IProperty)BlockNewLog.field_176300_b)).func_176839_a() - 4));
                    }
                }
            } else if (this.input.func_177228_b().containsKey((Object)BlockNewLog.field_176300_b)) {
                ingredients.setInput(ItemStack.class, (Object)new ItemStack(this.input.func_177230_c(), 1, ((BlockPlanks.EnumType)this.input.func_177229_b((IProperty)BlockNewLog.field_176300_b)).func_176839_a() - 4));
                if (((IBlockState)this.outputs.getLeft()).func_177228_b().containsKey((Object)BlockNewLog.field_176300_b)) {
                    outputList.add(new ItemStack(((IBlockState)this.outputs.getLeft()).func_177230_c(), 1, ((BlockPlanks.EnumType)((IBlockState)this.outputs.getLeft()).func_177229_b((IProperty)BlockNewLog.field_176300_b)).func_176839_a() - 4));
                } else {
                    outputList.add(new ItemStack(((IBlockState)this.outputs.getLeft()).func_177230_c(), 1, ((BlockPlanks.EnumType)((IBlockState)this.outputs.getLeft()).func_177229_b((IProperty)BlockOldLog.field_176301_b)).func_176839_a()));
                }
                if (this.outputs.getRight() != null) {
                    if (((IBlockState)this.outputs.getRight()).func_177228_b().containsKey((Object)BlockNewLog.field_176300_b)) {
                        outputList.add(new ItemStack(((IBlockState)this.outputs.getRight()).func_177230_c(), 1, ((BlockPlanks.EnumType)((IBlockState)this.outputs.getRight()).func_177229_b((IProperty)BlockNewLog.field_176300_b)).func_176839_a() - 4));
                    } else {
                        outputList.add(new ItemStack(((IBlockState)this.outputs.getRight()).func_177230_c(), 1, ((BlockPlanks.EnumType)((IBlockState)this.outputs.getRight()).func_177229_b((IProperty)BlockOldLog.field_176301_b)).func_176839_a()));
                    }
                }
            } else if (this.input.func_177228_b().containsKey((Object)BlockOldLeaf.field_176239_P)) {
                ingredients.setInput(ItemStack.class, (Object)new ItemStack(this.input.func_177230_c(), 1, ((BlockPlanks.EnumType)this.input.func_177229_b((IProperty)BlockOldLeaf.field_176239_P)).func_176839_a()));
                if (((IBlockState)this.outputs.getLeft()).func_177228_b().containsKey((Object)BlockOldLeaf.field_176239_P)) {
                    outputList.add(new ItemStack(((IBlockState)this.outputs.getLeft()).func_177230_c(), 1, ((BlockPlanks.EnumType)((IBlockState)this.outputs.getLeft()).func_177229_b((IProperty)BlockOldLeaf.field_176239_P)).func_176839_a()));
                } else {
                    outputList.add(new ItemStack(((IBlockState)this.outputs.getLeft()).func_177230_c(), 1, ((BlockPlanks.EnumType)((IBlockState)this.outputs.getLeft()).func_177229_b((IProperty)BlockNewLeaf.field_176240_P)).func_176839_a()));
                }
                if (this.outputs.getRight() != null) {
                    if (((IBlockState)this.outputs.getRight()).func_177228_b().containsKey((Object)BlockOldLeaf.field_176239_P)) {
                        outputList.add(new ItemStack(((IBlockState)this.outputs.getRight()).func_177230_c(), 1, ((BlockPlanks.EnumType)((IBlockState)this.outputs.getRight()).func_177229_b((IProperty)BlockOldLeaf.field_176239_P)).func_176839_a()));
                    } else {
                        outputList.add(new ItemStack(((IBlockState)this.outputs.getRight()).func_177230_c(), 1, ((BlockPlanks.EnumType)((IBlockState)this.outputs.getRight()).func_177229_b((IProperty)BlockNewLeaf.field_176240_P)).func_176839_a()));
                    }
                }
            } else if (this.input.func_177228_b().containsKey((Object)BlockNewLeaf.field_176240_P)) {
                ingredients.setInput(ItemStack.class, (Object)new ItemStack(this.input.func_177230_c(), 1, ((BlockPlanks.EnumType)this.input.func_177229_b((IProperty)BlockNewLeaf.field_176240_P)).func_176839_a()));
                if (((IBlockState)this.outputs.getLeft()).func_177228_b().containsKey((Object)BlockNewLeaf.field_176240_P)) {
                    outputList.add(new ItemStack(((IBlockState)this.outputs.getLeft()).func_177230_c(), 1, ((BlockPlanks.EnumType)((IBlockState)this.outputs.getLeft()).func_177229_b((IProperty)BlockNewLeaf.field_176240_P)).func_176839_a()));
                } else {
                    outputList.add(new ItemStack(((IBlockState)this.outputs.getLeft()).func_177230_c(), 1, ((BlockPlanks.EnumType)((IBlockState)this.outputs.getLeft()).func_177229_b((IProperty)BlockOldLeaf.field_176239_P)).func_176839_a()));
                }
                if (this.outputs.getRight() != null) {
                    if (((IBlockState)this.outputs.getRight()).func_177228_b().containsKey((Object)BlockNewLeaf.field_176240_P)) {
                        outputList.add(new ItemStack(((IBlockState)this.outputs.getRight()).func_177230_c(), 1, ((BlockPlanks.EnumType)((IBlockState)this.outputs.getRight()).func_177229_b((IProperty)BlockNewLeaf.field_176240_P)).func_176839_a()));
                    } else {
                        outputList.add(new ItemStack(((IBlockState)this.outputs.getRight()).func_177230_c(), 1, ((BlockPlanks.EnumType)((IBlockState)this.outputs.getRight()).func_177229_b((IProperty)BlockNewLeaf.field_176240_P)).func_176839_a()));
                    }
                }
            } else if (this.input.func_177228_b().containsKey((Object)BlockSapling.field_176480_a)) {
                ingredients.setInput(ItemStack.class, (Object)new ItemStack(this.input.func_177230_c(), 1, ((BlockPlanks.EnumType)this.input.func_177229_b((IProperty)BlockSapling.field_176480_a)).func_176839_a()));
                outputList.add(new ItemStack(((IBlockState)this.outputs.getLeft()).func_177230_c(), 1, ((BlockPlanks.EnumType)((IBlockState)this.outputs.getLeft()).func_177229_b((IProperty)BlockSapling.field_176480_a)).func_176839_a()));
                if (this.outputs.getRight() != null) {
                    outputList.add(new ItemStack(((IBlockState)this.outputs.getRight()).func_177230_c(), 1, ((BlockPlanks.EnumType)((IBlockState)this.outputs.getRight()).func_177229_b((IProperty)BlockSapling.field_176480_a)).func_176839_a()));
                }
            } else {
                ingredients.setInput(ItemStack.class, (Object)new ItemStack(this.input.func_177230_c()));
                outputList.add(new ItemStack(((IBlockState)this.outputs.getLeft()).func_177230_c()));
                if (this.outputs.getRight() != null) {
                    outputList.add(new ItemStack(((IBlockState)this.outputs.getRight()).func_177230_c()));
                }
            }
            ingredients.setOutputs(ItemStack.class, outputList);
        }

        public List<String> getTooltipStrings(int mouseX, int mouseY) {
            if (mouseX > 67 && mouseX < 107 && mouseY > 18 && mouseY < 38) {
                return Collections.singletonList("Click in world, shift click for second output");
            }
            return Collections.emptyList();
        }
    }
}

