/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.api;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import moze_intel.projecte.api.nss.NSSItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public final class ItemInfo {
    @Nonnull
    private final Item item;
    @Nullable
    private final CompoundNBT nbt;

    private ItemInfo(@Nonnull Item item, @Nullable CompoundNBT nbt) {
        this.item = item;
        this.nbt = nbt != null && nbt.isEmpty() ? null : nbt;
    }

    public static ItemInfo fromItem(@Nonnull Item item, @Nullable CompoundNBT nbt) {
        return new ItemInfo(item, nbt);
    }

    public static ItemInfo fromItem(@Nonnull Item item) {
        return ItemInfo.fromItem(item, null);
    }

    public static ItemInfo fromStack(@Nonnull ItemStack stack) {
        return ItemInfo.fromItem(stack.func_77973_b(), stack.func_77978_p());
    }

    @Nullable
    public static ItemInfo fromNSS(@Nonnull NSSItem stack) {
        if (stack.representsTag()) {
            return null;
        }
        Item item = (Item)ForgeRegistries.ITEMS.getValue(stack.getResourceLocation());
        if (item == null) {
            return null;
        }
        return ItemInfo.fromItem(item, stack.getNBT());
    }

    @Nullable
    public static ItemInfo read(@Nonnull CompoundNBT nbt) {
        if (nbt.func_150297_b("item", 8)) {
            ResourceLocation registryName = ResourceLocation.func_208304_a((String)nbt.func_74779_i("item"));
            if (registryName == null) {
                return null;
            }
            Item item = (Item)ForgeRegistries.ITEMS.getValue(registryName);
            if (item == null) {
                return null;
            }
            if (nbt.func_150297_b("nbt", 10)) {
                return ItemInfo.fromItem(item, nbt.func_74775_l("nbt"));
            }
            return ItemInfo.fromItem(item, null);
        }
        return null;
    }

    @Nonnull
    public Item getItem() {
        return this.item;
    }

    @Nullable
    public CompoundNBT getNBT() {
        return this.nbt == null ? null : this.nbt.func_74737_b();
    }

    public boolean hasNBT() {
        return this.nbt != null;
    }

    public ItemStack createStack() {
        ItemStack stack = new ItemStack((IItemProvider)this.item);
        stack.func_77982_d(this.getNBT());
        return stack;
    }

    public CompoundNBT write(@Nonnull CompoundNBT nbt) {
        nbt.func_74778_a("item", this.item.getRegistryName().toString());
        if (this.nbt != null) {
            nbt.func_218657_a("nbt", (INBT)this.nbt);
        }
        return nbt;
    }

    public int hashCode() {
        int code = this.item.hashCode();
        if (this.nbt != null) {
            code = 31 * code + this.nbt.hashCode();
        }
        return code;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ItemInfo) {
            ItemInfo other = (ItemInfo)o;
            return this.item == other.item && Objects.equals(this.nbt, other.nbt);
        }
        return false;
    }

    public String toString() {
        if (this.nbt != null) {
            return this.item.getRegistryName() + " " + this.nbt;
        }
        return this.item.getRegistryName().toString();
    }
}

