/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.api.nss;

import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import moze_intel.projecte.api.nss.NSSTag;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import net.minecraft.tags.Tag;
import net.minecraft.tags.TagCollection;
import net.minecraft.util.ResourceLocation;

public abstract class AbstractNSSTag<TYPE>
implements NSSTag {
    private static final Set<NSSTag> createdTags = new HashSet<NSSTag>();
    @Nonnull
    private final ResourceLocation resourceLocation;
    private final boolean isTag;

    public static Set<NSSTag> getAllCreatedTags() {
        return ImmutableSet.copyOf(createdTags);
    }

    public static void clearCreatedTags() {
        createdTags.clear();
    }

    protected AbstractNSSTag(@Nonnull ResourceLocation resourceLocation, boolean isTag) {
        this.resourceLocation = resourceLocation;
        this.isTag = isTag;
        if (isTag) {
            createdTags.add(this);
        }
    }

    @Nonnull
    public ResourceLocation getResourceLocation() {
        return this.resourceLocation;
    }

    protected abstract boolean isInstance(AbstractNSSTag var1);

    @Nonnull
    protected abstract String getType();

    @Nonnull
    protected abstract String getJsonPrefix();

    @Nonnull
    protected abstract TagCollection<TYPE> getTagCollection();

    protected abstract Function<TYPE, NormalizedSimpleStack> createNew();

    @Override
    public boolean representsTag() {
        return this.isTag;
    }

    @Override
    public void forEachElement(Consumer<NormalizedSimpleStack> consumer) {
        Tag tag;
        if (this.representsTag() && (tag = this.getTagCollection().func_199910_a(this.getResourceLocation())) != null) {
            tag.func_199885_a().stream().map(this.createNew()).forEach(consumer);
        }
    }

    @Override
    public String json() {
        if (this.representsTag()) {
            return this.getJsonPrefix() + "#" + this.getResourceLocation();
        }
        return this.getJsonPrefix() + this.getResourceLocation();
    }

    @Override
    public String toString() {
        if (this.representsTag()) {
            return this.getType() + " Tag: " + this.getResourceLocation();
        }
        return this.getType() + ": " + this.getResourceLocation();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AbstractNSSTag && this.isInstance((AbstractNSSTag)o)) {
            AbstractNSSTag other = (AbstractNSSTag)o;
            return this.representsTag() == other.representsTag() && this.getResourceLocation().equals((Object)other.getResourceLocation());
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (this.representsTag()) {
            return 31 + this.resourceLocation.hashCode();
        }
        return this.resourceLocation.hashCode();
    }
}

