/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.api.nss;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import moze_intel.projecte.api.nss.AbstractNBTNSSTag;
import moze_intel.projecte.api.nss.AbstractNSSTag;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.tags.TagCollection;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public final class NSSFluid
extends AbstractNBTNSSTag<Fluid> {
    private NSSFluid(@Nonnull ResourceLocation resourceLocation, boolean isTag, @Nullable CompoundNBT nbt) {
        super(resourceLocation, isTag, nbt);
    }

    @Nonnull
    public static NSSFluid createFluid(@Nonnull FluidStack stack) {
        return NSSFluid.createFluid(stack.getFluid(), stack.getTag());
    }

    @Nonnull
    public static NSSFluid createFluid(@Nonnull Fluid fluid) {
        return NSSFluid.createFluid(fluid, null);
    }

    @Nonnull
    public static NSSFluid createFluid(@Nonnull Fluid fluid, @Nullable CompoundNBT nbt) {
        if (fluid == Fluids.field_204541_a) {
            throw new IllegalArgumentException("Can't make NSSFluid with an empty fluid");
        }
        return NSSFluid.createFluid(fluid.getRegistryName(), nbt);
    }

    @Nonnull
    public static NSSFluid createFluid(@Nonnull ResourceLocation fluidID) {
        return NSSFluid.createFluid(fluidID, null);
    }

    @Nonnull
    public static NSSFluid createFluid(@Nonnull ResourceLocation fluidID, @Nullable CompoundNBT nbt) {
        return new NSSFluid(fluidID, false, nbt);
    }

    @Nonnull
    public static NSSFluid createTag(@Nonnull ResourceLocation tagId) {
        return new NSSFluid(tagId, true, null);
    }

    @Nonnull
    public static NSSFluid createTag(@Nonnull Tag<Fluid> tag) {
        return NSSFluid.createTag(tag.func_199886_b());
    }

    @Override
    protected boolean isInstance(AbstractNSSTag o) {
        return o instanceof NSSFluid;
    }

    @Override
    @Nonnull
    public String getJsonPrefix() {
        return "FLUID|";
    }

    @Override
    @Nonnull
    public String getType() {
        return "Fluid";
    }

    @Override
    @Nonnull
    protected TagCollection<Fluid> getTagCollection() {
        return FluidTags.getCollection();
    }

    @Override
    protected Function<Fluid, NormalizedSimpleStack> createNew() {
        return NSSFluid::createFluid;
    }
}

