/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.capability;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import moze_intel.projecte.capability.IItemCapabilitySerializable;
import moze_intel.projecte.capability.ItemCapability;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class ItemCapabilityWrapper
implements ICapabilitySerializable<CompoundNBT> {
    private final List<ItemCapability<?>> capabilities;
    private final ItemStack itemStack;

    public ItemCapabilityWrapper(ItemStack stack, List<ItemCapability<?>> capabilities) {
        this.itemStack = stack;
        this.capabilities = capabilities;
        this.capabilities.forEach(cap -> cap.setWrapper(this));
    }

    public ItemCapabilityWrapper(ItemStack stack, ItemCapability<?> ... capabilities) {
        this.itemStack = stack;
        this.capabilities = Arrays.asList(capabilities);
        this.capabilities.forEach(cap -> cap.setWrapper(this));
    }

    protected ItemStack getItemStack() {
        return this.itemStack;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
        for (ItemCapability<?> cap : this.capabilities) {
            if (capability != cap.getCapability()) continue;
            return cap.getLazyCapability().cast();
        }
        return LazyOptional.empty();
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT serializedNBT = new CompoundNBT();
        for (ItemCapability<?> cap : this.capabilities) {
            if (!(cap instanceof IItemCapabilitySerializable)) continue;
            IItemCapabilitySerializable serializableCap = (IItemCapabilitySerializable)((Object)cap);
            serializedNBT.func_218657_a(serializableCap.getStorageKey(), serializableCap.serializeNBT());
        }
        return serializedNBT;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        for (ItemCapability<?> cap : this.capabilities) {
            IItemCapabilitySerializable serializableCap;
            if (!(cap instanceof IItemCapabilitySerializable) || !nbt.func_74764_b((serializableCap = (IItemCapabilitySerializable)((Object)cap)).getStorageKey())) continue;
            serializableCap.deserializeNBT(nbt.func_74781_a(serializableCap.getStorageKey()));
        }
    }
}

