/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.emc;

import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import moze_intel.projecte.PECore;
import moze_intel.projecte.api.ItemInfo;
import moze_intel.projecte.api.event.EMCRemapEvent;
import moze_intel.projecte.api.mapper.IEMCMapper;
import moze_intel.projecte.api.nss.NSSItem;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.emc.FuelMapper;
import moze_intel.projecte.emc.SimpleGraphMapper;
import moze_intel.projecte.emc.arithmetic.HiddenBigFractionArithmetic;
import moze_intel.projecte.emc.collector.AbstractMappingCollector;
import moze_intel.projecte.emc.collector.DumpToFileCollector;
import moze_intel.projecte.emc.collector.LongToBigFractionCollector;
import moze_intel.projecte.emc.generator.BigFractionToLongGenerator;
import moze_intel.projecte.emc.mappers.TagMapper;
import moze_intel.projecte.emc.pregenerated.PregeneratedEMC;
import moze_intel.projecte.network.packets.SyncEmcPKT;
import moze_intel.projecte.utils.AnnotationHelper;
import net.minecraft.resources.IResourceManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public final class EMCMappingHandler {
    private static final List<IEMCMapper<NormalizedSimpleStack, Long>> mappers = new ArrayList<IEMCMapper<NormalizedSimpleStack, Long>>();
    private static final Map<ItemInfo, Long> emc = new HashMap<ItemInfo, Long>();

    public static void loadMappers() {
        if (mappers.isEmpty()) {
            mappers.addAll(AnnotationHelper.getEMCMappers());
            mappers.add(new TagMapper());
        }
    }

    public static <T> T getOrSetDefault(CommentedFileConfig config, String key, String comment, T defaultValue) {
        Object val = config.get(key);
        if (val == null) {
            val = defaultValue;
            config.set(key, val);
            config.setComment(key, comment);
        }
        return (T)val;
    }

    public static void map(IResourceManager resourceManager) {
        Map<NormalizedSimpleStack, Long> graphMapperValues;
        EMCMappingHandler.clearEmcMap();
        SimpleGraphMapper mapper = new SimpleGraphMapper(new HiddenBigFractionArithmetic());
        BigFractionToLongGenerator valueGenerator = new BigFractionToLongGenerator(mapper);
        AbstractMappingCollector mappingCollector = new LongToBigFractionCollector(mapper);
        Path path = ProjectEConfig.CONFIG_DIR.resolve("mapping.toml");
        try {
            path.toFile().createNewFile();
        }
        catch (IOException ex) {
            PECore.LOGGER.error("Couldn't create mapping.toml", (Throwable)ex);
        }
        CommentedFileConfig config = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).build();
        config.load();
        boolean dumpToFile = EMCMappingHandler.getOrSetDefault(config, "general.dumpEverythingToFile", "Want to take a look at the internals of EMC Calculation? Enable this to write all the conversions and setValue-Commands to config/ProjectE/mappingdump.json", false);
        boolean shouldUsePregenerated = EMCMappingHandler.getOrSetDefault(config, "general.pregenerate", "When the next EMC mapping occurs write the results to config/ProjectE/pregenerated_emc.json and only ever run the mapping again when that file does not exist, this setting is set to false, or an error occurred parsing that file.", false);
        boolean logFoundExploits = EMCMappingHandler.getOrSetDefault(config, "general.logEMCExploits", "Log known EMC Exploits. This can not and will not find all possible exploits. This will only find exploits that result in fixed/custom emc values that the algorithm did not overwrite. Exploits that derive from conversions that are unknown to ProjectE will not be found.", true);
        if (dumpToFile) {
            mappingCollector = new DumpToFileCollector(ProjectEConfig.CONFIG_DIR.resolve("mappingdump.json").toFile(), mappingCollector);
        }
        File pregeneratedEmcFile = Paths.get("config", "ProjectE", "pregenerated_emc.json").toFile();
        if (shouldUsePregenerated && pregeneratedEmcFile.canRead() && PregeneratedEMC.tryRead(pregeneratedEmcFile, graphMapperValues = new HashMap<NormalizedSimpleStack, Long>())) {
            PECore.LOGGER.info(String.format("Loaded %d values from pregenerated EMC File", graphMapperValues.size()));
        } else {
            SimpleGraphMapper.setLogFoundExploits(logFoundExploits);
            PECore.debugLog("Starting to collect Mappings...", new Object[0]);
            for (IEMCMapper<NormalizedSimpleStack, Long> iEMCMapper : mappers) {
                try {
                    if (!EMCMappingHandler.getOrSetDefault(config, "enabledMappers." + iEMCMapper.getName(), iEMCMapper.getDescription(), iEMCMapper.isAvailable()).booleanValue()) continue;
                    DumpToFileCollector.currentGroupName = iEMCMapper.getName();
                    iEMCMapper.addMappings(mappingCollector, config, resourceManager);
                    PECore.debugLog("Collected Mappings from " + iEMCMapper.getClass().getName(), new Object[0]);
                }
                catch (Exception e) {
                    PECore.LOGGER.fatal("Exception during Mapping Collection from Mapper {}. PLEASE REPORT THIS! EMC VALUES MIGHT BE INCONSISTENT!", (Object)iEMCMapper.getClass().getName());
                    e.printStackTrace();
                }
            }
            DumpToFileCollector.currentGroupName = "NSSHelper";
            PECore.debugLog("Mapping Collection finished", new Object[0]);
            mappingCollector.finishCollection();
            PECore.debugLog("Starting to generate Values:", new Object[0]);
            config.save();
            config.close();
            graphMapperValues = valueGenerator.generateValues();
            PECore.debugLog("Generated Values...", new Object[0]);
            EMCMappingHandler.filterEMCMap(graphMapperValues);
            if (shouldUsePregenerated) {
                try {
                    PregeneratedEMC.write(pregeneratedEmcFile, graphMapperValues);
                    PECore.debugLog("Wrote Pregen-file!", new Object[0]);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        for (Map.Entry entry : graphMapperValues.entrySet()) {
            NSSItem normStackItem = (NSSItem)entry.getKey();
            ItemInfo obj = ItemInfo.fromNSS(normStackItem);
            if (obj != null) {
                emc.put(obj, (Long)entry.getValue());
                continue;
            }
            PECore.LOGGER.warn("Could not add EMC value for {}, item does not exist!", (Object)normStackItem.getResourceLocation());
        }
        MinecraftForge.EVENT_BUS.post((Event)new EMCRemapEvent());
        FuelMapper.loadMap();
    }

    private static void filterEMCMap(Map<NormalizedSimpleStack, Long> map) {
        map.entrySet().removeIf(e -> !(e.getKey() instanceof NSSItem) || ((NSSItem)e.getKey()).representsTag() || (Long)e.getValue() <= 0L);
    }

    public static int getEmcMapSize() {
        return emc.size();
    }

    public static boolean hasEmcValue(@Nonnull ItemInfo info) {
        return emc.containsKey(info);
    }

    public static long getStoredEmcValue(@Nonnull ItemInfo info) {
        return emc.getOrDefault(info, 0L);
    }

    public static void clearEmcMap() {
        emc.clear();
    }

    public static Set<ItemInfo> getMappedItems() {
        return new HashSet<ItemInfo>(emc.keySet());
    }

    public static void fromPacket(SyncEmcPKT.EmcPKTInfo[] data) {
        emc.clear();
        for (SyncEmcPKT.EmcPKTInfo info : data) {
            emc.put(ItemInfo.fromItem(info.getItem(), info.getNbt()), info.getEmc());
        }
    }

    public static SyncEmcPKT.EmcPKTInfo[] createPacketData() {
        SyncEmcPKT.EmcPKTInfo[] ret = new SyncEmcPKT.EmcPKTInfo[emc.size()];
        int i = 0;
        for (Map.Entry<ItemInfo, Long> entry : emc.entrySet()) {
            ItemInfo info = entry.getKey();
            ret[i] = new SyncEmcPKT.EmcPKTInfo(info.getItem(), info.getNBT(), entry.getValue());
            ++i;
        }
        return ret;
    }
}

