/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.emc.mappers;

import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import moze_intel.projecte.PECore;
import moze_intel.projecte.api.imc.IRecipeMapper;
import moze_intel.projecte.api.mapper.EMCMapper;
import moze_intel.projecte.api.mapper.IEMCMapper;
import moze_intel.projecte.api.mapper.collector.IMappingCollector;
import moze_intel.projecte.api.nss.NSSFake;
import moze_intel.projecte.api.nss.NSSItem;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import moze_intel.projecte.emc.EMCMappingHandler;
import moze_intel.projecte.emc.IngredientMap;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.AbstractCookingRecipe;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.SingleItemRecipe;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

@EMCMapper
public class CraftingMapper
implements IEMCMapper<NormalizedSimpleStack, Long> {
    @EMCMapper.Instance
    public static final CraftingMapper INSTANCE = new CraftingMapper();
    private List<IRecipeMapper> recipeMappers = Collections.emptyList();

    public static void init() {
        CraftingMapper.registerDefault("CraftingRecipe", "Maps crafting table recipes", recipe -> recipe instanceof ICraftingRecipe);
        CraftingMapper.registerDefault("CookingRecipe", "Maps cooking recipes", recipe -> recipe instanceof AbstractCookingRecipe);
        CraftingMapper.registerDefault("SingleItemRecipe", "Maps stone cutter recipes", recipe -> recipe instanceof SingleItemRecipe);
    }

    private static void registerDefault(String name, String description, Predicate<IRecipe> supportedRecipePredicate) {
        InterModComms.sendTo((String)"projecte", (String)"register_mappable_irecipe", () -> new IRecipeMapper(name, description, supportedRecipePredicate));
    }

    public static void setRecipeMappers(List<IRecipeMapper> mappableIRecipes) {
        CraftingMapper.INSTANCE.recipeMappers = ImmutableList.copyOf(mappableIRecipes);
    }

    @Override
    public void addMappings(IMappingCollector<NormalizedSimpleStack, Long> mapper, CommentedFileConfig config, IResourceManager resourceManager) {
        HashMap<ResourceLocation, Integer> recipeCount = new HashMap<ResourceLocation, Integer>();
        HashSet canNotMap = new HashSet();
        for (IRecipe iRecipe : ServerLifecycleHooks.getCurrentServer().func_199529_aN().func_199510_b()) {
            boolean handled = false;
            ItemStack recipeOutput = iRecipe.func_77571_b();
            if (recipeOutput.func_190926_b()) continue;
            NSSItem recipeOutputNorm = NSSItem.createItem(recipeOutput);
            for (IRecipeMapper recipeMapper : this.recipeMappers) {
                String configKey = this.getName() + "." + recipeMapper.getName() + ".enabled";
                if (!EMCMappingHandler.getOrSetDefault(config, configKey, recipeMapper.getDescription(), true).booleanValue() || !recipeMapper.canHandle(iRecipe)) continue;
                handled = true;
                for (CraftingIngredients variation : this.getIngredientsFor(iRecipe)) {
                    IngredientMap<NormalizedSimpleStack> ingredientMap = new IngredientMap<NormalizedSimpleStack>();
                    for (ItemStack itemStack : variation.fixedIngredients) {
                        if (itemStack.func_190926_b()) continue;
                        if (itemStack.func_77973_b().hasContainerItem(itemStack)) {
                            ingredientMap.addIngredient(NSSItem.createItem(itemStack.func_77973_b().getContainerItem(itemStack)), -1);
                        }
                        ingredientMap.addIngredient(NSSItem.createItem(itemStack), 1);
                    }
                    for (Iterable iterable : variation.multiIngredients) {
                        NormalizedSimpleStack dummy = NSSFake.create(iterable.toString());
                        ingredientMap.addIngredient(dummy, 1);
                        for (ItemStack stack : iterable) {
                            if (stack.func_190926_b()) continue;
                            IngredientMap<NSSItem> groupIngredientMap = new IngredientMap<NSSItem>();
                            if (stack.func_77973_b().hasContainerItem(stack)) {
                                groupIngredientMap.addIngredient(NSSItem.createItem(stack.func_77973_b().getContainerItem(stack)), -1);
                            }
                            groupIngredientMap.addIngredient(NSSItem.createItem(stack), 1);
                            mapper.addConversion(1, dummy, groupIngredientMap.getMap());
                        }
                    }
                    mapper.addConversion(recipeOutput.func_190916_E(), (NormalizedSimpleStack)recipeOutputNorm, ingredientMap.getMap());
                }
            }
            if (!handled) {
                canNotMap.add(iRecipe.getClass());
                continue;
            }
            recipeCount.merge(iRecipe.func_199559_b().getRegistryName(), 1, Integer::sum);
        }
        PECore.debugLog("CraftingMapper Statistics:", new Object[0]);
        for (Map.Entry entry : recipeCount.entrySet()) {
            PECore.debugLog("Found {} Recipes of Type {}", entry.getValue(), entry.getKey());
        }
        for (Class clazz : canNotMap) {
            PECore.debugLog("Could not map Crafting Recipes with Type: {}", clazz.getName());
        }
    }

    @Override
    public String getName() {
        return "CraftingMapper";
    }

    @Override
    public String getDescription() {
        return "Add Conversions for Crafting Recipes gathered from net.minecraft.item.crafting.RecipeManager";
    }

    private Iterable<CraftingIngredients> getIngredientsFor(IRecipe recipe) {
        ArrayList<Iterable<ItemStack>> variableInputs = new ArrayList<Iterable<ItemStack>>();
        ArrayList<ItemStack> fixedInputs = new ArrayList<ItemStack>();
        for (Object i : recipe.func_192400_c()) {
            Ingredient recipeItem = (Ingredient)i;
            ItemStack[] matches = recipeItem.func_193365_a();
            if (matches.length == 1) {
                fixedInputs.add(matches[0].func_77946_l());
                continue;
            }
            if (matches.length <= 0) continue;
            LinkedList<ItemStack> recipeItemOptions = new LinkedList<ItemStack>();
            for (ItemStack option : matches) {
                recipeItemOptions.add(option.func_77946_l());
            }
            variableInputs.add(recipeItemOptions);
        }
        return Collections.singletonList(new CraftingIngredients(fixedInputs, variableInputs));
    }

    private static class CraftingIngredients {
        public final Iterable<ItemStack> fixedIngredients;
        public final Iterable<Iterable<ItemStack>> multiIngredients;

        public CraftingIngredients(Iterable<ItemStack> fixedIngredients, Iterable<Iterable<ItemStack>> multiIngredients) {
            this.fixedIngredients = fixedIngredients;
            this.multiIngredients = multiIngredients;
        }
    }
}

