/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.emc.nbt;

import java.util.ArrayList;
import java.util.List;
import moze_intel.projecte.api.ItemInfo;
import moze_intel.projecte.api.nbt.INBTProcessor;
import moze_intel.projecte.config.NBTProcessorConfig;
import moze_intel.projecte.emc.EMCMappingHandler;
import moze_intel.projecte.utils.AnnotationHelper;
import moze_intel.projecte.utils.ItemHelper;
import net.minecraft.item.Item;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.ResourceLocation;

public class NBTManager {
    private static final Tag<Item> NBT_WHITELIST_TAG = new ItemTags.Wrapper(new ResourceLocation("projecte", "nbt_whitelist"));
    private static final List<INBTProcessor> processors = new ArrayList<INBTProcessor>();

    public static void loadProcessors() {
        if (processors.isEmpty()) {
            processors.addAll(AnnotationHelper.getNBTProcessors());
            NBTProcessorConfig.setup(processors);
        }
    }

    public static ItemInfo getPersistentInfo(ItemInfo info) {
        if (!info.hasNBT() || info.getItem().func_206844_a(NBT_WHITELIST_TAG) || EMCMappingHandler.hasEmcValue(info)) {
            return info;
        }
        ArrayList<CompoundNBT> persistentNBT = new ArrayList<CompoundNBT>();
        for (INBTProcessor processor : processors) {
            CompoundNBT nbt;
            if (!NBTProcessorConfig.isEnabled(processor) || !processor.hasPersistentNBT() || !NBTProcessorConfig.hasPersistent(processor) || (nbt = processor.getPersistentNBT(info)) == null) continue;
            persistentNBT.add(nbt);
        }
        return ItemInfo.fromItem(info.getItem(), ItemHelper.recombineNBT(persistentNBT));
    }

    public static long getEmcValue(ItemInfo info) {
        long emcValue = EMCMappingHandler.getStoredEmcValue(info);
        if (!info.hasNBT()) {
            return emcValue;
        }
        if (emcValue == 0L && (emcValue = EMCMappingHandler.getStoredEmcValue(ItemInfo.fromItem(info.getItem()))) == 0L) {
            return 0L;
        }
        for (INBTProcessor processor : processors) {
            if (!NBTProcessorConfig.isEnabled(processor)) continue;
            try {
                emcValue = processor.recalculateEMC(info, emcValue);
            }
            catch (ArithmeticException e) {
                return emcValue;
            }
            if (emcValue > 0L) continue;
            return 0L;
        }
        return emcValue;
    }
}

