/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.events;

import java.util.EnumSet;
import java.util.Set;
import moze_intel.projecte.api.ProjectEAPI;
import moze_intel.projecte.gameObjs.container.AlchBagContainer;
import moze_intel.projecte.gameObjs.items.AlchemicalBag;
import moze_intel.projecte.gameObjs.items.IFireProtector;
import moze_intel.projecte.handlers.InternalAbilities;
import moze_intel.projecte.handlers.InternalTimers;
import moze_intel.projecte.utils.PlayerHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

@Mod.EventBusSubscriber(modid="projecte")
public class TickEvents {
    @SubscribeEvent
    public static void playerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            event.player.getCapability(ProjectEAPI.ALCH_BAG_CAPABILITY).ifPresent(provider -> {
                EnumSet<DyeColor> colorsChanged = EnumSet.noneOf(DyeColor.class);
                for (DyeColor color : TickEvents.getBagColorsPresent(event.player)) {
                    IItemHandler inv = provider.getBag(color);
                    for (int i = 0; i < inv.getSlots(); ++i) {
                        ItemStack current = inv.getStackInSlot(i);
                        if (current.func_190926_b()) continue;
                        current.getCapability(ProjectEAPI.ALCH_BAG_ITEM_CAPABILITY).ifPresent(alchBagItem -> {
                            if (alchBagItem.updateInAlchBag(inv, event.player, current)) {
                                colorsChanged.add(color);
                            }
                        });
                    }
                }
                for (DyeColor e : colorsChanged) {
                    ItemStack heldItem;
                    if (event.player.field_71070_bA instanceof AlchBagContainer && (heldItem = event.player.func_184586_b(((AlchBagContainer)event.player.field_71070_bA).hand)).func_77973_b() instanceof AlchemicalBag && ((AlchemicalBag)heldItem.func_77973_b()).color == e) continue;
                    provider.sync(e, (ServerPlayerEntity)event.player);
                }
            });
            if (!event.player.func_130014_f_().field_72995_K) {
                event.player.getCapability(InternalAbilities.CAPABILITY).ifPresent(InternalAbilities::tick);
                event.player.getCapability(InternalTimers.CAPABILITY).ifPresent(InternalTimers::tick);
                if (event.player.func_70027_ad() && TickEvents.shouldPlayerResistFire((ServerPlayerEntity)event.player)) {
                    event.player.func_70066_B();
                }
            }
        }
    }

    public static boolean shouldPlayerResistFire(ServerPlayerEntity player) {
        for (ItemStack stack : player.field_71071_by.field_70460_b) {
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof IFireProtector) || !((IFireProtector)stack.func_77973_b()).canProtectAgainstFire(stack, player)) continue;
            return true;
        }
        for (int i = 0; i <= 8; ++i) {
            ItemStack stack;
            stack = player.field_71071_by.func_70301_a(i);
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof IFireProtector) || !((IFireProtector)stack.func_77973_b()).canProtectAgainstFire(stack, player)) continue;
            return true;
        }
        IItemHandler curios = PlayerHelper.getCurios((PlayerEntity)player);
        if (curios != null) {
            for (int i = 0; i < curios.getSlots(); ++i) {
                ItemStack stack = curios.getStackInSlot(i);
                if (stack.func_190926_b() || !(stack.func_77973_b() instanceof IFireProtector) || !((IFireProtector)stack.func_77973_b()).canProtectAgainstFire(stack, player)) continue;
                return true;
            }
        }
        return false;
    }

    private static Set<DyeColor> getBagColorsPresent(PlayerEntity player) {
        EnumSet<DyeColor> bagsPresent = EnumSet.noneOf(DyeColor.class);
        player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(inv -> {
            for (int i = 0; i < inv.getSlots(); ++i) {
                ItemStack stack = inv.getStackInSlot(i);
                if (stack.func_190926_b() || !(stack.func_77973_b() instanceof AlchemicalBag)) continue;
                bagsPresent.add(((AlchemicalBag)stack.func_77973_b()).color);
            }
        });
        return bagsPresent;
    }
}

