/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.events;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import java.util.List;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.ObjHandler;
import moze_intel.projecte.gameObjs.items.ItemMode;
import moze_intel.projecte.gameObjs.items.PhilosophersStone;
import moze_intel.projecte.utils.WorldTransmutations;
import net.minecraft.block.BlockState;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="projecte", value={Dist.CLIENT})
public class TransmutationRenderingEvent {
    private static final Minecraft mc = Minecraft.func_71410_x();
    private static BlockState transmutationResult;

    @SubscribeEvent
    public static void preDrawHud(RenderGameOverlayEvent.Pre event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.CROSSHAIRS && transmutationResult != null) {
            if (transmutationResult.func_177230_c() instanceof FlowingFluidBlock) {
                ResourceLocation spriteName = ((FlowingFluidBlock)transmutationResult.func_177230_c()).getFluid().getAttributes().getFlowingTexture();
                TextureAtlasSprite sprite = mc.func_147117_R().func_195424_a(spriteName);
                TransmutationRenderingEvent.mc.field_71446_o.func_110577_a(AtlasTexture.field_110575_b);
                BufferBuilder wr = Tessellator.func_178181_a().func_178180_c();
                wr.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                wr.func_181662_b(0.0, 0.0, 0.0).func_187315_a((double)sprite.func_94209_e(), (double)sprite.func_94206_g()).func_181675_d();
                wr.func_181662_b(0.0, 16.0, 0.0).func_187315_a((double)sprite.func_94209_e(), (double)sprite.func_94210_h()).func_181675_d();
                wr.func_181662_b(16.0, 16.0, 0.0).func_187315_a((double)sprite.func_94212_f(), (double)sprite.func_94210_h()).func_181675_d();
                wr.func_181662_b(16.0, 0.0, 0.0).func_187315_a((double)sprite.func_94212_f(), (double)sprite.func_94206_g()).func_181675_d();
                Tessellator.func_178181_a().func_78381_a();
            } else {
                RenderHelper.func_74519_b();
                IBakedModel model = mc.func_175602_ab().func_184389_a(transmutationResult);
                mc.func_175599_af().func_191962_a(new ItemStack((IItemProvider)transmutationResult.func_177230_c(), 1), 0, 0, model);
                RenderHelper.func_74518_a();
            }
        }
    }

    @SubscribeEvent
    public static void onOverlay(DrawBlockHighlightEvent event) {
        ClientPlayerEntity player = TransmutationRenderingEvent.mc.field_71439_g;
        World world = player.func_130014_f_();
        ItemStack stack = player.func_184586_b(Hand.MAIN_HAND);
        if (stack.func_190926_b()) {
            stack = player.func_184586_b(Hand.OFF_HAND);
        }
        if (stack.func_190926_b() || stack.func_77973_b() != ObjHandler.philosStone) {
            transmutationResult = null;
            return;
        }
        Vec3d viewPosition = event.getInfo().func_216785_c();
        double playerX = viewPosition.field_72450_a;
        double playerY = viewPosition.field_72448_b;
        double playerZ = viewPosition.field_72449_c;
        RayTraceResult mop = ((PhilosophersStone)ObjHandler.philosStone).getHitBlock((PlayerEntity)player);
        if (mop instanceof BlockRayTraceResult) {
            BlockRayTraceResult rtr = (BlockRayTraceResult)mop;
            BlockState current = world.func_180495_p(rtr.func_216350_a());
            transmutationResult = WorldTransmutations.getWorldTransmutation(current, player.func_70093_af());
            if (transmutationResult != null) {
                ArrayList<AxisAlignedBB> renderList = new ArrayList<AxisAlignedBB>(1);
                int charge = ((ItemMode)stack.func_77973_b()).getCharge(stack);
                byte mode = ((ItemMode)stack.func_77973_b()).getMode(stack);
                for (BlockPos pos : PhilosophersStone.getAffectedPositions(world, rtr.func_216350_a(), (PlayerEntity)player, rtr.func_216354_b(), mode, charge)) {
                    for (AxisAlignedBB bb : world.func_180495_p(pos).func_196954_c((IBlockReader)world, pos).func_197756_d()) {
                        renderList.add(bb.func_186662_g(0.01).func_72317_d((double)pos.func_177958_n() - playerX, (double)pos.func_177956_o() - playerY, (double)pos.func_177952_p() - playerZ));
                    }
                }
                TransmutationRenderingEvent.drawAll(renderList);
            }
        } else {
            transmutationResult = null;
        }
    }

    private static void drawAll(List<AxisAlignedBB> renderList) {
        GlStateManager.enableBlend();
        GlStateManager.blendFunc((int)770, (int)771);
        GlStateManager.disableTexture();
        GlStateManager.disableCull();
        GlStateManager.disableLighting();
        GlStateManager.depthMask((boolean)false);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)((Boolean)ProjectEConfig.client.pulsatingOverlay.get() != false ? TransmutationRenderingEvent.getPulseProportion() * 0.6f : 0.35f));
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder wr = tess.func_178180_c();
        wr.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        for (AxisAlignedBB b : renderList) {
            wr.func_181662_b(b.field_72340_a, b.field_72337_e, b.field_72339_c).func_181675_d();
            wr.func_181662_b(b.field_72336_d, b.field_72337_e, b.field_72339_c).func_181675_d();
            wr.func_181662_b(b.field_72336_d, b.field_72337_e, b.field_72334_f).func_181675_d();
            wr.func_181662_b(b.field_72340_a, b.field_72337_e, b.field_72334_f).func_181675_d();
            wr.func_181662_b(b.field_72340_a, b.field_72338_b, b.field_72339_c).func_181675_d();
            wr.func_181662_b(b.field_72336_d, b.field_72338_b, b.field_72339_c).func_181675_d();
            wr.func_181662_b(b.field_72336_d, b.field_72338_b, b.field_72334_f).func_181675_d();
            wr.func_181662_b(b.field_72340_a, b.field_72338_b, b.field_72334_f).func_181675_d();
            wr.func_181662_b(b.field_72336_d, b.field_72337_e, b.field_72334_f).func_181675_d();
            wr.func_181662_b(b.field_72340_a, b.field_72337_e, b.field_72334_f).func_181675_d();
            wr.func_181662_b(b.field_72340_a, b.field_72338_b, b.field_72334_f).func_181675_d();
            wr.func_181662_b(b.field_72336_d, b.field_72338_b, b.field_72334_f).func_181675_d();
            wr.func_181662_b(b.field_72336_d, b.field_72338_b, b.field_72339_c).func_181675_d();
            wr.func_181662_b(b.field_72340_a, b.field_72338_b, b.field_72339_c).func_181675_d();
            wr.func_181662_b(b.field_72340_a, b.field_72337_e, b.field_72339_c).func_181675_d();
            wr.func_181662_b(b.field_72336_d, b.field_72337_e, b.field_72339_c).func_181675_d();
            wr.func_181662_b(b.field_72340_a, b.field_72337_e, b.field_72334_f).func_181675_d();
            wr.func_181662_b(b.field_72340_a, b.field_72337_e, b.field_72339_c).func_181675_d();
            wr.func_181662_b(b.field_72340_a, b.field_72338_b, b.field_72339_c).func_181675_d();
            wr.func_181662_b(b.field_72340_a, b.field_72338_b, b.field_72334_f).func_181675_d();
            wr.func_181662_b(b.field_72336_d, b.field_72337_e, b.field_72334_f).func_181675_d();
            wr.func_181662_b(b.field_72336_d, b.field_72337_e, b.field_72339_c).func_181675_d();
            wr.func_181662_b(b.field_72336_d, b.field_72338_b, b.field_72339_c).func_181675_d();
            wr.func_181662_b(b.field_72336_d, b.field_72338_b, b.field_72334_f).func_181675_d();
        }
        tess.func_78381_a();
        GlStateManager.depthMask((boolean)true);
        GlStateManager.enableCull();
        GlStateManager.enableLighting();
        GlStateManager.enableTexture();
        GlStateManager.disableBlend();
    }

    private static float getPulseProportion() {
        return (float)(0.5 * Math.sin((double)System.currentTimeMillis() / 350.0) + 0.5);
    }
}

