/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.blocks;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import moze_intel.projecte.api.ProjectEAPI;
import moze_intel.projecte.gameObjs.tiles.DMPedestalTile;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class Pedestal
extends Block
implements IWaterLoggable {
    private static final VoxelShape SHAPE = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)2.0, (double)13.0), (VoxelShape)VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)6.0, (double)2.0, (double)6.0, (double)10.0, (double)9.0, (double)10.0), (VoxelShape)Block.func_208617_a((double)5.0, (double)9.0, (double)5.0, (double)11.0, (double)10.0, (double)11.0)));

    public Pedestal(Block.Properties props) {
        super(props);
        this.func_180632_j((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((IProperty)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> props) {
        props.func_206894_a(new IProperty[]{BlockStateProperties.field_208198_y});
    }

    @Nonnull
    @Deprecated
    public VoxelShape func_220053_a(@Nonnull BlockState state, @Nonnull IBlockReader world, @Nonnull BlockPos pos, @Nonnull ISelectionContext ctx) {
        return SHAPE;
    }

    private boolean dropItem(World world, BlockPos pos) {
        DMPedestalTile tile;
        ItemStack stack;
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof DMPedestalTile && !(stack = (tile = (DMPedestalTile)te).getInventory().getStackInSlot(0)).func_190926_b()) {
            tile.getInventory().setStackInSlot(0, ItemStack.field_190927_a);
            ItemEntity ent = new ItemEntity(world, (double)pos.func_177958_n(), (double)pos.func_177956_o() + 0.8, (double)pos.func_177952_p());
            ent.func_92058_a(stack);
            world.func_217376_c((Entity)ent);
            return true;
        }
        return false;
    }

    @Deprecated
    public void func_196243_a(BlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            this.dropItem(world, pos);
            super.func_196243_a(state, world, pos, newState, isMoving);
        }
    }

    @Deprecated
    public void func_196270_a(@Nonnull BlockState state, World world, @Nonnull BlockPos pos, @Nonnull PlayerEntity player) {
        if (!world.field_72995_K) {
            this.dropItem(world, pos);
            world.func_184138_a(pos, state, state, 8);
        }
    }

    public boolean removedByPlayer(BlockState state, World world, BlockPos pos, PlayerEntity player, boolean willHarvest, IFluidState fluid) {
        if (player.func_184812_l_() && this.dropItem(world, pos)) {
            world.func_184138_a(pos, state, state, 8);
            return false;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
    }

    @Deprecated
    public boolean func_220051_a(@Nonnull BlockState state, World world, @Nonnull BlockPos pos, @Nonnull PlayerEntity player, @Nonnull Hand hand, @Nonnull BlockRayTraceResult rtr) {
        if (!world.field_72995_K) {
            TileEntity te = world.func_175625_s(pos);
            if (!(te instanceof DMPedestalTile)) {
                return true;
            }
            DMPedestalTile tile = (DMPedestalTile)te;
            ItemStack item = tile.getInventory().getStackInSlot(0);
            ItemStack stack = player.func_184586_b(hand);
            if (stack.func_190926_b() && !item.func_190926_b()) {
                item.getCapability(ProjectEAPI.PEDESTAL_ITEM_CAPABILITY).ifPresent(pedestalItem -> {
                    tile.setActive(!tile.getActive());
                    world.func_184138_a(pos, state, state, 8);
                });
            } else if (!stack.func_190926_b() && item.func_190926_b()) {
                tile.getInventory().setStackInSlot(0, stack.func_77979_a(1));
                if (stack.func_190916_E() <= 0) {
                    player.func_184611_a(hand, ItemStack.field_190927_a);
                }
                world.func_184138_a(pos, state, state, 8);
            }
        }
        return true;
    }

    @Deprecated
    public void func_220069_a(@Nonnull BlockState state, World world, @Nonnull BlockPos pos, @Nonnull Block neighbor, @Nonnull BlockPos neighborPos, boolean isMoving) {
        boolean flag = world.func_175640_z(pos);
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof DMPedestalTile) {
            DMPedestalTile ped = (DMPedestalTile)te;
            if (ped.previousRedstoneState != flag) {
                ItemStack stack;
                if (flag && !(stack = ped.getInventory().getStackInSlot(0)).func_190926_b()) {
                    stack.getCapability(ProjectEAPI.PEDESTAL_ITEM_CAPABILITY).ifPresent(pedestalItem -> {
                        ped.setActive(!ped.getActive());
                        world.func_184138_a(pos, state, state, 11);
                    });
                }
                ped.previousRedstoneState = flag;
            }
        }
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(@Nonnull BlockState state, @Nonnull IBlockReader world) {
        return new DMPedestalTile();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(@Nonnull ItemStack stack, @Nullable IBlockReader world, List<ITextComponent> tooltip, @Nonnull ITooltipFlag flags) {
        tooltip.add((ITextComponent)new TranslationTextComponent("pe.pedestal.tooltip1", new Object[0]));
        tooltip.add((ITextComponent)new TranslationTextComponent("pe.pedestal.tooltip2", new Object[0]));
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState state = super.func_196258_a(context);
        return state == null ? null : (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(context.func_195991_k().func_204610_c(context.func_195995_a()).func_206886_c() == Fluids.field_204546_a));
    }

    @Nonnull
    @Deprecated
    public IFluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)BlockStateProperties.field_208198_y) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    @Nonnull
    @Deprecated
    public BlockState func_196271_a(BlockState state, Direction facing, @Nonnull BlockState facingState, @Nonnull IWorld world, @Nonnull BlockPos currentPos, @Nonnull BlockPos facingPos) {
        if (((Boolean)state.func_177229_b((IProperty)BlockStateProperties.field_208198_y)).booleanValue()) {
            world.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        return super.func_196271_a(state, facing, facingState, world, currentPos, facingPos);
    }
}

